package yangtz.cs.liu.campus.service.impl.schoolSecurity;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolSecurity.SchoolVehicleRegistration;
import yangtz.cs.liu.campus.mapper.schoolSecurity.SchoolVehicleRegistrationMapper;
import yangtz.cs.liu.campus.service.schoolSecurity.ISchoolVehicleRegistrationService;

import java.util.List;

/**
 * 车辆登记Service业务层处理
 *
 * @author ruoyi
 * @date 2023-09-11
 */
@Service
public class SchoolVehicleRegistrationServiceImpl extends ServiceImpl<SchoolVehicleRegistrationMapper,SchoolVehicleRegistration> implements ISchoolVehicleRegistrationService
{

    @Autowired
    private SchoolVehicleRegistrationMapper schoolVehicleRegistrationMapper;

    /**
     * 查询车辆登记
     *
     * @param id 车辆登记主键
     * @return 车辆登记
     */
    @Override
    public SchoolVehicleRegistration selectSchoolVehicleRegistrationById(Long id)
    {
        return schoolVehicleRegistrationMapper.selectSchoolVehicleRegistrationById(id);
    }

    /**
     * 查询车辆登记列表
     *
     * @param schoolVehicleRegistration 车辆登记
     * @return 车辆登记
     */
    @Override
    public List<SchoolVehicleRegistration> selectSchoolVehicleRegistrationList(SchoolVehicleRegistration schoolVehicleRegistration)
    {
        return schoolVehicleRegistrationMapper.selectSchoolVehicleRegistrationList(schoolVehicleRegistration);
    }

    /**
     * 新增车辆登记
     *
     * @param schoolVehicleRegistration 车辆登记
     * @return 结果
     */
    @Override
    public int insertSchoolVehicleRegistration(SchoolVehicleRegistration schoolVehicleRegistration)
    {
        schoolVehicleRegistration.setCreateTime(DateUtils.getNowDate());
        return schoolVehicleRegistrationMapper.insertSchoolVehicleRegistration(schoolVehicleRegistration);
    }

    /**
     * 修改车辆登记
     *
     * @param schoolVehicleRegistration 车辆登记
     * @return 结果
     */
    @Override
    public int updateSchoolVehicleRegistration(SchoolVehicleRegistration schoolVehicleRegistration)
    {
        schoolVehicleRegistration.setUpdateTime(DateUtils.getNowDate());
        return schoolVehicleRegistrationMapper.updateSchoolVehicleRegistration(schoolVehicleRegistration);
    }

    /**
     * 批量删除车辆登记
     *
     * @param ids 需要删除的车辆登记主键
     * @return 结果
     */
    @Override
    public int deleteSchoolVehicleRegistrationByIds(Long[] ids)
    {
        return schoolVehicleRegistrationMapper.deleteSchoolVehicleRegistrationByIds(ids);
    }

    /**
     * 删除车辆登记信息
     *
     * @param id 车辆登记主键
     * @return 结果
     */
    @Override
    public int deleteSchoolVehicleRegistrationById(Long id)
    {
        return schoolVehicleRegistrationMapper.deleteSchoolVehicleRegistrationById(id);
    }
}
