package yangtz.cs.liu.campus.service.impl.schoolLab;

import java.util.*;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolExperimentPlanClass;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabClassYear;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabClassYearRelation;
import yangtz.cs.liu.campus.mapper.accessory.AccessoryMapper;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassMapper;
import yangtz.cs.liu.campus.mapper.schoolLab.SchoolExperimentPlanMapper;
import yangtz.cs.liu.campus.mapper.schoolLab.SchoolLabClassYearMapper;
import yangtz.cs.liu.campus.mapper.schoolLab.SchoolLabClassYearRelationMapper;
import yangtz.cs.liu.campus.mapper.schoolLab.SchoolTeacherLabApplyMapper;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherLabApply;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolExperimentPlanService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolTeacherLabApplyService;
import yangtz.cs.liu.campus.vo.schoolLab.ClassSituationVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolExperimentPlanVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabClassYearVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherLabApplyVo;

/**
 * 教师实验室申请Service业务层处理
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@Service
public class SchoolTeacherLabApplyServiceImpl extends ServiceImpl<SchoolTeacherLabApplyMapper,SchoolTeacherLabApply> implements ISchoolTeacherLabApplyService
{
    @Autowired
    private SchoolTeacherLabApplyMapper schoolTeacherLabApplyMapper;
    @Autowired
    private SchoolLabClassYearMapper schoolLabClassYearMapper;
    @Autowired
    private SchoolLabClassYearRelationMapper schoolLabClassYearRelationMapper;
    @Autowired
    private AccessoryMapper accessoryMapper;
    @Autowired
    private ISchoolExperimentPlanService schoolExperimentPlanService;

    @Autowired
    private SchoolClassMapper schoolClassMapper;
    /**
     * 查询教师实验室申请
     *
     * @param id 教师实验室申请主键
     * @return 教师实验室申请
     */
    @Override
    public SchoolTeacherLabApplyVo selectSchoolTeacherLabApplyById(Long id)
    {
        return schoolTeacherLabApplyMapper.selectSchoolTeacherLabApplyById(id);
    }

    /**
     * 查询教师实验室申请列表
     *
     * @param schoolTeacherLabApplyVo 教师实验室申请
     * @return 教师实验室申请
     */
    @Override
    public List<SchoolTeacherLabApplyVo> selectSchoolTeacherLabApplyList(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo)
    {
        return schoolTeacherLabApplyMapper.selectSchoolTeacherLabApplyList(schoolTeacherLabApplyVo);
    }

    /**
     * 新增教师实验室申请
     *
     * @param schoolTeacherLabApplyVo 教师实验室申请
     * @return 结果
     */
    @Override
    public int insertSchoolTeacherLabApply(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolTeacherLabApplyVo.setApplyId(user.getUserId());
        schoolTeacherLabApplyVo.setApplyName(user.getUserName());
        schoolTeacherLabApplyVo.setApplyTime(DateUtils.getNowDate());
        schoolTeacherLabApplyVo.setCreateBy(user.getUserName());
        schoolTeacherLabApplyVo.setCreateTime(DateUtils.getNowDate());
        return schoolTeacherLabApplyMapper.insertSchoolTeacherLabApply(schoolTeacherLabApplyVo);
    }

    /**
     * 修改教师实验室申请
     *
     * @param schoolTeacherLabApplyVo 教师实验室申请
     * @return 结果
     */
    @Override
    public int updateSchoolTeacherLabApply(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo)
    {
        schoolTeacherLabApplyVo.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolTeacherLabApplyVo.setUpdateTime(DateUtils.getNowDate());
        return schoolTeacherLabApplyMapper.updateSchoolTeacherLabApply(schoolTeacherLabApplyVo);
    }

    /**
     * 批量删除教师实验室申请
     *
     * @param ids 需要删除的教师实验室申请主键
     * @return 结果
     */
    @Override
    public int deleteSchoolTeacherLabApplyByIds(Long[] ids)
    {
        schoolTeacherLabApplyMapper.deleteSchoolAccessoryByBusinessIds(ids);
        return schoolTeacherLabApplyMapper.deleteSchoolTeacherLabApplyByIds(ids);
    }

    /**
     * 删除教师实验室申请信息
     *
     * @param id 教师实验室申请主键
     * @return 结果
     */
    @Override
    public int deleteSchoolTeacherLabApplyById(Long id)
    {
        schoolTeacherLabApplyMapper.deleteSchoolAccessoryByBusinessId(id);
        return schoolTeacherLabApplyMapper.deleteSchoolTeacherLabApplyById(id);
    }

    /**
     * 获取实验室使用状态
     * @param schoolTeacherLabApplyVo
     * @return
     */
    @Override
    public List<Map<String, Object>> getTeacherLab(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo) {
        //判断实验时间是否在计划之间之内
        SchoolLabClassYearVo schoolLabClassYear = schoolLabClassYearMapper.selectSchoolLabClassYearById(schoolTeacherLabApplyVo.getLabClassYearId());
        //计划开始时间
        Date plannedStartTime = schoolLabClassYear.getPlannedStartTime();
        //计划结束时间
        Date plannedEndTime = schoolLabClassYear.getPlannedEndTime();
        //实验时间
        Date experimentTime = schoolTeacherLabApplyVo.getExperimentTime();

        if (experimentTime.before(plannedStartTime) || experimentTime.after(plannedEndTime)){
            throw new ServiceException("请选择计划时间内的时间");
        }
        //返回集合
        List<Map<String, Object>> list = new ArrayList<>();

        //查询该年级实验室预约中已经分配的实验室id
        LambdaQueryWrapper<SchoolLabClassYearRelation> wrapper1 = new LambdaQueryWrapper<>();
        wrapper1.eq(SchoolLabClassYearRelation::getLabClassYearId,schoolTeacherLabApplyVo.getLabClassYearId());
        List<SchoolLabClassYearRelation> schoolLabClassYearRelations = schoolLabClassYearRelationMapper.selectList(wrapper1);

        //根据日期和节次查询正在使用的实验室
        LambdaQueryWrapper<SchoolTeacherLabApply> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(SchoolTeacherLabApply::getLabClassYearId,schoolTeacherLabApplyVo.getLabClassYearId())
                .eq(SchoolTeacherLabApply::getExperimentTime,schoolTeacherLabApplyVo.getExperimentTime())
                .eq(SchoolTeacherLabApply::getSection,schoolTeacherLabApplyVo.getSection());
        List<SchoolTeacherLabApply> schoolTeacherLabApplies = schoolTeacherLabApplyMapper.selectList(wrapper2);

        //判断哪些实验室在使用中
        if (schoolTeacherLabApplies.size() > 0){
            for (SchoolLabClassYearRelation schoolLabClassYearRelation : schoolLabClassYearRelations) {
                Map<String,Object> map = new HashMap<>();
                map.put("labId",schoolLabClassYearRelation.getLabId());
                map.put("labName",schoolLabClassYearRelation.getLabName());
                for (SchoolTeacherLabApply schoolTeacherLabApply : schoolTeacherLabApplies) {
                    if (schoolLabClassYearRelation.getLabId().equals(schoolTeacherLabApply.getLabId())){
                        map.put("useState","使用中");
                        break;
                    }else {
                        map.put("useState","空闲");
                    }
                }
                list.add(map);
            }
            return list;
        }
        for (SchoolLabClassYearRelation schoolLabClassYearRelation : schoolLabClassYearRelations) {
            Map<String, Object> map = new HashMap<>();
            map.put("labId",schoolLabClassYearRelation.getLabId());
            map.put("labName",schoolLabClassYearRelation.getLabName());
            map.put("useState","空闲");
            list.add(map);
        }
        return list;
    }

    /**
     * 获取班级
     * @param schoolTeacherLabApplyVo
     * @return
     */
    @Override
    public List<Map<String, Object>> getTeacherClass(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo,SysUser sysUser) {
        SysUser user = null;
        if (null == sysUser){
            user = SecurityUtils.getLoginUser().getUser();

        }else {
            user = sysUser;
        }
        //如果是管理员，返回该实验计划所有班级
        if (user.isAdmin()){
            return schoolTeacherLabApplyMapper.getTeacherClassAll(schoolTeacherLabApplyVo);
        }
        //如果是教师，返回该教师对应的班级
        schoolTeacherLabApplyVo.setTeacherId(user.getUserId());
        return schoolTeacherLabApplyMapper.getTeacherClass(schoolTeacherLabApplyVo);
    }

    /**
     * 上传附件
     * @param schoolTeacherLabApplyVo
     * @return
     */
    @Override
    public int updateTeacherLab(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo) {
        //教师实验室预约id
        Long id = schoolTeacherLabApplyVo.getId();
        //附件信息集合
        List<SchoolAccessory> schoolAccessoryList = schoolTeacherLabApplyVo.getSchoolAccessoryList();

        List<SchoolAccessory> list = new ArrayList<>();
        for (SchoolAccessory schoolAccessory : schoolAccessoryList) {
            schoolAccessory.setBusinessId(id);
            schoolAccessory.setModuleName("教师-教师实验室记录");
            schoolAccessory.setAccessoryType("教师实验室附件");
            schoolAccessory.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
            schoolAccessory.setCreateTime(DateUtils.getNowDate());
            list.add(schoolAccessory);
        }

        if (list.size() > 0){
            schoolTeacherLabApplyMapper.batchSchoolAccessory(list);
        }
        SchoolTeacherLabApply schoolTeacherLabApply = new SchoolTeacherLabApply();
        schoolTeacherLabApply.setId(id);
        schoolTeacherLabApply.setState("1");
        return schoolTeacherLabApplyMapper.updateById(schoolTeacherLabApply);
    }

    /**
     * 实验室管理-教师申请列表
     * @param schoolTeacherLabApplyVo
     * @return
     */
    @Override
    public List<SchoolTeacherLabApplyVo> getTeacherLabApplyList(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo) {
        //获取登录用户
        SysUser user = SecurityUtils.getLoginUser().getUser();
        if (user.isAdmin()){
            List<SchoolTeacherLabApplyVo> schoolTeacherLabApplyVos = schoolTeacherLabApplyMapper.selectSchoolTeacherLabApplyList(schoolTeacherLabApplyVo);
            for (SchoolTeacherLabApplyVo teacherLabApplyVo : schoolTeacherLabApplyVos) {
                LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(SchoolAccessory::getBusinessId,teacherLabApplyVo.getId())
                        .eq(SchoolAccessory::getAccessoryType,"教师实验室附件");
                List<SchoolAccessory> schoolAccessories = accessoryMapper.selectList(wrapper);
                if (schoolAccessories.size() > 0){
                    teacherLabApplyVo.setSchoolAccessoryList(schoolAccessories);
                }
                String semester = "";
                if (teacherLabApplyVo.getSemester().equals("1")){
                    semester = "上学期";
                }else {
                    semester = "下学期";
                }
                teacherLabApplyVo.setSchoolYearSemester(teacherLabApplyVo.getSchoolYear() + semester);
            }
            return schoolTeacherLabApplyVos;
        }
        //管理员通道
        List<String> subs = new ArrayList<>();
        List<SysRole> roles = user.getRoles();
        for (SysRole role : roles) {
            if (role.getRoleKey().equals("admin")) {
                List<SchoolTeacherLabApplyVo> schoolTeacherLabApplyVos = schoolTeacherLabApplyMapper.selectSchoolTeacherLabApplyList(schoolTeacherLabApplyVo);
                for (SchoolTeacherLabApplyVo teacherLabApplyVo : schoolTeacherLabApplyVos) {
                    LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(SchoolAccessory::getBusinessId,teacherLabApplyVo.getId())
                            .eq(SchoolAccessory::getAccessoryType,"教师实验室附件");
                    List<SchoolAccessory> schoolAccessories = accessoryMapper.selectList(wrapper);
                    if (schoolAccessories.size() > 0){
                        teacherLabApplyVo.setSchoolAccessoryList(schoolAccessories);
                    }
                    String semester = "";
                    if (teacherLabApplyVo.getSemester().equals("1")){
                        semester = "上学期";
                    }else {
                        semester = "下学期";
                    }
                    teacherLabApplyVo.setSchoolYearSemester(teacherLabApplyVo.getSchoolYear() + semester);
                }
                return schoolTeacherLabApplyVos;
            }
            switch (role.getRoleKey()){
                case "phy_lab_admin":
                    subs.add("1");
                    break;
                case "che_lab_admin":
                    subs.add("2");
                    break;
                case "bio_lab_admin":
                    subs.add("3");
                    break;
                default:break;
            }
        }
        if (subs.size() > 0){
            schoolTeacherLabApplyVo.setSubs(subs);
        }
        List<SchoolTeacherLabApplyVo> schoolTeacherLabApplyVos = schoolTeacherLabApplyMapper.selectSchoolTeacherLabApplyList(schoolTeacherLabApplyVo);
        for (SchoolTeacherLabApplyVo teacherLabApplyVo : schoolTeacherLabApplyVos) {
            LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolAccessory::getBusinessId,teacherLabApplyVo.getId())
                    .eq(SchoolAccessory::getAccessoryType,"教师实验室附件");
            List<SchoolAccessory> schoolAccessories = accessoryMapper.selectList(wrapper);
            if (schoolAccessories.size() > 0){
                teacherLabApplyVo.setSchoolAccessoryList(schoolAccessories);
            }
            String semester = "";
            if (teacherLabApplyVo.getSemester().equals("1")){
                semester = "上学期";
            }else {
                semester = "下学期";
            }
            teacherLabApplyVo.setSchoolYearSemester(teacherLabApplyVo.getSchoolYear() + semester);
        }
        return schoolTeacherLabApplyVos;
    }

    /**
     * 实验室管理-教师申请审批确认
     * @param schoolTeacherLabApply
     * @return
     */
    @Override
    public int updateState(SchoolTeacherLabApply schoolTeacherLabApply) {
        return schoolTeacherLabApplyMapper.updateById(schoolTeacherLabApply);
    }

    /**
     * 查看班级完成详情
     * @param schoolTeacherLabApplyVo
     * @return
     */
    @Override
    public List<Map<String, Object>> getClassDetails(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo) {
        List<Map<String, Object>> classDetails = schoolTeacherLabApplyMapper.getClassDetails(schoolTeacherLabApplyVo);
        classDetails.forEach(classDetails1 -> {
            LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolAccessory::getBusinessId,classDetails1.get("id"))
                    .eq(SchoolAccessory::getAccessoryType,"教师实验室附件");
            List<SchoolAccessory> schoolAccessories = accessoryMapper.selectList(wrapper);
            if (schoolAccessories.size() > 0){
                classDetails1.put("schoolAccessories",schoolAccessories);
            }
        });
        return classDetails;
    }

    /**
     * 教师实验统计
     * @param schoolTeacherLabApplyVo
     * @return
     */
    @Override
    public List<Map<String, Object>> getCountTeacher(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo) {
        return schoolTeacherLabApplyMapper.getCountTeacher(schoolTeacherLabApplyVo);
    }

    /**
     * 级部-班级完成情况明细
     * @param schoolTeacherLabApplyVo
     * @return
     */
    @Override
    public List<Map<String, Object>> gradeCountClass(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo) {
        return schoolTeacherLabApplyMapper.gradeCountClass(schoolTeacherLabApplyVo);
    }

    /**
     * 级部-班级完成情况明细-查看班级完成情况详情
     * @param schoolTeacherLabApplyVo
     * @return
     */
    @Override
    public List<SchoolTeacherLabApplyVo> getGradeClassDetails(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo) {
        List<SchoolTeacherLabApplyVo> list = schoolTeacherLabApplyMapper.getGradeClassDetails(schoolTeacherLabApplyVo);
        list.forEach(list1 -> {
            String semester = "";
            if (list1.getSemester().equals("1")){
                semester = "上学期";
            }else {
                semester = "下学期";
            }
            list1.setSchoolYearSemester(list1.getSchoolYear() + semester);
        });
        return list;
    }

    /**
     * xwh-新增教师申请
     * @param schoolTeacherLabApplyVo
     * @return
     */
    @Override
    @Transactional
    public int insertSchoolTeacherLabApplyVo(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo) {
        //判断选择的班级是否存在此次实验
        LambdaQueryWrapper<SchoolTeacherLabApply> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolTeacherLabApply::getClassId,schoolTeacherLabApplyVo.getClassId())
                .eq(SchoolTeacherLabApply::getLabClassYearId,schoolTeacherLabApplyVo.getLabClassYearId());
        SchoolTeacherLabApply schoolTeacherLabApply = schoolTeacherLabApplyMapper.selectOne(lqw);
        if (StringUtils.isNotNull(schoolTeacherLabApply)){
            throw new ServiceException("已存在该班级此次实验申请");
        }
        //判断实验时间是否在计划之间之内
        SchoolLabClassYearVo schoolLabClassYear = schoolLabClassYearMapper.selectSchoolLabClassYearById(schoolTeacherLabApplyVo.getLabClassYearId());
        //计划开始时间
        Date plannedStartTime = schoolLabClassYear.getPlannedStartTime();
        //计划结束时间
        Date plannedEndTime = schoolLabClassYear.getPlannedEndTime();
        //实验时间
        Date experimentTime = schoolTeacherLabApplyVo.getExperimentTime();

        if (experimentTime.before(plannedStartTime) || experimentTime.after(plannedEndTime)){
            throw new ServiceException("请选择计划时间内的时间");
        }
        //判断是否选择了实验室
        if (StringUtils.isNull(schoolTeacherLabApplyVo.getLabId())){
            throw new ServiceException("请选择实验室");
        }
        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolTeacherLabApplyVo.setChapterContent(schoolLabClassYear.getChapterContent());
        schoolTeacherLabApplyVo.setApplyId(user.getUserId());
        schoolTeacherLabApplyVo.setApplyName(user.getUserName());
        schoolTeacherLabApplyVo.setApplyTime(DateUtils.getNowDate());
        schoolTeacherLabApplyVo.setCreateBy(user.getUserName());
        schoolTeacherLabApplyVo.setCreateTime(DateUtils.getNowDate());
        return schoolTeacherLabApplyMapper.insertSchoolTeacherLabApply(schoolTeacherLabApplyVo);
    }

    /**
     * xwh-修改教师申请
     * @param schoolTeacherLabApplyVo
     * @return
     */
    @Override
    @Transactional
    public int updateSchoolTeacherLabApplyVo(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo) {
        //判断实验时间是否在计划之间之内
        SchoolLabClassYearVo schoolLabClassYear = schoolLabClassYearMapper.selectSchoolLabClassYearById(schoolTeacherLabApplyVo.getLabClassYearId());
        //计划开始时间
        Date plannedStartTime = schoolLabClassYear.getPlannedStartTime();
        //计划结束时间
        Date plannedEndTime = schoolLabClassYear.getPlannedEndTime();
        //实验时间
        Date experimentTime = schoolTeacherLabApplyVo.getExperimentTime();

        if (experimentTime.before(plannedStartTime) || experimentTime.after(plannedEndTime)){
            throw new ServiceException("请选择计划时间内的时间");
        }
        schoolTeacherLabApplyVo.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolTeacherLabApplyVo.setUpdateTime(DateUtils.getNowDate());
        return schoolTeacherLabApplyMapper.updateSchoolTeacherLabApply(schoolTeacherLabApplyVo);
    }

    /**
     * 获取班级详情
     * @param one
     * @return
     */
    @Override
    public List<SchoolTeacherLabApplyVo> getTeacherExperimentList(ClassSituationVo one) {
        SchoolTeacherLabApplyVo schoolTeacherLabApply = new SchoolTeacherLabApplyVo();
        schoolTeacherLabApply.setLabClassYearId(one.getLabClassYearId());
        schoolTeacherLabApply.setSchoolYear(one.getSchoolYear().toString());
        schoolTeacherLabApply.setSemester(one.getSemester());
        schoolTeacherLabApply.setExperimentTime(StringUtils.isNull(one.getExperimentTime())? null:  new Date(one.getExperimentTime()));
        schoolTeacherLabApply.setState(StringUtils.isNull(one.getState())? null:  one.getState());
        schoolTeacherLabApply.setClassName(StringUtils.isNull(one.getClassName())? null: one.getClassName());
        //1.已经进行的班级
        List<SchoolTeacherLabApplyVo> schoolTeacherLabApplies = schoolTeacherLabApplyMapper.selectSchoolTeacherLabApplyList(
                schoolTeacherLabApply);
        //2.找出未进行中得班级
        SchoolLabClassYearVo schoolLabClassYearVo = schoolLabClassYearMapper.selectSchoolLabClassYearById(
            one.getLabClassYearId());
        SchoolExperimentPlanVo schoolExperimentPlanVo = schoolExperimentPlanService.selectSchoolExperimentPlanById(
            schoolLabClassYearVo.getExperimentPlanId());
        List<SchoolExperimentPlanClass> schoolExperimentPlanClassList = schoolExperimentPlanVo.getSchoolExperimentPlanClassList();
        //有记录
        List<String> nameList  = schoolTeacherLabApplies.stream().map(o -> o.getClassId()).collect(Collectors.toList());
        //无记录
        List<Long> collect = schoolExperimentPlanClassList.stream()
            .map(SchoolExperimentPlanClass::getClassId).collect(Collectors.toList());
        List<String> classList = new ArrayList<>();
        for (Long classId :collect){
            if (!nameList.contains(classId.toString())){
                classList.add(classId.toString());
            }
        }

        classList.forEach(id ->{
            SchoolTeacherLabApplyVo schoolTeacherLabApplyVo = new SchoolTeacherLabApplyVo();
            schoolTeacherLabApplyVo.setClassId(id);
            schoolTeacherLabApplyVo.setClassName(schoolClassMapper.selectById(id).getClassName());
            schoolTeacherLabApplyVo.setState("0");
            schoolTeacherLabApplies.add(schoolTeacherLabApplyVo);
        });
        return schoolTeacherLabApplies;
    }

    /**
     * 教师实验统计
     * @param
     * @return
     */
    @Override
    public List<Map<String, String>> selectTeacherList(SchoolTeacherLabApply schoolTeacherLabApply) {
        List<Map<String, String>> maps = schoolTeacherLabApplyMapper.selectTeacherList(
                schoolTeacherLabApply);
        return maps;
    }



}
