package yangtz.cs.liu.campus.service.impl.schoolInstrument;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.schoolInstrument.*;
import yangtz.cs.liu.campus.mapper.schoolInstrument.*;
import yangtz.cs.liu.campus.service.schoolInstrument.ISchoolTeacherBorrowService;
import yangtz.cs.liu.campus.vo.schoolInstrument.SchoolTeacherBorrowVo;

import java.util.ArrayList;
import java.util.List;

/**
 * 教师借用Service业务层处理
 *
 * @author ruoyi
 * @date 2023-09-06
 */
@Service
public class SchoolTeacherBorrowServiceImpl extends ServiceImpl<SchoolTeacherBorrowMapper, SchoolTeacherBorrow> implements ISchoolTeacherBorrowService {

    @Autowired
    private SchoolTeacherBorrowMapper schoolTeacherBorrowMapper;
    @Autowired
    private SchoolTeacherBorrowDetailMapper schoolTeacherBorrowDetailMapper;
    @Autowired
    private SchoolInstrumentMapper schoolInstrumentMapper;
    @Autowired
    private SchoolInstrumentClassifyMapper schoolInstrumentClassifyMapper;
    @Autowired
    private SchoolInstrumentDetailMapper schoolInstrumentDetailMapper;

    /**
     * 查询教师借用
     *
     * @param id 教师借用主键
     * @return 教师借用
     */
    @Override
    public SchoolTeacherBorrowVo selectSchoolTeacherBorrowById(Long id)
    {
        SchoolTeacherBorrowVo schoolTeacherBorrowVo = schoolTeacherBorrowMapper.selectSchoolTeacherBorrowById(id);
        LambdaQueryWrapper<SchoolTeacherBorrowDetail> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolTeacherBorrowDetail::getTeacherBorrowId,schoolTeacherBorrowVo.getId());
        List<SchoolTeacherBorrowDetail> schoolTeacherBorrowDetails = schoolTeacherBorrowDetailMapper.selectList(wrapper);
        if (schoolTeacherBorrowDetails.size() > 0){
            schoolTeacherBorrowVo.setSchoolTeacherBorrowDetailList(schoolTeacherBorrowDetails);
        }
        return schoolTeacherBorrowVo;
    }

    /**
     * 查询教师借用列表
     *
     * @param schoolTeacherBorrowVo 教师借用
     * @return 教师借用
     */
    @Override
    public List<SchoolTeacherBorrowVo> selectSchoolTeacherBorrowList(SchoolTeacherBorrowVo schoolTeacherBorrowVo)
    {
        schoolTeacherBorrowVo.setBorrowById(SecurityUtils.getLoginUser().getUser().getUserId());
        List<SchoolTeacherBorrowVo> schoolTeacherBorrowVos = schoolTeacherBorrowMapper.selectSchoolTeacherBorrowList(schoolTeacherBorrowVo);
        for (SchoolTeacherBorrowVo schoolTeacherBorrowVo1 : schoolTeacherBorrowVos) {
            LambdaQueryWrapper<SchoolTeacherBorrowDetail> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolTeacherBorrowDetail::getTeacherBorrowId,schoolTeacherBorrowVo1.getId());
            List<SchoolTeacherBorrowDetail> schoolTeacherBorrowDetails = schoolTeacherBorrowDetailMapper.selectList(wrapper);
            if (schoolTeacherBorrowDetails.size() > 0){
                schoolTeacherBorrowVo1.setSchoolTeacherBorrowDetailList(schoolTeacherBorrowDetails);
            }
        }
        return schoolTeacherBorrowVos;
    }

    /**
     * 新增教师借用
     *
     * @param schoolTeacherBorrowVo 教师借用
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSchoolTeacherBorrow(SchoolTeacherBorrowVo schoolTeacherBorrowVo)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolTeacherBorrowVo.setBorrowById(user.getUserId());
        schoolTeacherBorrowVo.setBorrowBy(user.getUserName());
        schoolTeacherBorrowVo.setBorrowTime(DateUtils.getNowDate());
        schoolTeacherBorrowVo.setApplyTime(DateUtils.getNowDate());
        schoolTeacherBorrowVo.setCreateBy(user.getUserName());
        schoolTeacherBorrowVo.setCreateTime(DateUtils.getNowDate());
        int rows = schoolTeacherBorrowMapper.insertSchoolTeacherBorrow(schoolTeacherBorrowVo);
        insertSchoolTeacherBorrowDetail(schoolTeacherBorrowVo);
        return rows;
    }

    /**
     * 办理教师借用
     *
     * @param schoolTeacherBorrowVo 教师借用
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSchoolTeacherBorrow(SchoolTeacherBorrowVo schoolTeacherBorrowVo)
    {
        schoolTeacherBorrowVo.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolTeacherBorrowVo.setUpdateTime(DateUtils.getNowDate());
        //修改状态为未归还
        schoolTeacherBorrowVo.setBorrowState("0");
        schoolTeacherBorrowMapper.deleteSchoolTeacherBorrowDetailByTeacherBorrowId(schoolTeacherBorrowVo.getId());
        insertSchoolTeacherBorrowDetailSp(schoolTeacherBorrowVo);
        return schoolTeacherBorrowMapper.updateSchoolTeacherBorrow(schoolTeacherBorrowVo);
    }

    /**
     * 批量删除教师借用
     *
     * @param ids 需要删除的教师借用主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSchoolTeacherBorrowByIds(Long[] ids)
    {
        schoolTeacherBorrowMapper.deleteSchoolTeacherBorrowDetailByTeacherBorrowIds(ids);
        return schoolTeacherBorrowMapper.deleteSchoolTeacherBorrowByIds(ids);
    }

    /**
     * 删除教师借用信息
     *
     * @param id 教师借用主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSchoolTeacherBorrowById(Long id)
    {
        schoolTeacherBorrowMapper.deleteSchoolTeacherBorrowDetailByTeacherBorrowId(id);
        return schoolTeacherBorrowMapper.deleteSchoolTeacherBorrowById(id);
    }

    /**
     * 仓库借用管理列表
     * @param schoolTeacherBorrowVo
     * @return
     */
    @Override
    public List<SchoolTeacherBorrowVo> selectBorrowInstrumentList(SchoolTeacherBorrowVo schoolTeacherBorrowVo) {
        List<SchoolTeacherBorrowVo> schoolTeacherBorrowVos = schoolTeacherBorrowMapper.selectSchoolTeacherBorrowList(schoolTeacherBorrowVo);
        for (SchoolTeacherBorrowVo schoolTeacherBorrowVo1 : schoolTeacherBorrowVos) {
            LambdaQueryWrapper<SchoolTeacherBorrowDetail> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolTeacherBorrowDetail::getTeacherBorrowId,schoolTeacherBorrowVo1.getId());
            List<SchoolTeacherBorrowDetail> schoolTeacherBorrowDetails = schoolTeacherBorrowDetailMapper.selectList(wrapper);
            if (schoolTeacherBorrowDetails.size() > 0){
                schoolTeacherBorrowVo1.setSchoolTeacherBorrowDetailList(schoolTeacherBorrowDetails);
            }
        }
        return schoolTeacherBorrowVos;
    }

    /**
     * 归还教师借出仪器
     * @param schoolTeacherBorrowVo
     * @return
     */
    @Override
    public int returnInstrument(SchoolTeacherBorrowVo schoolTeacherBorrowVo) {
        schoolTeacherBorrowVo.setReturnTime(DateUtils.getNowDate());
        SchoolTeacherBorrow schoolTeacherBorrow = new SchoolTeacherBorrow();
        BeanUtils.copyProperties(schoolTeacherBorrowVo,schoolTeacherBorrow);
        updateSchoolTeacherBorrowDetail(schoolTeacherBorrowVo);
        return schoolTeacherBorrowMapper.updateById(schoolTeacherBorrow);
    }

    /**
     * 批量修改归还仪器信息
     * @param schoolTeacherBorrowVo
     */
    public void updateSchoolTeacherBorrowDetail(SchoolTeacherBorrowVo schoolTeacherBorrowVo)
    {
        List<SchoolTeacherBorrowDetail> schoolTeacherBorrowDetailList = schoolTeacherBorrowVo.getSchoolTeacherBorrowDetailList();
        if (StringUtils.isNotNull(schoolTeacherBorrowDetailList))
        {
            List<SchoolTeacherBorrowDetail> list = new ArrayList<SchoolTeacherBorrowDetail>();
            for (SchoolTeacherBorrowDetail schoolTeacherBorrowDetail : schoolTeacherBorrowDetailList)
            {
                SchoolTeacherBorrowDetail schoolTeacherBorrowDetail1 = schoolTeacherBorrowDetailMapper.selectById(schoolTeacherBorrowDetail.getId());

                //判断借用数量是否大于设备数量
                if (schoolTeacherBorrowDetail1.getBorrowNum() < schoolTeacherBorrowDetail.getDamageNum()){
                    throw new ServiceException("损坏数量大于借用数量,请您重新输入");
                }
                //根据仪器id获取仪器信息
                Long instrumentId = schoolTeacherBorrowDetail1.getInstrumentId();
                SchoolInstrument schoolInstrument = schoolInstrumentMapper.selectById(instrumentId);

                //如借出消耗品，不需归还
                Long instrumentTypeId = schoolInstrument.getInstrumentTypeId();
                SchoolInstrumentClassify schoolInstrumentClassify = schoolInstrumentClassifyMapper.selectById(instrumentTypeId);
                if (schoolInstrumentClassify.getIsConsumables().equals("1")) {
                    schoolInstrument.setInstrumentNum(schoolInstrument.getInstrumentNum());
                }else {
                    //损坏数量
                    Integer damageNum = schoolTeacherBorrowDetail.getDamageNum();
                    //借用数量
                    Integer borrowNum = schoolTeacherBorrowDetail1.getBorrowNum();
                    //归还数量
                    Integer returnNum = borrowNum - damageNum;

                    //损坏的仪器，自动出库
                    if (damageNum > 0){
                        SchoolInstrumentDetail schoolInstrumentDetail = new SchoolInstrumentDetail();
                        schoolInstrumentDetail.setInstrumentId(instrumentId);
                        schoolInstrumentDetail.setInstrumentName(schoolInstrument.getInstrumentName());
                        schoolInstrumentDetail.setInstrumentTypeId(instrumentTypeId);
                        schoolInstrumentDetail.setInstrumentTypeName(schoolInstrumentClassify.getInstrumentTypeName());
                        schoolInstrumentDetail.setVariationType("1");
                        schoolInstrumentDetail.setVariationNum(damageNum);
                        schoolInstrumentDetail.setOldStockNum(schoolInstrument.getInstrumentNum());
                        schoolInstrumentDetail.setNewStockNum(schoolInstrument.getInstrumentNum() + returnNum);
                        schoolInstrumentDetail.setVariationTime(DateUtils.getNowDate());
                        schoolInstrumentDetail.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
                        schoolInstrumentDetail.setCreateTime(DateUtils.getNowDate());
                        schoolInstrumentDetailMapper.insert(schoolInstrumentDetail);
                    }

                    //修改新库存数量
                    schoolInstrument.setInstrumentNum(schoolInstrument.getInstrumentNum() + returnNum);
                }

                schoolInstrumentMapper.updateById(schoolInstrument);
                list.add(schoolTeacherBorrowDetail);
            }
            if (list.size() > 0)
            {
                schoolTeacherBorrowMapper.updateSchoolTeacherBorrowDetails(list);
            }
        }
    }

    /**
     * 新增教师借用明细信息
     *
     * @param schoolTeacherBorrowVo 教师借用对象
     */
    public void insertSchoolTeacherBorrowDetail(SchoolTeacherBorrowVo schoolTeacherBorrowVo)
    {
        List<SchoolTeacherBorrowDetail> schoolTeacherBorrowDetailList = schoolTeacherBorrowVo.getSchoolTeacherBorrowDetailList();
        Long id = schoolTeacherBorrowVo.getId();
        if (StringUtils.isNotNull(schoolTeacherBorrowDetailList))
        {
            List<SchoolTeacherBorrowDetail> list = new ArrayList<SchoolTeacherBorrowDetail>();
            for (SchoolTeacherBorrowDetail schoolTeacherBorrowDetail : schoolTeacherBorrowDetailList)
            {
                //根据仪器id获取仪器信息
                Long instrumentId = schoolTeacherBorrowDetail.getInstrumentId();
                SchoolInstrument schoolInstrument = schoolInstrumentMapper.selectById(instrumentId);
                //判断借用数量是否大于设备数量
                if (schoolTeacherBorrowDetail.getBorrowNum() > schoolInstrument.getInstrumentNum()){
                    throw new ServiceException("借用数量大于仪器可借用数量,请您重新输入");
                }
                schoolTeacherBorrowDetail.setInstrumentName(schoolInstrument.getInstrumentName());
                schoolTeacherBorrowDetail.setInstrumentModel(schoolInstrument.getInstrumentModel());
                schoolTeacherBorrowDetail.setInstrumentNum(schoolInstrument.getInstrumentNum());
                schoolTeacherBorrowDetail.setTeacherBorrowId(id);
                list.add(schoolTeacherBorrowDetail);
            }
            if (list.size() > 0)
            {
                schoolTeacherBorrowMapper.batchSchoolTeacherBorrowDetail(list);
            }
        }
    }

    /**
     * 审批-新增教师借用明细信息
     *
     * @param schoolTeacherBorrowVo 教师借用对象
     */
    public void insertSchoolTeacherBorrowDetailSp(SchoolTeacherBorrowVo schoolTeacherBorrowVo)
    {
        List<SchoolTeacherBorrowDetail> schoolTeacherBorrowDetailList = schoolTeacherBorrowVo.getSchoolTeacherBorrowDetailList();
        Long id = schoolTeacherBorrowVo.getId();
        if (StringUtils.isNotNull(schoolTeacherBorrowDetailList))
        {
            List<SchoolTeacherBorrowDetail> list = new ArrayList<SchoolTeacherBorrowDetail>();
            for (SchoolTeacherBorrowDetail schoolTeacherBorrowDetail : schoolTeacherBorrowDetailList)
            {
                //根据仪器id获取仪器信息
                Long instrumentId = schoolTeacherBorrowDetail.getInstrumentId();
                SchoolInstrument schoolInstrument = schoolInstrumentMapper.selectById(instrumentId);
                //判断借用数量是否大于设备数量
                if (schoolTeacherBorrowDetail.getBorrowNum() > schoolInstrument.getInstrumentNum()){
                    throw new ServiceException("借用数量大于仪器可借用数量,请您重新输入");
                }
                //如借出消耗品，自动出库,不需归还
                Long instrumentTypeId = schoolInstrument.getInstrumentTypeId();
                SchoolInstrumentClassify schoolInstrumentClassify = schoolInstrumentClassifyMapper.selectById(instrumentTypeId);
                if (schoolInstrumentClassify.getIsConsumables().equals("1")){
                    SchoolInstrumentDetail schoolInstrumentDetail = new SchoolInstrumentDetail();
                    schoolInstrumentDetail.setInstrumentId(instrumentId);
                    schoolInstrumentDetail.setInstrumentName(schoolInstrument.getInstrumentName());
                    schoolInstrumentDetail.setInstrumentTypeId(instrumentTypeId);
                    schoolInstrumentDetail.setInstrumentTypeName(schoolInstrumentClassify.getInstrumentTypeName());
                    schoolInstrumentDetail.setVariationType("1");
                    schoolInstrumentDetail.setVariationNum(schoolTeacherBorrowDetail.getBorrowNum());
                    schoolInstrumentDetail.setOldStockNum(schoolInstrument.getInstrumentNum());
                    schoolInstrumentDetail.setNewStockNum(schoolInstrument.getInstrumentNum() - schoolTeacherBorrowDetail.getBorrowNum());
                    schoolInstrumentDetail.setVariationTime(DateUtils.getNowDate());
                    schoolInstrumentDetail.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
                    schoolInstrumentDetail.setCreateTime(DateUtils.getNowDate());
                    schoolInstrumentDetailMapper.insert(schoolInstrumentDetail);
                }

                schoolTeacherBorrowDetail.setInstrumentName(schoolInstrument.getInstrumentName());
                schoolTeacherBorrowDetail.setInstrumentModel(schoolInstrument.getInstrumentModel());
                schoolTeacherBorrowDetail.setInstrumentNum(schoolInstrument.getInstrumentNum());
                schoolTeacherBorrowDetail.setTeacherBorrowId(id);
                list.add(schoolTeacherBorrowDetail);

                //修改仪器数量
                SchoolInstrument instrument = new SchoolInstrument();
                instrument.setId(instrumentId);
                instrument.setInstrumentNum(schoolInstrument.getInstrumentNum() - schoolTeacherBorrowDetail.getBorrowNum());
                schoolInstrumentMapper.updateById(instrument);
            }
            if (list.size() > 0)
            {
                schoolTeacherBorrowMapper.batchSchoolTeacherBorrowDetail(list);
            }
        }
    }
}
