package yangtz.cs.liu.campus.service.impl.schoolInstrument;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolInstrument;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolInstrumentDetail;
import yangtz.cs.liu.campus.mapper.schoolInstrument.SchoolInstrumentDetailMapper;
import yangtz.cs.liu.campus.mapper.schoolInstrument.SchoolInstrumentMapper;
import yangtz.cs.liu.campus.service.schoolInstrument.ISchoolInstrumentDetailService;
import yangtz.cs.liu.campus.vo.schoolInstrument.SchoolInstrumentDetailVo;

import java.util.List;

/**
 * 仪器出入库明细Service业务层处理
 *
 * @author ruoyi
 * @date 2023-09-06
 */
@Service
public class SchoolInstrumentDetailServiceImpl extends ServiceImpl<SchoolInstrumentDetailMapper, SchoolInstrumentDetail> implements ISchoolInstrumentDetailService {

    @Autowired
    private SchoolInstrumentDetailMapper schoolInstrumentDetailMapper;
    @Autowired
    private SchoolInstrumentMapper schoolInstrumentMapper;

    /**
     * 查询仪器出入库明细
     *
     * @param id 仪器出入库明细主键
     * @return 仪器出入库明细
     */
    @Override
    public SchoolInstrumentDetail selectSchoolInstrumentDetailById(Long id)
    {
        return schoolInstrumentDetailMapper.selectSchoolInstrumentDetailById(id);
    }

    /**
     * 查询仪器出入库明细列表
     *
     * @param schoolInstrumentDetailVo 仪器出入库明细
     * @return 仪器出入库明细
     */
    @Override
    public List<SchoolInstrumentDetail> selectSchoolInstrumentDetailList(SchoolInstrumentDetailVo schoolInstrumentDetailVo)
    {
        return schoolInstrumentDetailMapper.selectSchoolInstrumentDetailList(schoolInstrumentDetailVo);
    }

    /**
     * 新增仪器出入库明细
     *
     * @param schoolInstrumentDetail 仪器出入库明细
     * @return 结果
     */
    @Override
    public int insertSchoolInstrumentDetail(SchoolInstrumentDetail schoolInstrumentDetail)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //修改仪器库存
        //仪器id
        Long instrumentId = schoolInstrumentDetail.getInstrumentId();
        //新库存数量
        Integer newStockNum = schoolInstrumentDetail.getNewStockNum();
        SchoolInstrument schoolInstrument = new SchoolInstrument();
        schoolInstrument.setId(instrumentId);
        schoolInstrument.setInstrumentNum(newStockNum);
        schoolInstrumentMapper.updateById(schoolInstrument);

        SchoolInstrument instrument = schoolInstrumentMapper.selectById(instrumentId);
        schoolInstrumentDetail.setInstrumentName(instrument.getInstrumentName());
        schoolInstrumentDetail.setInstrumentTypeId(instrument.getInstrumentTypeId());
        schoolInstrumentDetail.setInstrumentTypeName(instrument.getInstrumentTypeName());
        schoolInstrumentDetail.setVariationTime(DateUtils.getNowDate());
        schoolInstrumentDetail.setCreateBy(user.getUserName());
        schoolInstrumentDetail.setCreateTime(DateUtils.getNowDate());
        return schoolInstrumentDetailMapper.insertSchoolInstrumentDetail(schoolInstrumentDetail);
    }

    /**
     * 修改仪器出入库明细
     *
     * @param schoolInstrumentDetail 仪器出入库明细
     * @return 结果
     */
    @Override
    public int updateSchoolInstrumentDetail(SchoolInstrumentDetail schoolInstrumentDetail)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolInstrumentDetail.setUpdateBy(user.getUserName());
        schoolInstrumentDetail.setUpdateTime(DateUtils.getNowDate());
        return schoolInstrumentDetailMapper.updateSchoolInstrumentDetail(schoolInstrumentDetail);
    }

    /**
     * 批量删除仪器出入库明细
     *
     * @param ids 需要删除的仪器出入库明细主键
     * @return 结果
     */
    @Override
    public int deleteSchoolInstrumentDetailByIds(Long[] ids)
    {
        return schoolInstrumentDetailMapper.deleteSchoolInstrumentDetailByIds(ids);
    }

    /**
     * 删除仪器出入库明细信息
     *
     * @param id 仪器出入库明细主键
     * @return 结果
     */
    @Override
    public int deleteSchoolInstrumentDetailById(Long id)
    {
        return schoolInstrumentDetailMapper.deleteSchoolInstrumentDetailById(id);
    }
}
