package yangtz.cs.liu.campus.service.impl.schoolEquipment;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.annotation.DataScope;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysUserMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolEquipmentRepair;
import yangtz.cs.liu.campus.mapper.schoolEquipment.EquipmentRepairMapper;
import yangtz.cs.liu.campus.service.schoolEquipment.IEquipmentRepairService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolEquipmentRepairVo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolReceiveQuery;

@Service
public class EquipmentRepairServiceImpl extends ServiceImpl<EquipmentRepairMapper, SchoolEquipmentRepair> implements IEquipmentRepairService {


    @Autowired
    private EquipmentRepairMapper equipmentRepairMapper;
    @Autowired
    private SysUserMapper sysUserMapper;

    /**
     * 查看设备报修列表
     * @param schoolEquipmentRepairVo
     * @return
     */
    @Override
    public List<SchoolEquipmentRepairVo> selectSchoolEquipmentRepairVoList(SchoolEquipmentRepairVo schoolEquipmentRepairVo) {
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        SysUser user = SecurityUtils.getLoginUser().getUser();
        for (SysRole role : roles) {
            if (role.getRoleKey().equals("admin")){
                return equipmentRepairMapper.selectSchoolEquipmentRepairVoList(schoolEquipmentRepairVo);
            }else if (role.getRoleKey().equals("productCategoryAdmin")){
                schoolEquipmentRepairVo.setAdminId(SecurityUtils.getLoginUser().getUser().getUserId());
                return equipmentRepairMapper.selectSchoolEquipmentRepairVoListGr(schoolEquipmentRepairVo);
            }
        }
        if (user.isAdmin()){
            return   equipmentRepairMapper.selectSchoolEquipmentRepairVoList(schoolEquipmentRepairVo);
        }
        return new ArrayList<>();
    }

    /**
     * 查看设备报修详细信息
     * @param id
     * @return
     */
    @Override
    public SchoolEquipmentRepairVo selectSchoolEquipmentRepairVoById(Long id) {
        return equipmentRepairMapper.selectSchoolEquipmentRepairVoById(id);
    }

  /**
   * 管理员查询维修页面，只看管理员自己分类的
   * @param reportRepairid
   * @return
   */
  @Override
  public List<SchoolEquipmentRepairVo> getAdminList(SchoolReceiveQuery schoolReceiveQuery) {
    return equipmentRepairMapper.getAdminList(schoolReceiveQuery);
  }

  /**
     * 新增设备报修
     * @return
     */
    @Override
    @Transactional
    public int insertSchoolEquipmentRepairVo(SchoolEquipmentRepair schoolEquipmentRepair) {
        if (StringUtils.isNotNull(schoolEquipmentRepair.getReportRepairId())){
            String userName = sysUserMapper.selectUserById(schoolEquipmentRepair.getReportRepairId()).getUserName();
            schoolEquipmentRepair.setReportRepair(userName);
        }
        if (StringUtils.isNotNull(schoolEquipmentRepair.getRepairId())){
            String userName = sysUserMapper.selectUserById(schoolEquipmentRepair.getRepairId()).getUserName();
            schoolEquipmentRepair.setRepairName(userName);
        }
        if (StringUtils.isNotEmpty(schoolEquipmentRepair.getDisposeState())){
            if (schoolEquipmentRepair.getDisposeState().equals("0")){
                schoolEquipmentRepair.setRepairState("");
            }
        }
        schoolEquipmentRepair.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolEquipmentRepair.setCreateTime(DateUtils.getNowDate());
        return equipmentRepairMapper.insert(schoolEquipmentRepair);
    }

    /**
     * 修改设备报修
     * @param schoolEquipmentRepair
     * @return
     */
    @Override
    @Transactional
    public int updateSchoolEquipmentRepair(SchoolEquipmentRepair schoolEquipmentRepair) {
        if (StringUtils.isNotNull(schoolEquipmentRepair.getReportRepairId())){
            String userName = sysUserMapper.selectUserById(schoolEquipmentRepair.getReportRepairId()).getUserName();
            schoolEquipmentRepair.setReportRepair(userName);
        }
        if (StringUtils.isNotNull(schoolEquipmentRepair.getRepairId())){
            String userName = sysUserMapper.selectUserById(schoolEquipmentRepair.getRepairId()).getUserName();
            schoolEquipmentRepair.setRepairName(userName);
        }
        if (StringUtils.isNotEmpty(schoolEquipmentRepair.getDisposeState())){
            if (schoolEquipmentRepair.getDisposeState().equals("0")){
                schoolEquipmentRepair.setRepairState("");
            }
        }
        schoolEquipmentRepair.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolEquipmentRepair.setUpdateTime(DateUtils.getNowDate());
        return equipmentRepairMapper.updateById(schoolEquipmentRepair);
    }

    /**
     * 删除设备报修
     * @param ids
     * @return
     */
    @Override
    @Transactional
    public int deleteSchoolEquipmentRepairById(Long[] ids) {
        return equipmentRepairMapper.deleteSchoolEquipmentRepairById(ids);
    }

    /**
     * 根据自编码获取设备信息
     * @param encode
     * @return
     */
    @Override
    public Map<String, String> getEquipment(String encode) {
//        Long userId = SecurityUtils.getLoginUser().getUser().getUserId();
        return equipmentRepairMapper.getEquipment(encode);
    }

    /**
     * 获取修理人下拉框
     * @return
     */
    @Override
    public List<Map<String, String>> getRepair() {
        return equipmentRepairMapper.getRepair();
    }

  @Override
  public SchoolEquipmentRepairVo getEquipmentById(Long id) {
    return equipmentRepairMapper.getEquipmentById(id);
  }

  @Override
  public List<SchoolEquipmentRepairVo> getMaintenanceList(SchoolReceiveQuery schoolReceiveQuery) {
    return equipmentRepairMapper.getMaintenanceList(schoolReceiveQuery);
  }

  /**
   * 管理员获取所有维修列表
   * @return
   */
  @Override
  public List<SchoolEquipmentRepairVo> getlist() {
    return equipmentRepairMapper.getlist();
  }

  @Override
  public List<SchoolEquipmentRepairVo> getMaintenanceUserList(SchoolReceiveQuery schoolReceiveQuery) {
    return equipmentRepairMapper.getMaintenanceUserList(schoolReceiveQuery);
  }

}
