package yangtz.cs.liu.campus.service.impl.schoolEquipment;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.annotation.DataScope;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysUserMapper;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolCirculation;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolEquipmentLedger;
import yangtz.cs.liu.campus.mapper.schoolEquipment.CirculationMapper;
import yangtz.cs.liu.campus.mapper.schoolEquipment.EquipmentLedgerMapper;
import yangtz.cs.liu.campus.service.schoolEquipment.ICirculationService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolCirculationVo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolReceiveQuery;

@Service
public class CirculationServiceImpl extends ServiceImpl<CirculationMapper, SchoolCirculation> implements ICirculationService {


  @Autowired
  private CirculationMapper circulationMapper;
  @Autowired
  private SysUserMapper sysUserMapper;
  @Autowired
  private EquipmentLedgerMapper equipmentLedgerMapper;

  @Override
  public List<SchoolCirculationVo> getReturningEquipmentByadminId(SchoolReceiveQuery schoolReceiveQuery) {
    return circulationMapper.getReturningEquipmentByadminId(schoolReceiveQuery);
  }

  @Override
  public SchoolCirculationVo getSchoolCirculationVoById(Long id) {
    return circulationMapper.getSchoolCirculationVoById(id);
  }

  @Override
  public SchoolCirculationVo getSchoolCirculationVoByenCode(String enCode) {
    return circulationMapper.getSchoolCirculationVoByenCode(enCode);
  }


  /**
     * 查看设备借出归还列表
     * @param schoolCirculationVo
     * @return
     */
    @Override
    public List<SchoolCirculationVo> selectSchoolCirculationVoList(SchoolCirculationVo schoolCirculationVo) {
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        SysUser user = SecurityUtils.getLoginUser().getUser();
        for (SysRole role : roles) {
            if (role.getRoleKey().equals("admin")){
                return circulationMapper.selectSchoolCirculationVoList(schoolCirculationVo);
            }else if (role.getRoleKey().equals("productCategoryAdmin")){
                schoolCirculationVo.setAdminId(SecurityUtils.getLoginUser().getUser().getUserId());
                return circulationMapper.selectSchoolCirculationVoListGr(schoolCirculationVo);
            }
        }
        if (user.isAdmin()){
            return circulationMapper.selectSchoolCirculationVoList(schoolCirculationVo);
        }
        return new ArrayList<>();
    }
  public List<SchoolCirculationVo> selectVxSchoolCirculationVoList(
      SchoolReceiveQuery schoolReceiveQuery) {
    SchoolCirculationVo schoolCirculationVo = new SchoolCirculationVo();
    schoolCirculationVo.setBorrowById(schoolReceiveQuery.getBorrowById());
    schoolCirculationVo.setEquipmentName(schoolReceiveQuery.getEquipmentName());
    return circulationMapper.selectSchoolCirculationVoList(schoolCirculationVo);
  }
    /**
     * 查看设备借出归还详细信息
     * @param id
     * @return
     */
    @Override
    public SchoolCirculationVo selectSchoolCirculationVoById(Long id) {
        return circulationMapper.selectSchoolCirculationVoById(id);
    }

    /**
     * 新增设备借出归还信息
     * @param schoolCirculation
     * @return
     */
    @Override
    @Transactional
    public int insertSchoolCirculation(SchoolCirculation schoolCirculation) {
        //判断该设备是否允许借出
        SchoolEquipmentLedger schoolEquipmentLedger1 = equipmentLedgerMapper.selectById(schoolCirculation.getEquipmentId());
        if (schoolEquipmentLedger1.getIsAllowLend().equals("0")){
            throw new ServiceException("该设备不允许借出");
        }
        if (StringUtils.isNotNull(schoolCirculation.getBorrowById())){
          String userName = sysUserMapper.selectUserById(schoolCirculation.getBorrowById()).getUserName();
          schoolCirculation.setBorrowBy(userName);
        }
        if (StringUtils.isNotNull(schoolCirculation.getReceivedById())){
          String userName = sysUserMapper.selectUserById(schoolCirculation.getReceivedById()).getUserName();
          schoolCirculation.setReceivedBy(userName);
        }
        if (StringUtils.isNotNull(schoolCirculation.getReturnTime())){
            if (schoolCirculation.getReturnTime().before(DateUtils.getNowDate()) || schoolCirculation.getReturnTime().equals(DateUtils.getNowDate())){
                schoolCirculation.setReturnState("1");
                SchoolEquipmentLedger schoolEquipmentLedger = new SchoolEquipmentLedger();
                schoolEquipmentLedger.setId(schoolCirculation.getEquipmentId());
                schoolEquipmentLedger.setIsLend("0");
                equipmentLedgerMapper.updateById(schoolEquipmentLedger);
            }
        }
        schoolCirculation.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolCirculation.setCreateTime(DateUtils.getNowDate());
        return circulationMapper.insert(schoolCirculation);

    }

    /**
     * 修改设备借出归还信息
     * @param schoolCirculation
     * @return
     */
    @Override
    public int updateSchoolCirculation(SchoolCirculation schoolCirculation) {
        if (StringUtils.isNotNull(schoolCirculation.getBorrowById())){
          String userName = sysUserMapper.selectUserById(schoolCirculation.getBorrowById()).getUserName();
          schoolCirculation.setBorrowBy(userName);
        }
        if (StringUtils.isNotNull(schoolCirculation.getReceivedById())){
          String userName = sysUserMapper.selectUserById(schoolCirculation.getReceivedById()).getUserName();
          schoolCirculation.setReceivedBy(userName);
        }
        if (StringUtils.isNotNull(schoolCirculation.getReturnTime())){
            if (schoolCirculation.getReturnTime().before(DateUtils.getNowDate()) || schoolCirculation.getReturnTime().equals(DateUtils.getNowDate())){
                schoolCirculation.setReturnState("1");
                SchoolEquipmentLedger schoolEquipmentLedger = new SchoolEquipmentLedger();
                schoolEquipmentLedger.setId(schoolCirculation.getEquipmentId());
                schoolEquipmentLedger.setIsLend("0");
                equipmentLedgerMapper.updateById(schoolEquipmentLedger);
            }
        }
        schoolCirculation.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolCirculation.setUpdateTime(DateUtils.getNowDate());
        return circulationMapper.updateById(schoolCirculation);
    }

    /**
     * 删除设备借出归还信息
     * @param ids
     * @return
     */
    @Override
    public int deleteSchoolCirculationByIds(Long[] ids) {
        return circulationMapper.deleteSchoolCirculationByIds(ids);
    }

}
