package yangtz.cs.liu.campus.service.impl.schoolDcwj;

import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.constant.DcwjType;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjAn;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjNr;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjRy;
import yangtz.cs.liu.campus.mapper.schoolDcwj.SchoolDcwjAnMapper;
import yangtz.cs.liu.campus.mapper.schoolDcwj.SchoolDcwjNrMapper;
import yangtz.cs.liu.campus.mapper.schoolDcwj.SchoolDcwjRyMapper;
import yangtz.cs.liu.campus.service.schoolDcwj.ISchoolDcwjNrService;
import yangtz.cs.liu.campus.vo.schoolDcwj.*;
import yangtz.cs.liu.wechat.vo.schoolDcwj.Vo_SchoolDcwjNr;

import static com.ruoyi.common.utils.StringUtils.isNotNull;
import static com.ruoyi.common.utils.StringUtils.isNull;


/**
 * 内容问题Service业务层处理
 *
 * @author wengxiulin
 * @date 2023-02-27
 */
@Service
public class SchoolDcwjNrServiceImpl extends ServiceImpl<SchoolDcwjNrMapper, SchoolDcwjNr> implements ISchoolDcwjNrService {
    @Autowired
    private SchoolDcwjNrMapper schoolDcwjNrMapper;

    @Autowired
    private SchoolDcwjAnMapper schoolDcwjAnMapper;

    @Autowired
    private SchoolDcwjRyMapper schoolDcwjRyMapper;

    /**
     * 查询内容问题
     *
     * @param id 内容问题主键
     * @return 内容问题
     */
    @Override
    public SchoolDcwjNr selectSchoolDcwjNrById(Long id) {
        return schoolDcwjNrMapper.selectSchoolDcwjNrById(id);
    }

    /**
     * 查询内容问题列表
     *
     * @param schoolDcwjNr 内容问题
     * @return 内容问题
     */
    @Override
    public List<SchoolDcwjNr> selectSchoolDcwjNrList(SchoolDcwjNr schoolDcwjNr) {
        return schoolDcwjNrMapper.selectSchoolDcwjNrList(schoolDcwjNr);
    }

    /**
     * 新增内容问题
     *
     * @param schoolDcwjNr 内容问题
     * @return 结果
     */
    @Override
    public int insertSchoolDcwjNr(SchoolDcwjNr schoolDcwjNr) {
        schoolDcwjNr.setCreateTime(DateUtils.getNowDate());
        return schoolDcwjNrMapper.insertSchoolDcwjNr(schoolDcwjNr);
    }

    /**
     * 修改内容问题
     *
     * @param schoolDcwjNr 内容问题
     * @return 结果
     */
    @Override
    public int updateSchoolDcwjNr(SchoolDcwjNr schoolDcwjNr) {
        //类型为选择题或者多选题， 填空和图片在控制层已处理，如果新增时是五个选项，现在修改时去掉了某个选项，更新时并没有处理，删不掉
        //判断各选项有无
        LambdaUpdateWrapper<SchoolDcwjNr> luw = new LambdaUpdateWrapper<>();
        luw
                .eq(SchoolDcwjNr::getId,schoolDcwjNr.getId())
                .set(SchoolDcwjNr::getDcwjId,schoolDcwjNr.getDcwjId())
                .set(SchoolDcwjNr::getNrBt,schoolDcwjNr.getNrBt())
                .set(SchoolDcwjNr::getNrLx,schoolDcwjNr.getNrLx())
                .set(SchoolDcwjNr::getNrSfbt,schoolDcwjNr.getNrSfbt())
                .set(SchoolDcwjNr::getNrPx,schoolDcwjNr.getNrPx());
        if(StringUtils.isNull(schoolDcwjNr.getNrA()) || "".equals(schoolDcwjNr.getNrA())){
            luw.set(SchoolDcwjNr::getNrA,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrB()) || "".equals(schoolDcwjNr.getNrB())){
            luw.set(SchoolDcwjNr::getNrB,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrC()) || "".equals(schoolDcwjNr.getNrC())){
            luw.set(SchoolDcwjNr::getNrC,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrD()) || "".equals(schoolDcwjNr.getNrD())){
            luw.set(SchoolDcwjNr::getNrD,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrE()) || "".equals(schoolDcwjNr.getNrE())){
            luw.set(SchoolDcwjNr::getNrE,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrF()) || "".equals(schoolDcwjNr.getNrF())){
            luw.set(SchoolDcwjNr::getNrF,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrG()) || "".equals(schoolDcwjNr.getNrG())){
            luw.set(SchoolDcwjNr::getNrG,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrH()) || "".equals(schoolDcwjNr.getNrH())){
            luw.set(SchoolDcwjNr::getNrH,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrI()) || "".equals(schoolDcwjNr.getNrI())){
            luw.set(SchoolDcwjNr::getNrI,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrJ()) || "".equals(schoolDcwjNr.getNrJ())){
            luw.set(SchoolDcwjNr::getNrJ,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrK()) || "".equals(schoolDcwjNr.getNrK())){
            luw.set(SchoolDcwjNr::getNrK,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrL()) || "".equals(schoolDcwjNr.getNrL())){
            luw.set(SchoolDcwjNr::getNrL,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrM()) || "".equals(schoolDcwjNr.getNrM())){
            luw.set(SchoolDcwjNr::getNrM,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrN()) || "".equals(schoolDcwjNr.getNrN())){
            luw.set(SchoolDcwjNr::getNrN,null);
        }
        if(StringUtils.isNull(schoolDcwjNr.getNrO()) || "".equals(schoolDcwjNr.getNrO())){
            luw.set(SchoolDcwjNr::getNrO,null);
        }
        schoolDcwjNr.update();
        //判断是否有页面逻辑,如果没有，则要将表里的值（如果之前有）去掉
        if(StringUtils.isNull(schoolDcwjNr.getNrId()) || "".equals(schoolDcwjNr.getNrId())) {
            luw.set(SchoolDcwjNr::getNrId,null).set(SchoolDcwjNr::getNrSelect,null);
        }
        //return schoolDcwjNrMapper.updateSchoolDcwjNr(schoolDcwjNr);
        return schoolDcwjNrMapper.update(schoolDcwjNr,luw);
    }

    /**
     * 批量删除内容问题
     *
     * @param ids 需要删除的内容问题主键
     * @return 结果
     */
    @Override
    public int deleteSchoolDcwjNrByIds(Long[] ids) {
        return schoolDcwjNrMapper.deleteSchoolDcwjNrByIds(ids);
    }

    /**
     * 删除内容问题信息
     *
     * @param id 内容问题主键
     * @return 结果
     */
    @Override
    public int deleteSchoolDcwjNrById(Long id) {
        return schoolDcwjNrMapper.deleteSchoolDcwjNrById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String importDcwjNrListData(List<SchoolDcwjNr> list, Long dcwjId) {
        if (isNull(list) || list.size() == 0) {
            throw new ServiceException("导入数据不能为空");
        }

        //记录日志数据 成功数 故障数 成功消息 故障消息
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();

        LambdaQueryWrapper<SchoolDcwjNr> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolDcwjNr::getDcwjId, dcwjId);
        schoolDcwjNrMapper.delete(lqw);
        int i = 1;
        for (SchoolDcwjNr schoolDcwjNr : list) {
                schoolDcwjNr.insert();
                schoolDcwjNr.setDcwjId(dcwjId);
                //排序
                schoolDcwjNr.setNrPx(i++);
                if(schoolDcwjNrMapper.insert(schoolDcwjNr) > 0){
                    successNum++ ;
                }else {
                    failureNum++;
                }
        }

        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，导入失败！共" + failureNum + "条数据格式不正确");
            throw new ServiceException(failureMsg.toString());
        } else {
            successMsg.insert(0, "恭喜您，数据已全部导入成功！共计" + successNum + "条");
        }
        return successMsg.toString();
    }

    /**
     *wx获取某一个调查问卷下题目+用户回答详情
     * @param studentId studentId 或者是teacherId
     * @param teacherId
     * @return
     */
    @Override
    public List<Vo_SchoolDcwjNr> getDcwjNrList(Long dcwjId, Long studentId, Long teacherId) {
        //通过学生id和问卷主id查询出问卷人员表的主id
        LambdaQueryWrapper<SchoolDcwjRy> ryLqw = new LambdaQueryWrapper<>();
        ryLqw
                .eq(isNotNull(studentId), SchoolDcwjRy::getStudentId, studentId)
                .eq(isNotNull(teacherId),SchoolDcwjRy::getTeacherId, teacherId)
                .eq(isNotNull(dcwjId), SchoolDcwjRy::getDcwjId, dcwjId)
        ;
        SchoolDcwjRy schoolDcwjRy = schoolDcwjRyMapper.selectOne(ryLqw);
        Long ryId = schoolDcwjRy.getId();

        LambdaQueryWrapper<SchoolDcwjNr> nrLqw = new LambdaQueryWrapper<>();
        nrLqw.eq(SchoolDcwjNr::getDcwjId, dcwjId);
        List<SchoolDcwjNr> schoolDcwjNrList = schoolDcwjNrMapper.selectList(nrLqw);

        List<Vo_SchoolDcwjNr> voSchoolDcwjNrList = new ArrayList<>();
        for (SchoolDcwjNr schoolDcwjNr : schoolDcwjNrList) {
            Vo_SchoolDcwjNr vo_schoolDcwjNr = new Vo_SchoolDcwjNr();
            BeanUtils.copyProperties(schoolDcwjNr, vo_schoolDcwjNr);
            LambdaQueryWrapper<SchoolDcwjAn> anLqw = new LambdaQueryWrapper<>();
            anLqw
                    .eq(isNotNull(dcwjId), SchoolDcwjAn::getDcwjId, dcwjId)
                    .eq(isNotNull(schoolDcwjNr.getId()), SchoolDcwjAn::getNrId, schoolDcwjNr.getId())
                    .eq(isNotNull(ryId), SchoolDcwjAn::getRyId, ryId);
            SchoolDcwjAn schoolDcwjAn = schoolDcwjAnMapper.selectOne(anLqw);
            if (isNotNull(schoolDcwjAn)) {
                vo_schoolDcwjNr.setUserAnswer(schoolDcwjAn.getUserAnswer());
            }
            voSchoolDcwjNrList.add(vo_schoolDcwjNr);
        }
        return voSchoolDcwjNrList;
    }

    //问卷结果-不固定的表头获取
    @Override
    public List<SchoolDcwjNr> getNrBtByDcwjId(Long dcwjId) {
        LambdaQueryWrapper<SchoolDcwjNr> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolDcwjNr::getDcwjId, dcwjId).orderByAsc(SchoolDcwjNr::getNrPx).orderByDesc(SchoolDcwjNr::getCreateTime);
        List<SchoolDcwjNr> nrs = schoolDcwjNrMapper.selectList(lqw);
        int i = 1;
        for (SchoolDcwjNr nr : nrs) {
            String s = "";
            s = "题目" + i + " " + nr.getNrBt();
            nr.setNrBt(s);
            i++;
        }
        return nrs;
    }

    @Override
    public ViewTitlesVo turnTitles(List<SchoolDcwjNr> list) {
        ViewTitlesVo vo = new ViewTitlesVo();
        int i = 1;
        for (SchoolDcwjNr nr : list) {
            switch (i) {
                case 1:
                    vo.setT1(nr.getNrBt());
                    break;
                case 2:
                    vo.setT2(nr.getNrBt());
                    break;
                case 3:
                    vo.setT3(nr.getNrBt());
                    break;
                case 4:
                    vo.setT4(nr.getNrBt());
                    break;
                case 5:
                    vo.setT5(nr.getNrBt());
                    break;
                case 6:
                    vo.setT6(nr.getNrBt());
                    break;
                case 7:
                    vo.setT7(nr.getNrBt());
                    break;
                case 8:
                    vo.setT8(nr.getNrBt());
                    break;
                case 9:
                    vo.setT9(nr.getNrBt());
                    break;
                case 10:
                    vo.setT10(nr.getNrBt());
                    break;
                case 11:
                    vo.setT11(nr.getNrBt());
                    break;
                case 12:
                    vo.setT12(nr.getNrBt());
                    break;
                case 13:
                    vo.setT13(nr.getNrBt());
                    break;
                case 14:
                    vo.setT14(nr.getNrBt());
                    break;
                case 15:
                    vo.setT15(nr.getNrBt());
                    break;
                case 16:
                    vo.setT16(nr.getNrBt());
                    break;
                case 17:
                    vo.setT17(nr.getNrBt());
                    break;
                case 18:
                    vo.setT18(nr.getNrBt());
                    break;
                case 19:
                    vo.setT19(nr.getNrBt());
                    break;
                case 20:
                    vo.setT20(nr.getNrBt());
                    break;
                case 21:
                    vo.setT21(nr.getNrBt());
                    break;
                case 22:
                    vo.setT22(nr.getNrBt());
                    break;
                case 23:
                    vo.setT23(nr.getNrBt());
                    break;
                case 24:
                    vo.setT24(nr.getNrBt());
                    break;
                case 25:
                    vo.setT25(nr.getNrBt());
                    break;
                case 26:
                    vo.setT26(nr.getNrBt());
                    break;
                case 27:
                    vo.setT27(nr.getNrBt());
                    break;
                case 28:
                    vo.setT28(nr.getNrBt());
                    break;
                case 29:
                    vo.setT29(nr.getNrBt());
                    break;
                case 30:
                    vo.setT30(nr.getNrBt());
                    break;
                case 31:
                    vo.setT31(nr.getNrBt());
                    break;
                case 32:
                    vo.setT32(nr.getNrBt());
                    break;
                case 33:
                    vo.setT33(nr.getNrBt());
                    break;
                case 34:
                    vo.setT34(nr.getNrBt());
                    break;
                case 35:
                    vo.setT35(nr.getNrBt());
                    break;
                case 36:
                    vo.setT36(nr.getNrBt());
                    break;
                case 37:
                    vo.setT37(nr.getNrBt());
                    break;
                case 38:
                    vo.setT38(nr.getNrBt());
                    break;
                case 39:
                    vo.setT39(nr.getNrBt());
                    break;
                case 40:
                    vo.setT40(nr.getNrBt());
                    break;
                case 41:
                    vo.setT41(nr.getNrBt());
                    break;
                case 42:
                    vo.setT42(nr.getNrBt());
                    break;
                case 43:
                    vo.setT43(nr.getNrBt());
                    break;
                case 44:
                    vo.setT44(nr.getNrBt());
                    break;
                case 45:
                    vo.setT45(nr.getNrBt());
                    break;
                case 46:
                    vo.setT46(nr.getNrBt());
                    break;
                case 47:
                    vo.setT47(nr.getNrBt());
                    break;
                case 48:
                    vo.setT48(nr.getNrBt());
                    break;
                case 49:
                    vo.setT49(nr.getNrBt());
                    break;
                case 50:
                    vo.setT50(nr.getNrBt());
                    break;
                case 51:
                    vo.setT51(nr.getNrBt());
                    break;
                case 52:
                    vo.setT52(nr.getNrBt());
                    break;
                case 53:
                    vo.setT53(nr.getNrBt());
                    break;
                case 54:
                    vo.setT54(nr.getNrBt());
                    break;
                case 55:
                    vo.setT55(nr.getNrBt());
                    break;
                case 56:
                    vo.setT56(nr.getNrBt());
                    break;
                case 57:
                    vo.setT57(nr.getNrBt());
                    break;
                case 58:
                    vo.setT58(nr.getNrBt());
                    break;
                case 59:
                    vo.setT59(nr.getNrBt());
                    break;
                case 60:
                    vo.setT60(nr.getNrBt());
                    break;
                case 61:
                    vo.setT61(nr.getNrBt());
                    break;
                case 62:
                    vo.setT62(nr.getNrBt());
                    break;
                case 63:
                    vo.setT63(nr.getNrBt());
                    break;
                case 64:
                    vo.setT64(nr.getNrBt());
                    break;
                case 65:
                    vo.setT65(nr.getNrBt());
                    break;
                case 66:
                    vo.setT66(nr.getNrBt());
                    break;
                case 67:
                    vo.setT67(nr.getNrBt());
                    break;
                case 68:
                    vo.setT68(nr.getNrBt());
                    break;
                case 69:
                    vo.setT69(nr.getNrBt());
                    break;
                case 70:
                    vo.setT70(nr.getNrBt());
                    break;
                case 71:
                    vo.setT71(nr.getNrBt());
                    break;
                case 72:
                    vo.setT72(nr.getNrBt());
                    break;
                case 73:
                    vo.setT73(nr.getNrBt());
                    break;
                case 74:
                    vo.setT74(nr.getNrBt());
                    break;
                case 75:
                    vo.setT75(nr.getNrBt());
                    break;
                case 76:
                    vo.setT76(nr.getNrBt());
                    break;
                case 77:
                    vo.setT77(nr.getNrBt());
                    break;
                case 78:
                    vo.setT78(nr.getNrBt());
                    break;
                case 79:
                    vo.setT79(nr.getNrBt());
                    break;
                case 80:
                    vo.setT80(nr.getNrBt());
                    break;
                case 81:
                    vo.setT81(nr.getNrBt());
                    break;
                case 82:
                    vo.setT82(nr.getNrBt());
                    break;
                case 83:
                    vo.setT83(nr.getNrBt());
                    break;
                case 84:
                    vo.setT84(nr.getNrBt());
                    break;
                case 85:
                    vo.setT85(nr.getNrBt());
                    break;
                case 86:
                    vo.setT86(nr.getNrBt());
                    break;
                case 87:
                    vo.setT87(nr.getNrBt());
                    break;
                case 88:
                    vo.setT88(nr.getNrBt());
                    break;
                case 89:
                    vo.setT89(nr.getNrBt());
                    break;
                case 90:
                    vo.setT90(nr.getNrBt());
                    break;
                case 91:
                    vo.setT91(nr.getNrBt());
                    break;
                case 92:
                    vo.setT92(nr.getNrBt());
                    break;
                case 93:
                    vo.setT93(nr.getNrBt());
                    break;
                case 94:
                    vo.setT94(nr.getNrBt());
                    break;
                case 95:
                    vo.setT95(nr.getNrBt());
                    break;
                case 96:
                    vo.setT96(nr.getNrBt());
                    break;
                case 97:
                    vo.setT97(nr.getNrBt());
                    break;
                case 98:
                    vo.setT98(nr.getNrBt());
                    break;
                case 99:
                    vo.setT99(nr.getNrBt());
                    break;
                case 100:
                    vo.setT100(nr.getNrBt());
                    break;
            }
            i++;
        }
        return vo;
    }

    @Override
    public List<ViewDataVo> turnData(List<SchoolDcwjAnVo> list) {
        List<ViewDataVo> voList = new ArrayList<>();
        for (SchoolDcwjAnVo anVo : list) {
            ViewDataVo vo = new ViewDataVo();
            BeanUtils.copyProperties(anVo, vo);
            int i = 1;
            for (SchoolDcwjAn an : anVo.getList()) {
                if(StringUtils.isNull(an.getNrId())){
                    i++;
                    continue;
                }
                SchoolDcwjNr nr = schoolDcwjNrMapper.selectById(an.getNrId());
                DataTVo tVo = new DataTVo();
                tVo.setDatas(an.getUserAnswer());
                tVo.setType(nr.getNrLx());
                switch (i) {
                    case 1:
                        vo.setT1(tVo);
                        break;
                    case 2:
                        vo.setT2(tVo);
                        break;
                    case 3:
                        vo.setT3(tVo);
                        break;
                    case 4:
                        vo.setT4(tVo);
                        break;
                    case 5:
                        vo.setT5(tVo);
                        break;
                    case 6:
                        vo.setT6(tVo);
                        break;
                    case 7:
                        vo.setT7(tVo);
                        break;
                    case 8:
                        vo.setT8(tVo);
                        break;
                    case 9:
                        vo.setT9(tVo);
                        break;
                    case 10:
                        vo.setT10(tVo);
                        break;
                    case 11:
                        vo.setT11(tVo);
                        break;
                    case 12:
                        vo.setT12(tVo);
                        break;
                    case 13:
                        vo.setT13(tVo);
                        break;
                    case 14:
                        vo.setT14(tVo);
                        break;
                    case 15:
                        vo.setT15(tVo);
                        break;
                    case 16:
                        vo.setT16(tVo);
                        break;
                    case 17:
                        vo.setT17(tVo);
                        break;
                    case 18:
                        vo.setT18(tVo);
                        break;
                    case 19:
                        vo.setT19(tVo);
                        break;
                    case 20:
                        vo.setT20(tVo);
                        break;
                    case 21:
                        vo.setT21(tVo);
                        break;
                    case 22:
                        vo.setT22(tVo);
                        break;
                    case 23:
                        vo.setT23(tVo);
                        break;
                    case 24:
                        vo.setT24(tVo);
                        break;
                    case 25:
                        vo.setT25(tVo);
                        break;
                    case 26:
                        vo.setT26(tVo);
                        break;
                    case 27:
                        vo.setT27(tVo);
                        break;
                    case 28:
                        vo.setT28(tVo);
                        break;
                    case 29:
                        vo.setT29(tVo);
                        break;
                    case 30:
                        vo.setT30(tVo);
                        break;
                    case 31:
                        vo.setT31(tVo);
                        break;
                    case 32:
                        vo.setT32(tVo);
                        break;
                    case 33:
                        vo.setT33(tVo);
                        break;
                    case 34:
                        vo.setT34(tVo);
                        break;
                    case 35:
                        vo.setT35(tVo);
                        break;
                    case 36:
                        vo.setT36(tVo);
                        break;
                    case 37:
                        vo.setT37(tVo);
                        break;
                    case 38:
                        vo.setT38(tVo);
                        break;
                    case 39:
                        vo.setT39(tVo);
                        break;
                    case 40:
                        vo.setT40(tVo);
                        break;
                    case 41:
                        vo.setT41(tVo);
                        break;
                    case 42:
                        vo.setT42(tVo);
                        break;
                    case 43:
                        vo.setT43(tVo);
                        break;
                    case 44:
                        vo.setT44(tVo);
                        break;
                    case 45:
                        vo.setT45(tVo);
                        break;
                    case 46:
                        vo.setT46(tVo);
                        break;
                    case 47:
                        vo.setT47(tVo);
                        break;
                    case 48:
                        vo.setT48(tVo);
                        break;
                    case 49:
                        vo.setT49(tVo);
                        break;
                    case 50:
                        vo.setT50(tVo);
                        break;
                    case 51:
                        vo.setT51(tVo);
                        break;
                    case 52:
                        vo.setT52(tVo);
                        break;
                    case 53:
                        vo.setT53(tVo);
                        break;
                    case 54:
                        vo.setT54(tVo);
                        break;
                    case 55:
                        vo.setT55(tVo);
                        break;
                    case 56:
                        vo.setT56(tVo);
                        break;
                    case 57:
                        vo.setT57(tVo);
                        break;
                    case 58:
                        vo.setT58(tVo);
                        break;
                    case 59:
                        vo.setT59(tVo);
                        break;
                    case 60:
                        vo.setT60(tVo);
                        break;
                    case 61:
                        vo.setT61(tVo);
                        break;
                    case 62:
                        vo.setT62(tVo);
                        break;
                    case 63:
                        vo.setT63(tVo);
                        break;
                    case 64:
                        vo.setT64(tVo);
                        break;
                    case 65:
                        vo.setT65(tVo);
                        break;
                    case 66:
                        vo.setT66(tVo);
                        break;
                    case 67:
                        vo.setT67(tVo);
                        break;
                    case 68:
                        vo.setT68(tVo);
                        break;
                    case 69:
                        vo.setT69(tVo);
                        break;
                    case 70:
                        vo.setT70(tVo);
                        break;
                    case 71:
                        vo.setT71(tVo);
                        break;
                    case 72:
                        vo.setT72(tVo);
                        break;
                    case 73:
                        vo.setT73(tVo);
                        break;
                    case 74:
                        vo.setT74(tVo);
                        break;
                    case 75:
                        vo.setT75(tVo);
                        break;
                    case 76:
                        vo.setT76(tVo);
                        break;
                    case 77:
                        vo.setT77(tVo);
                        break;
                    case 78:
                        vo.setT78(tVo);
                        break;
                    case 79:
                        vo.setT79(tVo);
                        break;
                    case 80:
                        vo.setT80(tVo);
                        break;
                    case 81:
                        vo.setT81(tVo);
                        break;
                    case 82:
                        vo.setT82(tVo);
                        break;
                    case 83:
                        vo.setT83(tVo);
                        break;
                    case 84:
                        vo.setT84(tVo);
                        break;
                    case 85:
                        vo.setT85(tVo);
                        break;
                    case 86:
                        vo.setT86(tVo);
                        break;
                    case 87:
                        vo.setT87(tVo);
                        break;
                    case 88:
                        vo.setT88(tVo);
                        break;
                    case 89:
                        vo.setT89(tVo);
                        break;
                    case 90:
                        vo.setT90(tVo);
                        break;
                    case 91:
                        vo.setT91(tVo);
                        break;
                    case 92:
                        vo.setT92(tVo);
                        break;
                    case 93:
                        vo.setT93(tVo);
                        break;
                    case 94:
                        vo.setT94(tVo);
                        break;
                    case 95:
                        vo.setT95(tVo);
                        break;
                    case 96:
                        vo.setT96(tVo);
                        break;
                    case 97:
                        vo.setT97(tVo);
                        break;
                    case 98:
                        vo.setT98(tVo);
                        break;
                    case 99:
                        vo.setT99(tVo);
                        break;
                    case 100:
                        vo.setT100(tVo);
                        break;
                }
                i++;
            }
            //当学生未填写调查问卷上，如果传给前端的t1.t2等字段未Null，会出错。。。。
           /* if(StringUtils.isNull(anVo.getList()) || anVo.getList().size() == 0){

            }*/
            voList.add(vo);
        }
        return voList;
    }

    /**
     * 新增或修改时，获取排序在本题之上的选择或多选题,即排讯号小于当前题目的排序
     * */
    @Override
    public List<SchoolDcwjNr> getSelectList(SchoolDcwjNr schoolDcwjNr) {
        List<SchoolDcwjNr> list = schoolDcwjNrMapper.getSelectList(schoolDcwjNr);
        return list;
    }

    /**
     * 删除所有页面逻辑
     * */
    @Override
    public int deleteAllLogic(Long dcwjId) {
        LambdaQueryWrapper<SchoolDcwjNr> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolDcwjNr::getDcwjId,dcwjId);
        List<SchoolDcwjNr> list = schoolDcwjNrMapper.selectList(lqw);
        int num = 0;
        for(SchoolDcwjNr nr : list){
            LambdaUpdateWrapper<SchoolDcwjNr> luw = new LambdaUpdateWrapper<>();
            luw.eq(SchoolDcwjNr::getId,nr.getId()).set(SchoolDcwjNr::getNrId,null).set(SchoolDcwjNr::getNrSelect,null);
            num += schoolDcwjNrMapper.update(null,luw);
        }
        return num == list.size() ? 1 : 0;
    }

    /**
     * 是否被其他题所关联
     */
    @Override
    public boolean hasRelationById(Long id) {
        LambdaQueryWrapper<SchoolDcwjNr> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolDcwjNr::getNrId,id);
        List<SchoolDcwjNr> list = schoolDcwjNrMapper.selectList(lqw);
        if(StringUtils.isNull(list) || list.size() == 0){
            //未查到数据，表示改题目没有被其他题目所关联
            return false;
        }
        return true;
    }

    //获取题目选择项
    @Override
    public DcwjNrVo queryById(Long id) {
        DcwjNrVo vo = new DcwjNrVo();
        SchoolDcwjNr nr = schoolDcwjNrMapper.selectById(id);
        BeanUtils.copyProperties(nr,vo);
        //如果是选择题则要返回选择项
        if(DcwjType.DANXUAN.equals(nr.getNrLx()) || DcwjType.DUOXUAN.equals(nr.getNrLx())){
            List<DcwjNrSelectVo> list = new ArrayList<>();
            DcwjNrSelectVo selectVo =new DcwjNrSelectVo();
            if (StringUtils.isNotNull(nr.getNrA()) && !("".equals(nr.getNrA()))){
                selectVo.setKey(1);
                selectVo.setProp("nrA");
                selectVo.setLabel("选项A");
                selectVo.setValue(nr.getNrA());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrB())&& !("".equals(nr.getNrB()))){
                selectVo.setKey(2);
                selectVo.setProp("nrB");
                selectVo.setLabel("选项B");
                selectVo.setValue(nr.getNrB());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrC())&& !("".equals(nr.getNrC()))){
                selectVo.setKey(3);
                selectVo.setProp("nrC");
                selectVo.setLabel("选项C");
                selectVo.setValue(nr.getNrC());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrD())&& !("".equals(nr.getNrD()))){
                selectVo.setKey(4);
                selectVo.setProp("nrD");
                selectVo.setLabel("选项D");
                selectVo.setValue(nr.getNrD());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrE())&& !("".equals(nr.getNrE()))){
                selectVo.setKey(5);
                selectVo.setProp("nrE");
                selectVo.setLabel("选项E");
                selectVo.setValue(nr.getNrE());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrF())&& !("".equals(nr.getNrF()))){
                selectVo.setKey(6);
                selectVo.setProp("nrF");
                selectVo.setLabel("选项F");
                selectVo.setValue(nr.getNrF());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrG())&& !("".equals(nr.getNrG()))){
                selectVo.setKey(7);
                selectVo.setProp("nrG");
                selectVo.setLabel("选项G");
                selectVo.setValue(nr.getNrG());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrH())&& !("".equals(nr.getNrH()))){
                selectVo.setKey(8);
                selectVo.setProp("nrH");
                selectVo.setLabel("选项H");
                selectVo.setValue(nr.getNrH());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrI())&& !("".equals(nr.getNrI()))){
                selectVo.setKey(9);
                selectVo.setProp("nrI");
                selectVo.setLabel("选项I");
                selectVo.setValue(nr.getNrI());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrJ())&& !("".equals(nr.getNrJ()))){
                selectVo.setKey(10);
                selectVo.setProp("nrJ");
                selectVo.setLabel("选项J");
                selectVo.setValue(nr.getNrJ());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrK())&& !("".equals(nr.getNrK()))){
                selectVo.setKey(11);
                selectVo.setProp("nrK");
                selectVo.setLabel("选项K");
                selectVo.setValue(nr.getNrK());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrL())&& !("".equals(nr.getNrL()))){
                selectVo.setKey(12);
                selectVo.setProp("nrL");
                selectVo.setLabel("选项L");
                selectVo.setValue(nr.getNrL());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrM())&& !("".equals(nr.getNrM()))){
                selectVo.setKey(13);
                selectVo.setProp("nrM");
                selectVo.setLabel("选项M");
                selectVo.setValue(nr.getNrM());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrN())&& !("".equals(nr.getNrN()))){
                selectVo.setKey(14);
                selectVo.setProp("nrN");
                selectVo.setLabel("选项N");
                selectVo.setValue(nr.getNrN());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrO())&& !("".equals(nr.getNrO()))){
                selectVo.setKey(15);
                selectVo.setProp("nrO");
                selectVo.setLabel("选项O");
                selectVo.setValue(nr.getNrO());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrP()) && !("".equals(nr.getNrP()))){
                selectVo.setKey(16);
                selectVo.setProp("nrP");
                selectVo.setLabel("选项P");
                selectVo.setValue(nr.getNrP());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrQ())&& !("".equals(nr.getNrQ()))){
                selectVo.setKey(17);
                selectVo.setProp("nrQ");
                selectVo.setLabel("选项Q");
                selectVo.setValue(nr.getNrQ());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrR())&& !("".equals(nr.getNrR()))){
                selectVo.setKey(18);
                selectVo.setProp("nrR");
                selectVo.setLabel("选项R");
                selectVo.setValue(nr.getNrR());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrS())&& !("".equals(nr.getNrS()))){
                selectVo.setKey(19);
                selectVo.setProp("nrS");
                selectVo.setLabel("选项S");
                selectVo.setValue(nr.getNrS());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrT())&& !("".equals(nr.getNrT()))){
                selectVo.setKey(20);
                selectVo.setProp("nrT");
                selectVo.setLabel("选项T");
                selectVo.setValue(nr.getNrT());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrU())&& !("".equals(nr.getNrU()))){
                selectVo.setKey(21);
                selectVo.setProp("nrU");
                selectVo.setLabel("选项U");
                selectVo.setValue(nr.getNrU());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrV())&& !("".equals(nr.getNrV()))){
                selectVo.setKey(22);
                selectVo.setProp("nrV");
                selectVo.setLabel("选项V");
                selectVo.setValue(nr.getNrV());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrW())&& !("".equals(nr.getNrW()))){
                selectVo.setKey(23);
                selectVo.setProp("nrW");
                selectVo.setLabel("选项W");
                selectVo.setValue(nr.getNrW());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrX())&& !("".equals(nr.getNrX()))){
                selectVo.setKey(24);
                selectVo.setProp("nrX");
                selectVo.setLabel("选项X");
                selectVo.setValue(nr.getNrX());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrY())&& !("".equals(nr.getNrY()))){
                selectVo.setKey(25);
                selectVo.setProp("nrY");
                selectVo.setLabel("选项Y");
                selectVo.setValue(nr.getNrY());
                list.add(selectVo);
            }
            if (StringUtils.isNotNull(nr.getNrZ())&& !("".equals(nr.getNrZ()))){
                selectVo.setKey(26);
                selectVo.setProp("nrZ");
                selectVo.setLabel("选项Z");
                selectVo.setValue(nr.getNrZ());
                list.add(selectVo);
            }
            vo.setList(list);
        }
        return vo;
    }
}
