package yangtz.cs.liu.campus.service.impl.schoolClass;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.core.utils.HolidayDateUtil;
import com.core.utils.StringUtil;
import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.constant.ClassConstant;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClassHeadmaster;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClassMentor;
import yangtz.cs.liu.campus.domain.schoolCurriculum.SchoolCurriculum;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassHeadmasterMapper;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassMapper;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassMentorMapper;
import yangtz.cs.liu.campus.mapper.schoolCurriculum.SchoolCurriculumMapper;
import yangtz.cs.liu.campus.mapper.schoolgrade.SchoolGradeMapper;
import yangtz.cs.liu.campus.mapper.teacher.SchoolTeacherMapper;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentParentService;
import yangtz.cs.liu.campus.vo.schoolClass.ClassBatchVo;
import yangtz.cs.liu.campus.vo.schoolClass.ClassTreeSelect;
import yangtz.cs.liu.campus.vo.schoolClass.SchoolClassDrVo;
import yangtz.cs.liu.campus.vo.schoolClass.SchoolClassMentorVo;
import yangtz.cs.liu.wechat.vo.schoolClass.SchoolClassVo;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;
import static com.ruoyi.common.utils.StringUtils.isNotNull;
import static yangtz.cs.liu.campus.constant.ClassConstant.*;

@Service
public class SchoolClassImpl extends ServiceImpl<SchoolClassMapper, SchoolClass> implements ISchoolClassService {

    @Autowired
    private SchoolClassMapper schoolClassMapper;

    @Autowired
    private ISchoolStudentParentService schoolStudentParentService;

    @Autowired
    private SchoolTeacherMapper teacherMapper;
    @Autowired
    private SchoolGradeMapper gradeMapper;

    @Autowired
    private SchoolClassHeadmasterMapper headmasterMapper;

    @Autowired
    private SchoolClassMentorMapper mentorMapper;

    @Autowired
    private SchoolCurriculumMapper curriculumMapper;

    @Override
    public List<SchoolClass> selectSchoolClassList(SchoolClass schoolClass) {
        LambdaQueryWrapper<SchoolClass> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotNull(schoolClass.getSchoolYear()), SchoolClass::getSchoolYear, schoolClass.getSchoolYear())
                .eq(isNotNull(schoolClass.getClassType()), SchoolClass::getClassType, schoolClass.getClassType())
                .eq(isNotNull(schoolClass.getGradeValue()), SchoolClass::getGradeValue, schoolClass.getGradeValue())
                .eq(isNotNull(schoolClass.getClassValue()), SchoolClass::getClassValue, schoolClass.getClassValue())
                .like(isNotNull(schoolClass.getClassAlias()), SchoolClass::getClassAlias, schoolClass.getClassAlias())
                .like(isNotNull(schoolClass.getHouseName()), SchoolClass::getHouseName, schoolClass.getHouseName())
                .like(isNotNull(schoolClass.getTeacherName()), SchoolClass::getTeacherName, schoolClass.getTeacherName())
                .eq(isNotNull(schoolClass.getIsGraduated()), SchoolClass::getIsGraduated, schoolClass.getIsGraduated())
                .eq(isNotNull(schoolClass.getTeacherId()), SchoolClass::getTeacherId, schoolClass.getTeacherId())
                .like(isNotBlank(schoolClass.getTeacherTel()), SchoolClass::getTeacherTel, schoolClass.getTeacherTel())
                .orderByDesc(SchoolClass::getSchoolYear)
                .orderByAsc(SchoolClass::getGradeValue)
                .orderByAsc(SchoolClass::getClassValue)
        ;
        return schoolClassMapper.selectList(lqw);
    }

//    @Override
//    public List<SchoolGrade> selectShoolYearForSelecter(SchoolGrade schoolGrade) {
//        LambdaQueryWrapper<SchoolGrade> lqw = new LambdaQueryWrapper<>();
//        lqw
//                .eq(SchoolGrade::getIsUsed, 0)
//                .select(SchoolGrade::getSchoolYear);
//
//        return schoolGradeMapper.selectList(lqw);
//    }


    @Override
    public List<SchoolClass> selectClassForSelecter(SchoolClass schoolClass) {
        LambdaQueryWrapper<SchoolClass> lqw = new LambdaQueryWrapper<>();
        lqw
                .select(SchoolClass::getGradeValue);
        return schoolClassMapper.selectList(lqw);
    }

    @Override
    public List<SchoolClass> selectClassForSelecter(Long id) {
        return schoolClassMapper.selectClassList(id);
    }

    @Override
    public SchoolClass selectSchoolClassById(Long id) {
        LambdaQueryWrapper<SchoolClass> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolClass::getId, id);
        SchoolClass schoolClass = schoolClassMapper.selectOne(lqw);
        return schoolClass;
    }


    /**
     * 微信公众号（家长查看班级）
     *
     * @param
     * @return
     */
    @Override
    public SchoolClass getUserClassByParent(Long studentId) {
        return schoolClassMapper.getUserClassByParent(studentId);
    }

    /**
     * 微信公众号（老师查看班级）
     *
     * @param teacherId
     * @return
     */
    @Override
    public List<SchoolClassVo> getUserClassByTeacher(Long teacherId) {
        return schoolClassMapper.getUserClassByTeacher(teacherId);
    }

    @Override
    public List<SchoolClassVo> getTeacherClass(Long teacherId) {
//        int schoolYear = HolidayDateUtil.getSchoolYear();
        // TODO 修改最新学年
        int schoolYear = gradeMapper.isNewSchoolYear();
        return schoolClassMapper.getTeacherClass(teacherId,schoolYear);
    }


    @Override
    public List<SchoolClassVo> selectSchoolClassSchoolYear(String schoolYear) {
        return schoolClassMapper.selectSchoolClassSchoolYear(schoolYear);
    }

    @Override
    public void checkImport(List<SchoolClassDrVo> list) {
        //是否为空
        if (StringUtils.isNull(list) || list.size() == 0) {
            throw new ServiceException("导入数据不能为空");
        }
        //记录日志数据
        int failureNum = 0;
        StringBuilder failureMsg = new StringBuilder();
        for (SchoolClassDrVo schoolClass : list) {
            if (StringUtils.isNull(schoolClass.getGradeValue())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、年级为空，请你重新输入！");
            } else if (StringUtils.isNull(schoolClass.getClassValue())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、班级为空，请你重新输入！");
            } else if (StringUtils.isEmpty(schoolClass.getTeacherName())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、班主任姓名为空，请您重新输入！");
            } else if (StringUtils.isEmpty(schoolClass.getTeacherTel())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、班主任手机号为空，请您重新输入！");
            } else if (StringUtils.isNull(schoolClass.getSchoolYear())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、开始学年为空，请您重新输入！");
            } else {
               /* LambdaQueryWrapper<SchoolClass> lqw = new LambdaQueryWrapper<>();
                lqw
                        .eq(SchoolClass::getSchoolYear, schoolClass.getSchoolYear())
                        .eq(SchoolClass::getGradeValue, schoolClass.getGradeValue())
                        .eq(SchoolClass::getClassValue, schoolClass.getClassValue());
                SchoolClass aClass = schoolClassMapper.selectOne(lqw);
                if (isNotNull(aClass)) {
                    failureNum++;
                    failureMsg.append("<br/>" + failureNum + "、班级已经存在,请您重新输入! ");

                } else {*/
                    //班级不存在
                    //年级是否存在
                    LambdaQueryWrapper<SchoolGrade> sg = new LambdaQueryWrapper<>();
                    sg.eq(SchoolGrade::getSchoolYear, schoolClass.getSchoolYear())
                            .eq(SchoolGrade::getGradeValue, schoolClass.getGradeValue());
                    List<SchoolGrade> gradeList = gradeMapper.selectList(sg);
                    if (StringUtils.isNull(gradeList) || gradeList.size() == 0) {
                        failureNum++;
                        failureMsg.append("<br/>" + failureNum + "、" + schoolClass.getSchoolYear() + "学年" + schoolClass.getGradeValue() + "年级不存在,请您重新输入! ");
                    } else {
                        //年级存在
                        SchoolGrade grade = gradeList.get(0);
                        LambdaQueryWrapper<SchoolTeacher> sTea = new LambdaQueryWrapper<>();
                        sTea
                                .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName()))
                                .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel()));
                        List<SchoolTeacher> teacherList = teacherMapper.selectList(sTea);
                        if (StringUtils.isNull(teacherList) || teacherList.size() == 0) {
                            failureNum++;
                            failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName() + "手机号为" + schoolClass.getTeacherTel() + "的教师不存在,请您重新输入! ");
                        } else {
                            //存在该教师
                            SchoolTeacher teacher = teacherList.get(0);
                            //设置班级类型为高中
                            schoolClass.setClassType("4");
                            //设置年级名称
                            if (1 == schoolClass.getGradeValue()) {
                                schoolClass.setGradeName("一年级");
                            } else if (2 == schoolClass.getGradeValue()) {
                                schoolClass.setGradeName("二年级");
                            } else if (3 == schoolClass.getGradeValue()) {
                                schoolClass.setGradeName("三年级");
                            }

                            //设置班级名称
                            if (1 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("一班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C1);break;
                                        case 2: schoolClass.setClassAlias(G2+C1);break;
                                        case 3: schoolClass.setClassAlias(G3+C1);break;
                                    }
                                }
                            } else if (2 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("二班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C2);break;
                                        case 2: schoolClass.setClassAlias(G2+C2);break;
                                        case 3: schoolClass.setClassAlias(G3+C2);break;
                                    }
                                }
                            } else if (3 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("三班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C3);break;
                                        case 2: schoolClass.setClassAlias(G2+C3);break;
                                        case 3: schoolClass.setClassAlias(G3+C3);break;
                                    }
                                }
                            } else if (4 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("四班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C4);break;
                                        case 2: schoolClass.setClassAlias(G2+C4);break;
                                        case 3: schoolClass.setClassAlias(G3+C4);break;
                                    }
                                }
                            } else if (5 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("五班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C5);break;
                                        case 2: schoolClass.setClassAlias(G2+C5);break;
                                        case 3: schoolClass.setClassAlias(G3+C5);break;
                                    }
                                }
                            } else if (6 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("六班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C6);break;
                                        case 2: schoolClass.setClassAlias(G2+C6);break;
                                        case 3: schoolClass.setClassAlias(G3+C6);break;
                                    }
                                }
                            } else if (7 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("七班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C7);break;
                                        case 2: schoolClass.setClassAlias(G2+C7);break;
                                        case 3: schoolClass.setClassAlias(G3+C7);break;
                                    }
                                }
                            } else if (8 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("八班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C8);break;
                                        case 2: schoolClass.setClassAlias(G2+C8);break;
                                        case 3: schoolClass.setClassAlias(G3+C8);break;
                                    }
                                }
                            } else if (9 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("九班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C9);break;
                                        case 2: schoolClass.setClassAlias(G2+C9);break;
                                        case 3: schoolClass.setClassAlias(G3+C9);break;
                                    }
                                }
                            } else if (10 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("十班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C10);break;
                                        case 2: schoolClass.setClassAlias(G2+C10);break;
                                        case 3: schoolClass.setClassAlias(G3+C10);break;
                                    }
                                }
                            }else if (11 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("十一班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C11);break;
                                        case 2: schoolClass.setClassAlias(G2+C11);break;
                                        case 3: schoolClass.setClassAlias(G3+C11);break;
                                    }
                                }
                            } else if (12 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("十二班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C12);break;
                                        case 2: schoolClass.setClassAlias(G2+C12);break;
                                        case 3: schoolClass.setClassAlias(G3+C12);break;
                                    }
                                }
                            } else if (13 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("十三班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C13);break;
                                        case 2: schoolClass.setClassAlias(G2+C13);break;
                                        case 3: schoolClass.setClassAlias(G3+C13);break;
                                    }
                                }
                            } else if (14 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("十四班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C14);break;
                                        case 2: schoolClass.setClassAlias(G2+C14);break;
                                        case 3: schoolClass.setClassAlias(G3+C14);break;
                                    }
                                }
                            } else if (15 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("十五班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C15);break;
                                        case 2: schoolClass.setClassAlias(G2+C15);break;
                                        case 3: schoolClass.setClassAlias(G3+C15);break;
                                    }
                                }
                            } else if (16 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("十六班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C16);break;
                                        case 2: schoolClass.setClassAlias(G2+C16);break;
                                        case 3: schoolClass.setClassAlias(G3+C16);break;
                                    }
                                }
                            } else if (17 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("十七班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C17);break;
                                        case 2: schoolClass.setClassAlias(G2+C17);break;
                                        case 3: schoolClass.setClassAlias(G3+C17);break;
                                    }
                                }
                            } else if (18 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("十八班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C18);break;
                                        case 2: schoolClass.setClassAlias(G2+C18);break;
                                        case 3: schoolClass.setClassAlias(G3+C18);break;
                                    }
                                }
                            } else if (19 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("十九班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C19);break;
                                        case 2: schoolClass.setClassAlias(G2+C19);break;
                                        case 3: schoolClass.setClassAlias(G3+C19);break;
                                    }
                                }
                            } else if (20 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("二十班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C20);break;
                                        case 2: schoolClass.setClassAlias(G2+C20);break;
                                        case 3: schoolClass.setClassAlias(G3+C20);break;
                                    }
                                }
                            }else if (21 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("二十一班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C21);break;
                                        case 2: schoolClass.setClassAlias(G2+C21);break;
                                        case 3: schoolClass.setClassAlias(G3+C21);break;
                                    }
                                }
                            } else if (22 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("二十二班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C22);break;
                                        case 2: schoolClass.setClassAlias(G2+C22);break;
                                        case 3: schoolClass.setClassAlias(G3+C22);break;
                                    }
                                }
                            } else if (23 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("二十三班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C23);break;
                                        case 2: schoolClass.setClassAlias(G2+C23);break;
                                        case 3: schoolClass.setClassAlias(G3+C23);break;
                                    }
                                }
                            } else if (24 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("二十四班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C24);break;
                                        case 2: schoolClass.setClassAlias(G2+C24);break;
                                        case 3: schoolClass.setClassAlias(G3+C24);break;
                                    }
                                }
                            } else if (25 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("二十五班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C25);break;
                                        case 2: schoolClass.setClassAlias(G2+C25);break;
                                        case 3: schoolClass.setClassAlias(G3+C25);break;
                                    }
                                }
                            } else if (26 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("二十六班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C26);break;
                                        case 2: schoolClass.setClassAlias(G2+C26);break;
                                        case 3: schoolClass.setClassAlias(G3+C26);break;
                                    }
                                }
                            } else if (27 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("二十七班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C27);break;
                                        case 2: schoolClass.setClassAlias(G2+C27);break;
                                        case 3: schoolClass.setClassAlias(G3+C27);break;
                                    }
                                }
                            } else if (28 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("二十八班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C28);break;
                                        case 2: schoolClass.setClassAlias(G2+C28);break;
                                        case 3: schoolClass.setClassAlias(G3+C28);break;
                                    }
                                }
                            } else if (29 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("二十九班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C29);break;
                                        case 2: schoolClass.setClassAlias(G2+C29);break;
                                        case 3: schoolClass.setClassAlias(G3+C29);break;
                                    }
                                }
                            } else if (30 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("三十班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C30);break;
                                        case 2: schoolClass.setClassAlias(G2+C30);break;
                                        case 3: schoolClass.setClassAlias(G3+C30);break;
                                    }
                                }
                            }else if (31 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("三十一班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C31);break;
                                        case 2: schoolClass.setClassAlias(G2+C31);break;
                                        case 3: schoolClass.setClassAlias(G3+C31);break;
                                    }
                                }
                            } else if (32 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("三十二班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C32);break;
                                        case 2: schoolClass.setClassAlias(G2+C32);break;
                                        case 3: schoolClass.setClassAlias(G3+C32);break;
                                    }
                                }
                            } else if (33 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("三十三班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C33);break;
                                        case 2: schoolClass.setClassAlias(G2+C33);break;
                                        case 3: schoolClass.setClassAlias(G3+C33);break;
                                    }
                                }
                            } else if (34 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("三十四班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C34);break;
                                        case 2: schoolClass.setClassAlias(G2+C34);break;
                                        case 3: schoolClass.setClassAlias(G3+C34);break;
                                    }
                                }
                            } else if (35 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("三十五班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C35);break;
                                        case 2: schoolClass.setClassAlias(G2+C35);break;
                                        case 3: schoolClass.setClassAlias(G3+C35);break;
                                    }
                                }
                            } else if (36 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("三十六班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C36);break;
                                        case 2: schoolClass.setClassAlias(G2+C36);break;
                                        case 3: schoolClass.setClassAlias(G3+C36);break;
                                    }
                                }
                            } else if (37 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("三十七班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C37);break;
                                        case 2: schoolClass.setClassAlias(G2+C37);break;
                                        case 3: schoolClass.setClassAlias(G3+C37);break;
                                    }
                                }
                            } else if (38 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("三十八班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C38);break;
                                        case 2: schoolClass.setClassAlias(G2+C38);break;
                                        case 3: schoolClass.setClassAlias(G3+C38);break;
                                    }
                                }
                            } else if (39 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("三十九班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C39);break;
                                        case 2: schoolClass.setClassAlias(G2+C39);break;
                                        case 3: schoolClass.setClassAlias(G3+C39);break;
                                    }
                                }
                            } else if (40 == schoolClass.getClassValue()) {
                                schoolClass.setClassName("四十班");
                                if(StringUtils.isEmpty(schoolClass.getClassAlias())){
                                    switch (schoolClass.getGradeValue()){
                                        case 1: schoolClass.setClassAlias(G1+C40);break;
                                        case 2: schoolClass.setClassAlias(G2+C40);break;
                                        case 3: schoolClass.setClassAlias(G3+C40);break;
                                    }
                                }
                            }

                            //设置班主任id
                            schoolClass.setTeacherId(teacher.getId());
                            //设置年级id
                            schoolClass.setGradeId(grade.getId());
                            //设置是否是最新学年
                            schoolClass.setSfzxxn(grade.getSfzxxn());

                        }
                        // TODO 校验任课老师是否存在
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName1()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel1())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName1()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel1()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName1() + "手机号为" + schoolClass.getTeacherTel1() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId1(teacher1.getId());
                            }
                        }
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName2()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel2())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName2()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel2()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName2() + "手机号为" + schoolClass.getTeacherTel2() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId2(teacher1.getId());
                            }
                        }
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName3()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel3())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName3()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel3()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName3() + "手机号为" + schoolClass.getTeacherTel3() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId3(teacher1.getId());
                            }
                        }
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName4()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel4())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName4()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel4()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName4() + "手机号为" + schoolClass.getTeacherTel4() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId4(teacher1.getId());
                            }
                        }
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName5()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel5())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName5()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel5()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName5() + "手机号为" + schoolClass.getTeacherTel5() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId5(teacher1.getId());
                            }
                        }
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName6()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel6())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName6()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel6()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName6() + "手机号为" + schoolClass.getTeacherTel6() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId6(teacher1.getId());
                            }
                        }
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName7()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel7())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName7()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel7()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName7() + "手机号为" + schoolClass.getTeacherTel7() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId7(teacher1.getId());
                            }
                        }
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName8()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel8())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName8()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel8()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName8() + "手机号为" + schoolClass.getTeacherTel8() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId8(teacher1.getId());
                            }
                        }
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName9()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel9())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName9()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel9()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName9() + "手机号为" + schoolClass.getTeacherTel9() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId9(teacher1.getId());
                            }
                        }
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName10()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel10())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName10()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel10()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName10() + "手机号为" + schoolClass.getTeacherTel10() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId10(teacher1.getId());
                            }
                        }
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName11()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel11())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName11()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel11()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName11() + "手机号为" + schoolClass.getTeacherTel11() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId11(teacher1.getId());
                            }
                        }
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName12()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel12())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName12()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel12()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName12() + "手机号为" + schoolClass.getTeacherTel12() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId12(teacher1.getId());
                            }
                        }
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName13()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel13())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName13()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel13()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName13() + "手机号为" + schoolClass.getTeacherTel13() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId13(teacher1.getId());
                            }
                        }
                        if (StringUtils.isNotEmpty(schoolClass.getTeacherName14()) && StringUtils.isNotEmpty(schoolClass.getTeacherTel14())){
                            LambdaQueryWrapper<SchoolTeacher> sTea1 = new LambdaQueryWrapper<>();
                            sTea1
                                    .eq(SchoolTeacher::getTeacherName, StringUtil.clearSpace(schoolClass.getTeacherName14()))
                                    .eq(SchoolTeacher::getTeacherTel, StringUtil.clearSpace(schoolClass.getTeacherTel14()));
                            List<SchoolTeacher> teacherList1 = teacherMapper.selectList(sTea1);
                            if (StringUtils.isNull(teacherList1) || teacherList1.size() == 0){
                                failureNum++;
                                failureMsg.append("<br/>" + failureNum + "、教师名为" + schoolClass.getTeacherName14() + "手机号为" + schoolClass.getTeacherTel14() + "的教师不存在,请您重新输入! ");
                            }else {
                                //存在该教师
                                SchoolTeacher teacher1 = teacherList1.get(0);
                                schoolClass.setTeacherId14(teacher1.getId());
                            }
                        }
                    }
                //}
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，导入失败！共" + failureNum + "条数据格式不正确，错误如下：");
            throw new BaseException(failureMsg.toString());
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String importExamDetail(List<SchoolClassDrVo> list) {
        // 准备记录日志数据
        int successNum = 0;
        StringBuilder successMsg = new StringBuilder();
        for (SchoolClassDrVo schoolClass : list) {
            LambdaQueryWrapper<SchoolClass> lqw = new LambdaQueryWrapper<>();
            lqw
                    .eq(SchoolClass::getSchoolYear, schoolClass.getSchoolYear())
                    .eq(SchoolClass::getGradeValue, schoolClass.getGradeValue())
                    .eq(SchoolClass::getClassValue, schoolClass.getClassValue());
            SchoolClass aClass = schoolClassMapper.selectOne(lqw);
            if (isNotNull(aClass)) {
                //赋值
                aClass.setTeacherId(schoolClass.getTeacherId());
                aClass.setTeacherName(StringUtil.clearSpace(schoolClass.getTeacherName()));
                aClass.setTeacherTel(StringUtil.clearSpace(schoolClass.getTeacherTel()));
                aClass.setHouseName(schoolClass.getHouseName());
                aClass.setClassSlogan(schoolClass.getClassSlogan());
                aClass.setTeacherWord(schoolClass.getTeacherWord());
                aClass.setKeyClass(schoolClass.getKeyClass());
                aClass.setChooseCourse(schoolClass.getChooseCourse());
                aClass.update();
                schoolClassMapper.updateById(aClass);
                //删除本班级与班主任表
                LambdaQueryWrapper<SchoolClassHeadmaster> l = new LambdaQueryWrapper<>();
                l.eq(SchoolClassHeadmaster::getClassId,aClass.getId());
                headmasterMapper.delete(l);
                SchoolClassHeadmaster headmaster = new SchoolClassHeadmaster();
                headmaster.setTeacherId(aClass.getTeacherId());
                headmaster.setClassId(aClass.getId());
                headmaster.setStartTime(DateUtils.getNowDate());
                headmaster.insert();
                headmasterMapper.insert(headmaster);
                // TODO 新增任课教师
                //删除本班级与任课教师关系表
                if (StringUtils.isNotNull(schoolClass.getTeacherId1()) && StringUtils.isNotEmpty(schoolClass.getCourseName1())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId1(),schoolClass.getCourseName1());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId2()) && StringUtils.isNotEmpty(schoolClass.getCourseName2())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId2(),schoolClass.getCourseName2());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId3()) && StringUtils.isNotEmpty(schoolClass.getCourseName3())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId3(),schoolClass.getCourseName3());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId4()) && StringUtils.isNotEmpty(schoolClass.getCourseName4())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId4(),schoolClass.getCourseName4());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId5()) && StringUtils.isNotEmpty(schoolClass.getCourseName5())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId5(),schoolClass.getCourseName5());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId6()) && StringUtils.isNotEmpty(schoolClass.getCourseName6())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId6(),schoolClass.getCourseName6());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId7()) && StringUtils.isNotEmpty(schoolClass.getCourseName7())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId7(),schoolClass.getCourseName7());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId8()) && StringUtils.isNotEmpty(schoolClass.getCourseName8())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId8(),schoolClass.getCourseName8());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId9()) && StringUtils.isNotEmpty(schoolClass.getCourseName9())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId9(),schoolClass.getCourseName9());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId10()) && StringUtils.isNotEmpty(schoolClass.getCourseName10())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId10(),schoolClass.getCourseName10());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId11()) && StringUtils.isNotEmpty(schoolClass.getCourseName11())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId11(),schoolClass.getCourseName11());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId12()) && StringUtils.isNotEmpty(schoolClass.getCourseName12())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId12(),schoolClass.getCourseName12());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId13()) && StringUtils.isNotEmpty(schoolClass.getCourseName13())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId13(),schoolClass.getCourseName13());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId14()) && StringUtils.isNotEmpty(schoolClass.getCourseName14())){
                    insertMentor(aClass.getId(),schoolClass.getTeacherId14(),schoolClass.getCourseName14());
                }
                successNum++;
            } else {
                SchoolClass schoolClass1 = new SchoolClass();
                BeanUtils.copyProperties(schoolClass,schoolClass1);
                schoolClassMapper.insert(schoolClass1);
                SchoolClassHeadmaster headmaster = new SchoolClassHeadmaster();
                headmaster.setTeacherId(schoolClass1.getTeacherId());
                headmaster.setClassId(schoolClass1.getId());
                headmaster.setStartTime(DateUtils.getNowDate());
                headmaster.insert();
                headmasterMapper.insert(headmaster);
                if (StringUtils.isNotNull(schoolClass.getTeacherId1()) && StringUtils.isNotEmpty(schoolClass.getCourseName1())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId1(),schoolClass.getCourseName1());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId2()) && StringUtils.isNotEmpty(schoolClass.getCourseName2())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId2(),schoolClass.getCourseName2());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId3()) && StringUtils.isNotEmpty(schoolClass.getCourseName3())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId3(),schoolClass.getCourseName3());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId4()) && StringUtils.isNotEmpty(schoolClass.getCourseName4())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId4(),schoolClass.getCourseName4());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId5()) && StringUtils.isNotEmpty(schoolClass.getCourseName5())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId5(),schoolClass.getCourseName5());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId6()) && StringUtils.isNotEmpty(schoolClass.getCourseName6())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId6(),schoolClass.getCourseName6());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId7()) && StringUtils.isNotEmpty(schoolClass.getCourseName7())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId7(),schoolClass.getCourseName7());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId8()) && StringUtils.isNotEmpty(schoolClass.getCourseName8())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId8(),schoolClass.getCourseName8());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId9()) && StringUtils.isNotEmpty(schoolClass.getCourseName9())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId9(),schoolClass.getCourseName9());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId10()) && StringUtils.isNotEmpty(schoolClass.getCourseName10())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId10(),schoolClass.getCourseName10());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId11()) && StringUtils.isNotEmpty(schoolClass.getCourseName11())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId11(),schoolClass.getCourseName11());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId12()) && StringUtils.isNotEmpty(schoolClass.getCourseName12())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId12(),schoolClass.getCourseName12());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId13()) && StringUtils.isNotEmpty(schoolClass.getCourseName13())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId13(),schoolClass.getCourseName13());
                }
                if (StringUtils.isNotNull(schoolClass.getTeacherId14()) && StringUtils.isNotEmpty(schoolClass.getCourseName14())){
                    insetClassMentor(schoolClass1.getId(),schoolClass.getTeacherId14(),schoolClass.getCourseName14());
                }
                successNum++;
            }
        }
        successMsg.insert(0, "恭喜您，数据已导入成功！共有 " + successNum + " 条，数据如下：");
        return successMsg.toString();
    }

    // TODO 新增任课教师与班级关系
    private int insetClassMentor(Long classId,Long teacherId,String courseName){
        LambdaQueryWrapper<SchoolCurriculum> c1 = new LambdaQueryWrapper<>();
        c1.eq(SchoolCurriculum::getCourseName,courseName);
        SchoolCurriculum schoolCurriculum = curriculumMapper.selectOne(c1);
        SchoolClassMentor schoolClassMentor = new SchoolClassMentor();
        schoolClassMentor.setClassId(classId);
        schoolClassMentor.setTeacherId(teacherId);
        schoolClassMentor.setCourseId(schoolCurriculum.getId());
        schoolClassMentor.setCourseName(courseName);
        schoolClassMentor.insert();
        return mentorMapper.insert(schoolClassMentor);
    }

    // TODO 删除原任课教师与班级关系并新增
    private int insertMentor(Long classId,Long teacherId,String courseName){
        LambdaQueryWrapper<SchoolClassMentor> t1 = new LambdaQueryWrapper<>();
        t1.eq(SchoolClassMentor::getClassId,classId)
                .eq(SchoolClassMentor::getTeacherId,teacherId);
        mentorMapper.delete(t1);
        LambdaQueryWrapper<SchoolCurriculum> c1 = new LambdaQueryWrapper<>();
        c1.eq(SchoolCurriculum::getCourseName,courseName);
        SchoolCurriculum schoolCurriculum = curriculumMapper.selectOne(c1);
        SchoolClassMentor mentor1 = new SchoolClassMentor();
        mentor1.setTeacherId(teacherId);
        mentor1.setClassId(classId);
        mentor1.setCourseId(schoolCurriculum.getId());
        mentor1.setCourseName(courseName);
        mentor1.setStartTime(DateUtils.getNowDate());
        mentor1.insert();
        return mentorMapper.insert(mentor1);
    }

    /**
     * @param schoolClassList
     * @return List<ClassTreeSelect>
     * 构建下拉树
     * @author lyric
     * @date 2022/11/4 14:45
     */
    @Override
    public List<ClassTreeSelect> buildClassTreeList(List<SchoolClass> schoolClassList) {
        // stream 先分组 年份->类型->年级->班级->班级集合
        Map<Integer, Map<String, Map<Integer, Map<Integer, List<SchoolClass>>>>> map =
                schoolClassList.stream().collect(Collectors.groupingBy(SchoolClass::getSchoolYear, LinkedHashMap::new,
                        Collectors.groupingBy(SchoolClass::getClassType, LinkedHashMap::new, Collectors.groupingBy(SchoolClass::getGradeValue, LinkedHashMap::new,
                                Collectors.groupingBy(SchoolClass::getClassValue, LinkedHashMap::new, Collectors.toList())))));
        /**
         * id 表示班级的id
         * label 表示 显示的标签
         * children 表示子节点
         */
        List<ClassTreeSelect> resList = new ArrayList<>();
        /** 年度 */
        for (Map.Entry<Integer, Map<String, Map<Integer, Map<Integer, List<SchoolClass>>>>> yearEntry : map.entrySet()) {
            ClassTreeSelect year = new ClassTreeSelect();
            year.setLabel(yearEntry.getKey().toString());
            List<ClassTreeSelect> yearList = new ArrayList<>();
            year.setChildren(yearList);
            /** 类型 */
            for (Map.Entry<String, Map<Integer, Map<Integer, List<SchoolClass>>>> typeEntry : yearEntry.getValue().entrySet()) {
                ClassTreeSelect type = new ClassTreeSelect();
                type.setLabel(typeEntry.getKey());
                List<ClassTreeSelect> typeList = new ArrayList<>();
                /** 年级 */
                for (Map.Entry<Integer, Map<Integer, List<SchoolClass>>> gradeEntry : typeEntry.getValue().entrySet()) {
                    List<ClassTreeSelect> classLit = new ArrayList<>();
                    ClassTreeSelect theClass = new ClassTreeSelect();
                    theClass.setLabel(gradeEntry.getKey().toString());
                    /** 班级 */
                    for (Map.Entry<Integer, List<SchoolClass>> classEntry : gradeEntry.getValue().entrySet()) {
                        ClassTreeSelect classEnd = new ClassTreeSelect();
                        classEnd.setLabel(classEntry.getValue().get(0).getClassAlias());
                        classEnd.setId(classEntry.getValue().get(0).getId());
                        classEnd.setChildren(null);
                        classLit.add(classEnd);
                    }
                    theClass.setChildren(classLit);
                    typeList.add(theClass);
                }
                type.setChildren(typeList);
                yearList.add(type);
            }
            year.setChildren(yearList);
            resList.add(year);
        }
        return resList;
    }

    /**
     * 查询班级老师信息（pc端）
     *
     * @return
     */
    @Override
    public List<SchoolClassMentorVo> getTeacherList(SchoolClassMentor schoolClassMentor) {
        return schoolClassMapper.getTeacherList(schoolClassMentor);
    }


    /**
     * 班级下拉列表，级部(班级查看)
     *
     * @return
     */
    @Override
    public List<SchoolClass> getClassTressList(List<Long> gradeIds, SchoolClass schoolClass) {
        /*Integer gradeValue = schoolStudentParentService.gradeValue();
        //如果当前登录职工不是级部成员
        if(gradeValue.equals(-1)){
            return new ArrayList<>();
        }
        schoolClass.setGradeValue(gradeValue);*/
        LambdaQueryWrapper<SchoolClass> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(org.apache.commons.lang3.StringUtils.isNotBlank(schoolClass.getClassAlias()), SchoolClass::getClassAlias, schoolClass.getClassAlias())
                .eq(isNotNull(schoolClass.getSchoolYear()), SchoolClass::getSchoolYear, schoolClass.getSchoolYear())
                .eq(isNotNull(schoolClass.getClassValue()), SchoolClass::getClassValue, schoolClass.getClassValue())
                //.eq(isNotNull(gradeValue),SchoolClass::getGradeValue,gradeValue)
                .eq(isNotNull(schoolClass.getGradeValue()), SchoolClass::getGradeValue, schoolClass.getGradeValue())
                .in(isNotNull(gradeIds), SchoolClass::getGradeId, gradeIds)
                .select(SchoolClass::getId, SchoolClass::getSchoolYear,
                        SchoolClass::getClassType, SchoolClass::getGradeValue, SchoolClass::getGradeName,
                        SchoolClass::getClassValue, SchoolClass::getClassName, SchoolClass::getClassAlias)
                .orderByDesc(SchoolClass::getSchoolYear)
                .orderByAsc(SchoolClass::getClassType, SchoolClass::getGradeValue, SchoolClass::getClassValue);
        return schoolClassMapper.selectList(lqw);
    }

    /**
     * 班级列表，级部,新增学生时的弹窗,班级为最新学年
     *
     * @return
     */
    @Override
    public List<SchoolClass> getClassList(List<Long> gradeIds, SchoolClass schoolClass) {
        LambdaQueryWrapper<SchoolClass> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(org.apache.commons.lang3.StringUtils.isNotBlank(schoolClass.getClassAlias()), SchoolClass::getClassAlias, schoolClass.getClassAlias())
                .eq(isNotNull(schoolClass.getSchoolYear()), SchoolClass::getSchoolYear, schoolClass.getSchoolYear())
                .eq(isNotNull(schoolClass.getClassValue()), SchoolClass::getClassValue, schoolClass.getClassValue())
                .eq(isNotNull(schoolClass.getGradeValue()), SchoolClass::getGradeValue, schoolClass.getGradeValue())
                .in(isNotNull(gradeIds), SchoolClass::getGradeId, gradeIds)
                //.eq(SchoolClass::getSfzxxn, NEWTERM)
                .select(SchoolClass::getId, SchoolClass::getSchoolYear,
                        SchoolClass::getClassType, SchoolClass::getGradeValue, SchoolClass::getGradeName,
                        SchoolClass::getClassValue, SchoolClass::getClassName, SchoolClass::getClassAlias)
                .orderByAsc(SchoolClass::getSchoolYear, SchoolClass::getClassType, SchoolClass::getGradeValue, SchoolClass::getClassValue);
        return schoolClassMapper.selectList(lqw);
    }

    /**
     * 获取教师所在最新学年班级列表
     */
    @Override
    public List<Long> getTeacherClasses(Long userId) {
//        int schoolYear = HolidayDateUtil.getSchoolYear();
        // TODO 修改最新学年
        int schoolYear = gradeMapper.isNewSchoolYear();
        return schoolClassMapper.getClassesIdList(userId,schoolYear);
    }

    //批量新增
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int batchAdd(ClassBatchVo vo) {
        int num = 0;
        int num1 = vo.getClassNum1();
        int num2 = vo.getClassNum2();
        int num3 = vo.getClassNum3();
        //高一班级数量大于0才进行新增
        if (0 < num1) {
            //判断当前学年高一级部是否存在
            LambdaQueryWrapper<SchoolGrade> g1 = new LambdaQueryWrapper<>();
            g1.eq(SchoolGrade::getSchoolYear, vo.getSchoolYear())
                    .eq(SchoolGrade::getGradeValue, 1);
            List<SchoolGrade> gList1 = gradeMapper.selectList(g1);
            if (StringUtils.isNull(gList1) || gList1.size() == 0) {
                throw new ServiceException(vo.getSchoolYear() + "学年高一级部不存在，无法新增班级");
            }
            //存在年级
            SchoolGrade grade1 = gList1.get(0);
            String gradeName = GRADE1;
            for (int i = 1; i <= num1; i++) {
                SchoolClass c1 = new SchoolClass();
                c1.setSchoolYear(vo.getSchoolYear());
                //设置为高中
                c1.setClassType("4");
                //设置年级数值和名称
                c1.setGradeId(grade1.getId());
                c1.setGradeValue(grade1.getGradeValue());
                c1.setGradeName(gradeName);
                c1.setSfzxxn(grade1.getSfzxxn());

                //设置班级数值、班级名称、班级别名,目前只支持生成1-33个班级
                c1.setClassValue(i);
                switch (i) {
                    case 1:
                        c1.setClassName(C1);
                        c1.setClassAlias(G1 + C1);
                        break;
                    case 2:
                        c1.setClassName(C2);
                        c1.setClassAlias(G1 + C2);
                        break;
                    case 3:
                        c1.setClassName(C3);
                        c1.setClassAlias(G1 + C3);
                        break;
                    case 4:
                        c1.setClassName(C4);
                        c1.setClassAlias(G1 + C4);
                        break;
                    case 5:
                        c1.setClassName(C5);
                        c1.setClassAlias(G1 + C5);
                        break;
                    case 6:
                        c1.setClassName(C6);
                        c1.setClassAlias(G1 + C6);
                        break;
                    case 7:
                        c1.setClassName(C7);
                        c1.setClassAlias(G1 + C7);
                        break;
                    case 8:
                        c1.setClassName(C8);
                        c1.setClassAlias(G1 + C8);
                        break;
                    case 9:
                        c1.setClassName(C9);
                        c1.setClassAlias(G1 + C9);
                        break;
                    case 10:
                        c1.setClassName(C10);
                        c1.setClassAlias(G1 + C10);
                        break;
                    case 11:
                        c1.setClassName(C11);
                        c1.setClassAlias(G1 + C11);
                        break;
                    case 12:
                        c1.setClassName(C12);
                        c1.setClassAlias(G1 + C12);
                        break;
                    case 13:
                        c1.setClassName(C13);
                        c1.setClassAlias(G1 + C13);
                        break;
                    case 14:
                        c1.setClassName(C14);
                        c1.setClassAlias(G1 + C14);
                        break;
                    case 15:
                        c1.setClassName(C15);
                        c1.setClassAlias(G1 + C15);
                        break;
                    case 16:
                        c1.setClassName(C16);
                        c1.setClassAlias(G1 + C16);
                        break;
                    case 17:
                        c1.setClassName(C17);
                        c1.setClassAlias(G1 + C17);
                        break;
                    case 18:
                        c1.setClassName(C18);
                        c1.setClassAlias(G1 + C18);
                        break;
                    case 19:
                        c1.setClassName(C19);
                        c1.setClassAlias(G1 + C19);
                        break;
                    case 20:
                        c1.setClassName(C20);
                        c1.setClassAlias(G1 + C20);
                        break;
                    case 21:
                        c1.setClassName(C21);
                        c1.setClassAlias(G1 + C21);
                        break;
                    case 22:
                        c1.setClassName(C22);
                        c1.setClassAlias(G1 + C22);
                        break;
                    case 23:
                        c1.setClassName(C23);
                        c1.setClassAlias(G1 + C23);
                        break;
                    case 24:
                        c1.setClassName(C24);
                        c1.setClassAlias(G1 + C24);
                        break;
                    case 25:
                        c1.setClassName(C25);
                        c1.setClassAlias(G1 + C25);
                        break;
                    case 26:
                        c1.setClassName(C26);
                        c1.setClassAlias(G1 + C26);
                        break;
                    case 27:
                        c1.setClassName(C27);
                        c1.setClassAlias(G1 + C27);
                        break;
                    case 28:
                        c1.setClassName(C28);
                        c1.setClassAlias(G1 + C28);
                        break;
                    case 29:
                        c1.setClassName(C29);
                        c1.setClassAlias(G1 + C29);
                        break;
                    case 30:
                        c1.setClassName(C30);
                        c1.setClassAlias(G1 + C30);
                        break;
                    case 31:
                        c1.setClassName(C31);
                        c1.setClassAlias(G1 + C31);
                        break;
                    case 32:
                        c1.setClassName(C32);
                        c1.setClassAlias(G1 + C32);
                        break;
                    case 33:
                        c1.setClassName(C33);
                        c1.setClassAlias(G1 + C33);
                        break;
                    case 34:
                        c1.setClassName(C34);
                        c1.setClassAlias(G1 + C34);
                        break;
                    case 35:
                        c1.setClassName(C35);
                        c1.setClassAlias(G1 + C35);
                        break;
                    case 36:
                        c1.setClassName(C36);
                        c1.setClassAlias(G1 + C36);
                        break;
                    case 37:
                        c1.setClassName(C37);
                        c1.setClassAlias(G1 + C37);
                        break;
                    case 38:
                        c1.setClassName(C38);
                        c1.setClassAlias(G1 + C38);
                        break;
                    case 39:
                        c1.setClassName(C39);
                        c1.setClassAlias(G1 + C39);
                        break;
                    case 40:
                        c1.setClassName(C40);
                        c1.setClassAlias(G1 + C40);
                        break;
                    case 41:
                        c1.setClassName(C41);
                        c1.setClassAlias(G1 + C41);
                        break;
                    case 42:
                        c1.setClassName(C42);
                        c1.setClassAlias(G1 + C42);
                        break;
                    case 43:
                        c1.setClassName(C43);
                        c1.setClassAlias(G1 + C43);
                        break;
                    case 44:
                        c1.setClassName(C44);
                        c1.setClassAlias(G1 + C44);
                        break;
                    case 45:
                        c1.setClassName(C45);
                        c1.setClassAlias(G1 + C45);
                        break;
                    case 46:
                        c1.setClassName(C46);
                        c1.setClassAlias(G1 + C46);
                        break;
                    case 47:
                        c1.setClassName(C47);
                        c1.setClassAlias(G1 + C47);
                        break;
                    case 48:
                        c1.setClassName(C48);
                        c1.setClassAlias(G1 + C48);
                        break;
                    case 49:
                        c1.setClassName(C49);
                        c1.setClassAlias(G1 + C49);
                        break;
                    case 50:
                        c1.setClassName(C50);
                        c1.setClassAlias(G1 + C50);
                        break;
                    case 51:
                        c1.setClassName(C51);
                        c1.setClassAlias(G1 + C51);
                        break;
                    case 52:
                        c1.setClassName(C52);
                        c1.setClassAlias(G1 + C52);
                        break;
                    case 53:
                        c1.setClassName(C53);
                        c1.setClassAlias(G1 + C53);
                        break;
                    case 54:
                        c1.setClassName(C54);
                        c1.setClassAlias(G1 + C54);
                        break;
                    case 55:
                        c1.setClassName(C55);
                        c1.setClassAlias(G1 + C55);
                        break;
                    case 56:
                        c1.setClassName(C56);
                        c1.setClassAlias(G1 + C56);
                        break;
                    case 57:
                        c1.setClassName(C57);
                        c1.setClassAlias(G1 + C57);
                        break;
                    case 58:
                        c1.setClassName(C58);
                        c1.setClassAlias(G1 + C58);
                        break;
                    case 59:
                        c1.setClassName(C59);
                        c1.setClassAlias(G1 + C59);
                        break;
                    case 60:
                        c1.setClassName(C60);
                        c1.setClassAlias(G1 + C60);
                        break;
                    case 61:
                        c1.setClassName(C61);
                        c1.setClassAlias(G1 + C61);
                        break;
                    case 62:
                        c1.setClassName(C62);
                        c1.setClassAlias(G1 + C62);
                        break;
                    case 63:
                        c1.setClassName(C63);
                        c1.setClassAlias(G1 + C63);
                        break;
                    case 64:
                        c1.setClassName(C64);
                        c1.setClassAlias(G1 + C64);
                        break;
                    case 65:
                        c1.setClassName(C65);
                        c1.setClassAlias(G1 + C65);
                        break;
                    case 66:
                        c1.setClassName(C66);
                        c1.setClassAlias(G1 + C66);
                        break;
                    case 67:
                        c1.setClassName(C67);
                        c1.setClassAlias(G1 + C67);
                        break;
                    case 68:
                        c1.setClassName(C68);
                        c1.setClassAlias(G1 + C68);
                        break;
                    case 69:
                        c1.setClassName(C69);
                        c1.setClassAlias(G1 + C69);
                        break;
                    case 70:
                        c1.setClassName(C70);
                        c1.setClassAlias(G1 + C70);
                        break;
                    case 71:
                        c1.setClassName(C71);
                        c1.setClassAlias(G1 + C71);
                        break;
                    case 72:
                        c1.setClassName(C72);
                        c1.setClassAlias(G1 + C72);
                        break;
                    case 73:
                        c1.setClassName(C73);
                        c1.setClassAlias(G1 + C73);
                        break;
                    case 74:
                        c1.setClassName(C74);
                        c1.setClassAlias(G1 + C74);
                        break;
                    case 75:
                        c1.setClassName(C75);
                        c1.setClassAlias(G1 + C75);
                        break;
                    case 76:
                        c1.setClassName(C76);
                        c1.setClassAlias(G1 + C76);
                        break;
                    case 77:
                        c1.setClassName(C77);
                        c1.setClassAlias(G1 + C77);
                        break;
                    case 78:
                        c1.setClassName(C78);
                        c1.setClassAlias(G1 + C78);
                        break;
                    case 79:
                        c1.setClassName(C79);
                        c1.setClassAlias(G1 + C79);
                        break;
                    case 80:
                        c1.setClassName(C80);
                        c1.setClassAlias(G1 + C80);
                        break;
                    case 81:
                        c1.setClassName(C81);
                        c1.setClassAlias(G1 + C81);
                        break;
                    case 82:
                        c1.setClassName(C82);
                        c1.setClassAlias(G1 + C82);
                        break;
                    case 83:
                        c1.setClassName(C83);
                        c1.setClassAlias(G1 + C83);
                        break;
                    case 84:
                        c1.setClassName(C84);
                        c1.setClassAlias(G1 + C84);
                        break;
                    case 85:
                        c1.setClassName(C85);
                        c1.setClassAlias(G1 + C85);
                        break;
                    case 86:
                        c1.setClassName(C86);
                        c1.setClassAlias(G1 + C86);
                        break;
                    case 87:
                        c1.setClassName(C87);
                        c1.setClassAlias(G1 + C87);
                        break;
                    case 88:
                        c1.setClassName(C88);
                        c1.setClassAlias(G1 + C88);
                        break;
                    case 89:
                        c1.setClassName(C89);
                        c1.setClassAlias(G1 + C89);
                        break;
                    case 90:
                        c1.setClassName(C90);
                        c1.setClassAlias(G1 + C90);
                        break;
                    case 91:
                        c1.setClassName(C91);
                        c1.setClassAlias(G1 + C91);
                        break;
                    case 92:
                        c1.setClassName(C92);
                        c1.setClassAlias(G1 + C92);
                        break;
                    case 93:
                        c1.setClassName(C93);
                        c1.setClassAlias(G1 + C93);
                        break;
                    case 94:
                        c1.setClassName(C94);
                        c1.setClassAlias(G1 + C94);
                        break;
                    case 95:
                        c1.setClassName(C95);
                        c1.setClassAlias(G1 + C95);
                        break;
                    case 96:
                        c1.setClassName(C96);
                        c1.setClassAlias(G1 + C96);
                        break;
                    case 97:
                        c1.setClassName(C97);
                        c1.setClassAlias(G1 + C97);
                        break;
                    case 98:
                        c1.setClassName(C98);
                        c1.setClassAlias(G1 + C98);
                        break;
                    case 99:
                        c1.setClassName(C99);
                        c1.setClassAlias(G1 + C99);
                        break;
                    case 100:
                        c1.setClassName(C100);
                        c1.setClassAlias(G1 + C100);
                        break;
                }
                num += schoolClassMapper.insert(c1);
            }
        }

        //高二班级数量大于0才进行新增
        if (0 < num2) {
            //判断当前学年高二级部是否存在
            LambdaQueryWrapper<SchoolGrade> g2 = new LambdaQueryWrapper<>();
            g2.eq(SchoolGrade::getSchoolYear, vo.getSchoolYear())
                    .eq(SchoolGrade::getGradeValue, 2);
            List<SchoolGrade> gList2 = gradeMapper.selectList(g2);
            if (StringUtils.isNull(gList2) || gList2.size() == 0) {
                throw new ServiceException(vo.getSchoolYear() + "学年高二级部不存在，无法新增班级");
            }
            //存在年级
            SchoolGrade grade1 = gList2.get(0);
            String gradeName = GRADE2;
            for (int i = 1; i <= num2; i++) {
                SchoolClass c1 = new SchoolClass();
                c1.setSchoolYear(vo.getSchoolYear());
                //设置为高中
                c1.setClassType("4");
                //设置年级数值和名称
                c1.setGradeId(grade1.getId());
                c1.setGradeValue(grade1.getGradeValue());
                c1.setGradeName(gradeName);
                c1.setSfzxxn(grade1.getSfzxxn());

                //设置班级数值、班级名称、班级别名,目前只支持生成1-33个班级
                c1.setClassValue(i);
                switch (i) {
                    case 1:
                        c1.setClassName(C1);
                        c1.setClassAlias(G2 + C1);
                        break;
                    case 2:
                        c1.setClassName(C2);
                        c1.setClassAlias(G2 + C2);
                        break;
                    case 3:
                        c1.setClassName(C3);
                        c1.setClassAlias(G2 + C3);
                        break;
                    case 4:
                        c1.setClassName(C4);
                        c1.setClassAlias(G2 + C4);
                        break;
                    case 5:
                        c1.setClassName(C5);
                        c1.setClassAlias(G2 + C5);
                        break;
                    case 6:
                        c1.setClassName(C6);
                        c1.setClassAlias(G1 + C6);
                        break;
                    case 7:
                        c1.setClassName(C7);
                        c1.setClassAlias(G2 + C7);
                        break;
                    case 8:
                        c1.setClassName(C8);
                        c1.setClassAlias(G2 + C8);
                        break;
                    case 9:
                        c1.setClassName(C9);
                        c1.setClassAlias(G2 + C9);
                        break;
                    case 10:
                        c1.setClassName(C10);
                        c1.setClassAlias(G2 + C10);
                        break;
                    case 11:
                        c1.setClassName(C11);
                        c1.setClassAlias(G2 + C11);
                        break;
                    case 12:
                        c1.setClassName(C12);
                        c1.setClassAlias(G2 + C12);
                        break;
                    case 13:
                        c1.setClassName(C13);
                        c1.setClassAlias(G2 + C13);
                        break;
                    case 14:
                        c1.setClassName(C14);
                        c1.setClassAlias(G2 + C14);
                        break;
                    case 15:
                        c1.setClassName(C15);
                        c1.setClassAlias(G2 + C15);
                        break;
                    case 16:
                        c1.setClassName(C16);
                        c1.setClassAlias(G2 + C16);
                        break;
                    case 17:
                        c1.setClassName(C17);
                        c1.setClassAlias(G2 + C17);
                        break;
                    case 18:
                        c1.setClassName(C18);
                        c1.setClassAlias(G2 + C18);
                        break;
                    case 19:
                        c1.setClassName(C19);
                        c1.setClassAlias(G2 + C19);
                        break;
                    case 20:
                        c1.setClassName(C20);
                        c1.setClassAlias(G2 + C20);
                        break;
                    case 21:
                        c1.setClassName(C21);
                        c1.setClassAlias(G2 + C21);
                        break;
                    case 22:
                        c1.setClassName(C22);
                        c1.setClassAlias(G2 + C22);
                        break;
                    case 23:
                        c1.setClassName(C23);
                        c1.setClassAlias(G2 + C23);
                        break;
                    case 24:
                        c1.setClassName(C24);
                        c1.setClassAlias(G2 + C24);
                        break;
                    case 25:
                        c1.setClassName(C25);
                        c1.setClassAlias(G2 + C25);
                        break;
                    case 26:
                        c1.setClassName(C26);
                        c1.setClassAlias(G2 + C26);
                        break;
                    case 27:
                        c1.setClassName(C27);
                        c1.setClassAlias(G2 + C27);
                        break;
                    case 28:
                        c1.setClassName(C28);
                        c1.setClassAlias(G2 + C28);
                        break;
                    case 29:
                        c1.setClassName(C29);
                        c1.setClassAlias(G2 + C29);
                        break;
                    case 30:
                        c1.setClassName(C30);
                        c1.setClassAlias(G2 + C30);
                        break;
                    case 31:
                        c1.setClassName(C31);
                        c1.setClassAlias(G2 + C31);
                        break;
                    case 32:
                        c1.setClassName(C32);
                        c1.setClassAlias(G2 + C32);
                        break;
                    case 33:
                        c1.setClassName(C33);
                        c1.setClassAlias(G2 + C33);
                        break;
                    case 34:
                        c1.setClassName(C34);
                        c1.setClassAlias(G2 + C34);
                        break;
                    case 35:
                        c1.setClassName(C35);
                        c1.setClassAlias(G2 + C35);
                        break;
                    case 36:
                        c1.setClassName(C36);
                        c1.setClassAlias(G2 + C36);
                        break;
                    case 37:
                        c1.setClassName(C37);
                        c1.setClassAlias(G2 + C37);
                        break;
                    case 38:
                        c1.setClassName(C38);
                        c1.setClassAlias(G2 + C38);
                        break;
                    case 39:
                        c1.setClassName(C39);
                        c1.setClassAlias(G2 + C39);
                        break;
                    case 40:
                        c1.setClassName(C40);
                        c1.setClassAlias(G2 + C40);
                        break;
                    case 41:
                        c1.setClassName(C41);
                        c1.setClassAlias(G2 + C41);
                        break;
                    case 42:
                        c1.setClassName(C42);
                        c1.setClassAlias(G2 + C42);
                        break;
                    case 43:
                        c1.setClassName(C43);
                        c1.setClassAlias(G2 + C43);
                        break;
                    case 44:
                        c1.setClassName(C44);
                        c1.setClassAlias(G2 + C44);
                        break;
                    case 45:
                        c1.setClassName(C45);
                        c1.setClassAlias(G2 + C45);
                        break;
                    case 46:
                        c1.setClassName(C46);
                        c1.setClassAlias(G2 + C46);
                        break;
                    case 47:
                        c1.setClassName(C47);
                        c1.setClassAlias(G2 + C47);
                        break;
                    case 48:
                        c1.setClassName(C48);
                        c1.setClassAlias(G2 + C48);
                        break;
                    case 49:
                        c1.setClassName(C49);
                        c1.setClassAlias(G2 + C49);
                        break;
                    case 50:
                        c1.setClassName(C50);
                        c1.setClassAlias(G2 + C50);
                        break;
                    case 51:
                        c1.setClassName(C51);
                        c1.setClassAlias(G2 + C51);
                        break;
                    case 52:
                        c1.setClassName(C52);
                        c1.setClassAlias(G2 + C52);
                        break;
                    case 53:
                        c1.setClassName(C53);
                        c1.setClassAlias(G2 + C53);
                        break;
                    case 54:
                        c1.setClassName(C54);
                        c1.setClassAlias(G2 + C54);
                        break;
                    case 55:
                        c1.setClassName(C55);
                        c1.setClassAlias(G2 + C55);
                        break;
                    case 56:
                        c1.setClassName(C56);
                        c1.setClassAlias(G2 + C56);
                        break;
                    case 57:
                        c1.setClassName(C57);
                        c1.setClassAlias(G2 + C57);
                        break;
                    case 58:
                        c1.setClassName(C58);
                        c1.setClassAlias(G2 + C58);
                        break;
                    case 59:
                        c1.setClassName(C59);
                        c1.setClassAlias(G2 + C59);
                        break;
                    case 60:
                        c1.setClassName(C60);
                        c1.setClassAlias(G2 + C60);
                        break;
                    case 61:
                        c1.setClassName(C61);
                        c1.setClassAlias(G2 + C61);
                        break;
                    case 62:
                        c1.setClassName(C62);
                        c1.setClassAlias(G2 + C62);
                        break;
                    case 63:
                        c1.setClassName(C63);
                        c1.setClassAlias(G2 + C63);
                        break;
                    case 64:
                        c1.setClassName(C64);
                        c1.setClassAlias(G2 + C64);
                        break;
                    case 65:
                        c1.setClassName(C65);
                        c1.setClassAlias(G2 + C65);
                        break;
                    case 66:
                        c1.setClassName(C66);
                        c1.setClassAlias(G2 + C66);
                        break;
                    case 67:
                        c1.setClassName(C67);
                        c1.setClassAlias(G2 + C67);
                        break;
                    case 68:
                        c1.setClassName(C68);
                        c1.setClassAlias(G2 + C68);
                        break;
                    case 69:
                        c1.setClassName(C69);
                        c1.setClassAlias(G2 + C69);
                        break;
                    case 70:
                        c1.setClassName(C70);
                        c1.setClassAlias(G2 + C70);
                        break;
                    case 71:
                        c1.setClassName(C71);
                        c1.setClassAlias(G2 + C71);
                        break;
                    case 72:
                        c1.setClassName(C72);
                        c1.setClassAlias(G2 + C72);
                        break;
                    case 73:
                        c1.setClassName(C73);
                        c1.setClassAlias(G2 + C73);
                        break;
                    case 74:
                        c1.setClassName(C74);
                        c1.setClassAlias(G2 + C74);
                        break;
                    case 75:
                        c1.setClassName(C75);
                        c1.setClassAlias(G2 + C75);
                        break;
                    case 76:
                        c1.setClassName(C76);
                        c1.setClassAlias(G2 + C76);
                        break;
                    case 77:
                        c1.setClassName(C77);
                        c1.setClassAlias(G2 + C77);
                        break;
                    case 78:
                        c1.setClassName(C78);
                        c1.setClassAlias(G2 + C78);
                        break;
                    case 79:
                        c1.setClassName(C79);
                        c1.setClassAlias(G2 + C79);
                        break;
                    case 80:
                        c1.setClassName(C80);
                        c1.setClassAlias(G2 + C80);
                        break;
                    case 81:
                        c1.setClassName(C81);
                        c1.setClassAlias(G2 + C81);
                        break;
                    case 82:
                        c1.setClassName(C82);
                        c1.setClassAlias(G2 + C82);
                        break;
                    case 83:
                        c1.setClassName(C83);
                        c1.setClassAlias(G2 + C83);
                        break;
                    case 84:
                        c1.setClassName(C84);
                        c1.setClassAlias(G2 + C84);
                        break;
                    case 85:
                        c1.setClassName(C85);
                        c1.setClassAlias(G2 + C85);
                        break;
                    case 86:
                        c1.setClassName(C86);
                        c1.setClassAlias(G2 + C86);
                        break;
                    case 87:
                        c1.setClassName(C87);
                        c1.setClassAlias(G2 + C87);
                        break;
                    case 88:
                        c1.setClassName(C88);
                        c1.setClassAlias(G2 + C88);
                        break;
                    case 89:
                        c1.setClassName(C89);
                        c1.setClassAlias(G2 + C89);
                        break;
                    case 90:
                        c1.setClassName(C90);
                        c1.setClassAlias(G2 + C90);
                        break;
                    case 91:
                        c1.setClassName(C91);
                        c1.setClassAlias(G2 + C91);
                        break;
                    case 92:
                        c1.setClassName(C92);
                        c1.setClassAlias(G2 + C92);
                        break;
                    case 93:
                        c1.setClassName(C93);
                        c1.setClassAlias(G2 + C93);
                        break;
                    case 94:
                        c1.setClassName(C94);
                        c1.setClassAlias(G2 + C94);
                        break;
                    case 95:
                        c1.setClassName(C95);
                        c1.setClassAlias(G2 + C95);
                        break;
                    case 96:
                        c1.setClassName(C96);
                        c1.setClassAlias(G2 + C96);
                        break;
                    case 97:
                        c1.setClassName(C97);
                        c1.setClassAlias(G2 + C97);
                        break;
                    case 98:
                        c1.setClassName(C98);
                        c1.setClassAlias(G2 + C98);
                        break;
                    case 99:
                        c1.setClassName(C99);
                        c1.setClassAlias(G2 + C99);
                        break;
                    case 100:
                        c1.setClassName(C100);
                        c1.setClassAlias(G2 + C100);
                        break;
                }
                num += schoolClassMapper.insert(c1);
            }
        }

        //高三班级数量大于0才进行新增
        if (0 < num3) {
            //判断当前学年高三级部是否存在
            LambdaQueryWrapper<SchoolGrade> g1 = new LambdaQueryWrapper<>();
            g1.eq(SchoolGrade::getSchoolYear, vo.getSchoolYear())
                    .eq(SchoolGrade::getGradeValue, 3);
            List<SchoolGrade> gList1 = gradeMapper.selectList(g1);
            if (StringUtils.isNull(gList1) || gList1.size() == 0) {
                throw new ServiceException(vo.getSchoolYear() + "学年高三级部不存在，无法新增班级");
            }
            //存在年级
            SchoolGrade grade1 = gList1.get(0);
            String gradeName = GRADE3;
            for (int i = 1; i <= num3; i++) {
                SchoolClass c1 = new SchoolClass();
                c1.setSchoolYear(vo.getSchoolYear());
                //设置为高中
                c1.setClassType("4");
                //设置年级数值和名称
                c1.setGradeId(grade1.getId());
                c1.setGradeValue(grade1.getGradeValue());
                c1.setGradeName(gradeName);
                c1.setSfzxxn(grade1.getSfzxxn());

                //设置班级数值、班级名称、班级别名,目前只支持生成1-33个班级
                c1.setClassValue(i);
                switch (i) {
                    case 1:
                        c1.setClassName(C1);
                        c1.setClassAlias(G3 + C1);
                        break;
                    case 2:
                        c1.setClassName(C2);
                        c1.setClassAlias(G3 + C2);
                        break;
                    case 3:
                        c1.setClassName(C3);
                        c1.setClassAlias(G3 + C3);
                        break;
                    case 4:
                        c1.setClassName(C4);
                        c1.setClassAlias(G3 + C4);
                        break;
                    case 5:
                        c1.setClassName(C5);
                        c1.setClassAlias(G3 + C5);
                        break;
                    case 6:
                        c1.setClassName(C6);
                        c1.setClassAlias(G3 + C6);
                        break;
                    case 7:
                        c1.setClassName(C7);
                        c1.setClassAlias(G3 + C7);
                        break;
                    case 8:
                        c1.setClassName(C8);
                        c1.setClassAlias(G3 + C8);
                        break;
                    case 9:
                        c1.setClassName(C9);
                        c1.setClassAlias(G3 + C9);
                        break;
                    case 10:
                        c1.setClassName(C10);
                        c1.setClassAlias(G3 + C10);
                        break;
                    case 11:
                        c1.setClassName(C11);
                        c1.setClassAlias(G3 + C11);
                        break;
                    case 12:
                        c1.setClassName(C12);
                        c1.setClassAlias(G3 + C12);
                        break;
                    case 13:
                        c1.setClassName(C13);
                        c1.setClassAlias(G3 + C13);
                        break;
                    case 14:
                        c1.setClassName(C14);
                        c1.setClassAlias(G3 + C14);
                        break;
                    case 15:
                        c1.setClassName(C15);
                        c1.setClassAlias(G3 + C15);
                        break;
                    case 16:
                        c1.setClassName(C16);
                        c1.setClassAlias(G3 + C16);
                        break;
                    case 17:
                        c1.setClassName(C17);
                        c1.setClassAlias(G3 + C17);
                        break;
                    case 18:
                        c1.setClassName(C18);
                        c1.setClassAlias(G3 + C18);
                        break;
                    case 19:
                        c1.setClassName(C19);
                        c1.setClassAlias(G3 + C19);
                        break;
                    case 20:
                        c1.setClassName(C20);
                        c1.setClassAlias(G3 + C20);
                        break;
                    case 21:
                        c1.setClassName(C21);
                        c1.setClassAlias(G3 + C21);
                        break;
                    case 22:
                        c1.setClassName(C22);
                        c1.setClassAlias(G3 + C22);
                        break;
                    case 23:
                        c1.setClassName(C23);
                        c1.setClassAlias(G3 + C23);
                        break;
                    case 24:
                        c1.setClassName(C24);
                        c1.setClassAlias(G3 + C24);
                        break;
                    case 25:
                        c1.setClassName(C25);
                        c1.setClassAlias(G3 + C25);
                        break;
                    case 26:
                        c1.setClassName(C26);
                        c1.setClassAlias(G3 + C26);
                        break;
                    case 27:
                        c1.setClassName(C27);
                        c1.setClassAlias(G3 + C27);
                        break;
                    case 28:
                        c1.setClassName(C28);
                        c1.setClassAlias(G3 + C28);
                        break;
                    case 29:
                        c1.setClassName(C29);
                        c1.setClassAlias(G3 + C29);
                        break;
                    case 30:
                        c1.setClassName(C30);
                        c1.setClassAlias(G3 + C30);
                        break;
                    case 31:
                        c1.setClassName(C31);
                        c1.setClassAlias(G3 + C31);
                        break;
                    case 32:
                        c1.setClassName(C32);
                        c1.setClassAlias(G3 + C32);
                        break;
                    case 33:
                        c1.setClassName(C33);
                        c1.setClassAlias(G3 + C33);
                        break;
                    case 34:
                        c1.setClassName(C34);
                        c1.setClassAlias(G3 + C34);
                        break;
                    case 35:
                        c1.setClassName(C35);
                        c1.setClassAlias(G3 + C35);
                        break;
                    case 36:
                        c1.setClassName(C36);
                        c1.setClassAlias(G3 + C36);
                        break;
                    case 37:
                        c1.setClassName(C37);
                        c1.setClassAlias(G3 + C37);
                        break;
                    case 38:
                        c1.setClassName(C38);
                        c1.setClassAlias(G3 + C38);
                        break;
                    case 39:
                        c1.setClassName(C39);
                        c1.setClassAlias(G3 + C39);
                        break;
                    case 40:
                        c1.setClassName(C40);
                        c1.setClassAlias(G3 + C40);
                        break;
                    case 41:
                        c1.setClassName(C41);
                        c1.setClassAlias(G3 + C41);
                        break;
                    case 42:
                        c1.setClassName(C42);
                        c1.setClassAlias(G3 + C42);
                        break;
                    case 43:
                        c1.setClassName(C43);
                        c1.setClassAlias(G3 + C43);
                        break;
                    case 44:
                        c1.setClassName(C44);
                        c1.setClassAlias(G3 + C44);
                        break;
                    case 45:
                        c1.setClassName(C45);
                        c1.setClassAlias(G3 + C45);
                        break;
                    case 46:
                        c1.setClassName(C46);
                        c1.setClassAlias(G3 + C46);
                        break;
                    case 47:
                        c1.setClassName(C47);
                        c1.setClassAlias(G3 + C47);
                        break;
                    case 48:
                        c1.setClassName(C48);
                        c1.setClassAlias(G3 + C48);
                        break;
                    case 49:
                        c1.setClassName(C49);
                        c1.setClassAlias(G3 + C49);
                        break;
                    case 50:
                        c1.setClassName(C50);
                        c1.setClassAlias(G3 + C50);
                        break;
                    case 51:
                        c1.setClassName(C51);
                        c1.setClassAlias(G3 + C51);
                        break;
                    case 52:
                        c1.setClassName(C52);
                        c1.setClassAlias(G3 + C52);
                        break;
                    case 53:
                        c1.setClassName(C53);
                        c1.setClassAlias(G3 + C53);
                        break;
                    case 54:
                        c1.setClassName(C54);
                        c1.setClassAlias(G3 + C54);
                        break;
                    case 55:
                        c1.setClassName(C55);
                        c1.setClassAlias(G3 + C55);
                        break;
                    case 56:
                        c1.setClassName(C56);
                        c1.setClassAlias(G3 + C56);
                        break;
                    case 57:
                        c1.setClassName(C57);
                        c1.setClassAlias(G3 + C57);
                        break;
                    case 58:
                        c1.setClassName(C58);
                        c1.setClassAlias(G3 + C58);
                        break;
                    case 59:
                        c1.setClassName(C59);
                        c1.setClassAlias(G3 + C59);
                        break;
                    case 60:
                        c1.setClassName(C60);
                        c1.setClassAlias(G3 + C60);
                        break;
                    case 61:
                        c1.setClassName(C61);
                        c1.setClassAlias(G3 + C61);
                        break;
                    case 62:
                        c1.setClassName(C62);
                        c1.setClassAlias(G3 + C62);
                        break;
                    case 63:
                        c1.setClassName(C63);
                        c1.setClassAlias(G3 + C63);
                        break;
                    case 64:
                        c1.setClassName(C64);
                        c1.setClassAlias(G3 + C64);
                        break;
                    case 65:
                        c1.setClassName(C65);
                        c1.setClassAlias(G3 + C65);
                        break;
                    case 66:
                        c1.setClassName(C66);
                        c1.setClassAlias(G3 + C66);
                        break;
                    case 67:
                        c1.setClassName(C67);
                        c1.setClassAlias(G3 + C67);
                        break;
                    case 68:
                        c1.setClassName(C68);
                        c1.setClassAlias(G3 + C68);
                        break;
                    case 69:
                        c1.setClassName(C69);
                        c1.setClassAlias(G3 + C69);
                        break;
                    case 70:
                        c1.setClassName(C70);
                        c1.setClassAlias(G3 + C70);
                        break;
                    case 71:
                        c1.setClassName(C71);
                        c1.setClassAlias(G3 + C71);
                        break;
                    case 72:
                        c1.setClassName(C72);
                        c1.setClassAlias(G3 + C72);
                        break;
                    case 73:
                        c1.setClassName(C73);
                        c1.setClassAlias(G3 + C73);
                        break;
                    case 74:
                        c1.setClassName(C74);
                        c1.setClassAlias(G3 + C74);
                        break;
                    case 75:
                        c1.setClassName(C75);
                        c1.setClassAlias(G3 + C75);
                        break;
                    case 76:
                        c1.setClassName(C76);
                        c1.setClassAlias(G3 + C76);
                        break;
                    case 77:
                        c1.setClassName(C77);
                        c1.setClassAlias(G3 + C77);
                        break;
                    case 78:
                        c1.setClassName(C78);
                        c1.setClassAlias(G3 + C78);
                        break;
                    case 79:
                        c1.setClassName(C79);
                        c1.setClassAlias(G3 + C79);
                        break;
                    case 80:
                        c1.setClassName(C80);
                        c1.setClassAlias(G3 + C80);
                        break;
                    case 81:
                        c1.setClassName(C81);
                        c1.setClassAlias(G3 + C81);
                        break;
                    case 82:
                        c1.setClassName(C82);
                        c1.setClassAlias(G3 + C82);
                        break;
                    case 83:
                        c1.setClassName(C83);
                        c1.setClassAlias(G3 + C83);
                        break;
                    case 84:
                        c1.setClassName(C84);
                        c1.setClassAlias(G3 + C84);
                        break;
                    case 85:
                        c1.setClassName(C85);
                        c1.setClassAlias(G3 + C85);
                        break;
                    case 86:
                        c1.setClassName(C86);
                        c1.setClassAlias(G3 + C86);
                        break;
                    case 87:
                        c1.setClassName(C87);
                        c1.setClassAlias(G3 + C87);
                        break;
                    case 88:
                        c1.setClassName(C88);
                        c1.setClassAlias(G3 + C88);
                        break;
                    case 89:
                        c1.setClassName(C89);
                        c1.setClassAlias(G3 + C89);
                        break;
                    case 90:
                        c1.setClassName(C90);
                        c1.setClassAlias(G3 + C90);
                        break;
                    case 91:
                        c1.setClassName(C91);
                        c1.setClassAlias(G3 + C91);
                        break;
                    case 92:
                        c1.setClassName(C92);
                        c1.setClassAlias(G3 + C92);
                        break;
                    case 93:
                        c1.setClassName(C93);
                        c1.setClassAlias(G3 + C93);
                        break;
                    case 94:
                        c1.setClassName(C94);
                        c1.setClassAlias(G3 + C94);
                        break;
                    case 95:
                        c1.setClassName(C95);
                        c1.setClassAlias(G3 + C95);
                        break;
                    case 96:
                        c1.setClassName(C96);
                        c1.setClassAlias(G3 + C96);
                        break;
                    case 97:
                        c1.setClassName(C97);
                        c1.setClassAlias(G3 + C97);
                        break;
                    case 98:
                        c1.setClassName(C98);
                        c1.setClassAlias(G3 + C98);
                        break;
                    case 99:
                        c1.setClassName(C99);
                        c1.setClassAlias(G3 + C99);
                        break;
                    case 100:
                        c1.setClassName(C100);
                        c1.setClassAlias(G3 + C100);
                        break;
                }
                num += schoolClassMapper.insert(c1);
            }
        }
        if(num != (num1+num2+num3)){
            throw new ServiceException("批量新增失败");
        }else{
            return num;
        }

    }


    @Override
    public Long selectDdClassId(String ddId) {
        return schoolClassMapper.selectDdClassId(ddId);
    }
}
