package yangtz.cs.liu.campus.service.impl.schoolClass;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import yangtz.cs.liu.campus.domain.schoolClass.SchoolClassEducational;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassEducationalMapper;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassEducationalService;

/**
 * 学校班级Service业务层处理
 *
 * @author hxz
 * @date 2023-02-26
 */
@Service
public class SchoolClassEducationalServiceImpl extends ServiceImpl<SchoolClassEducationalMapper,SchoolClassEducational> implements ISchoolClassEducationalService
{
    @Autowired
    private SchoolClassEducationalMapper schoolClassEducationalMapper;

    /**
     * 查询学校班级
     *
     * @param id 学校班级主键
     * @return 学校班级
     */
    @Override
    public SchoolClassEducational selectSchoolClassEducationalById(Long id)
    {
        return schoolClassEducationalMapper.selectSchoolClassEducationalById(id);
    }

    /**
     * 查询学校班级列表
     *
     * @param schoolClassEducational 学校班级
     * @return 学校班级
     */
    @Override
    public List<SchoolClassEducational> selectSchoolClassEducationalList(SchoolClassEducational schoolClassEducational)
    {
        return schoolClassEducationalMapper.selectSchoolClassEducationalList(schoolClassEducational);
    }

    /**
     * 新增学校班级
     *
     * @param schoolClassEducational 学校班级
     * @return 结果
     */
    @Override
    public int insertSchoolClassEducational(SchoolClassEducational schoolClassEducational)
    {
        schoolClassEducational.setCreateTime(DateUtils.getNowDate());
        return schoolClassEducationalMapper.insertSchoolClassEducational(schoolClassEducational);
    }

    /**
     * 修改学校班级
     *
     * @param schoolClassEducational 学校班级
     * @return 结果
     */
    @Override
    public int updateSchoolClassEducational(SchoolClassEducational schoolClassEducational)
    {
        schoolClassEducational.setUpdateTime(DateUtils.getNowDate());
        return schoolClassEducationalMapper.updateSchoolClassEducational(schoolClassEducational);
    }

    /**
     * 批量删除学校班级
     *
     * @param ids 需要删除的学校班级主键
     * @return 结果
     */
    @Override
    public int deleteSchoolClassEducationalByIds(Long[] ids)
    {
        return schoolClassEducationalMapper.deleteSchoolClassEducationalByIds(ids);
    }

    /**
     * 删除学校班级信息
     *
     * @param id 学校班级主键
     * @return 结果
     */
    @Override
    public int deleteSchoolClassEducationalById(Long id)
    {
        return schoolClassEducationalMapper.deleteSchoolClassEducationalById(id);
    }
}
