package yangtz.cs.liu.campus.service.impl.schoolAssets;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolAssets.SchoolAssets;
import yangtz.cs.liu.campus.mapper.schoolAssets.SchoolAssetsMapper;
import yangtz.cs.liu.campus.service.schoolAssets.ISchoolAssetsService;
import yangtz.cs.liu.campus.vo.schoolAssets.AssetsVo;

import java.util.List;

/**
 * 物品登记Service业务层处理
 *
 * @author ruoyi
 * @date 2023-01-07
 */
@Service
public class SchoolAssetsServiceImpl extends ServiceImpl<SchoolAssetsMapper, SchoolAssets> implements ISchoolAssetsService
{
    @Autowired
    private SchoolAssetsMapper schoolAssetsMapper;

    @Override
    public Boolean addAssets(Long id, Integer number) {
        return schoolAssetsMapper.addAssets(id,number);
    }

    @Override
    public Boolean reduceAssets(Long id, Integer number) {
        //判断出库数是否小于库存数
        SchoolAssets assets = schoolAssetsMapper.selectById(id);
        if(assets.getAssetsNumbers() < number){
            throw new ServiceException("当前库存数量不足，无法出库");
        }
        return schoolAssetsMapper.reduceAssets(id,number);
    }

    @Override
    public Boolean updateInAssets(Long id, Integer oldNum, Integer newNum) {
        return schoolAssetsMapper.updateInAssets(id,oldNum,newNum);
    }

    @Override
    public Boolean updateOutAssets(Long id, Integer oldNum, Integer newNum) {
        //判断出库数是否小于库存数
        SchoolAssets assets = schoolAssetsMapper.selectById(id);
        if((assets.getAssetsNumbers() + oldNum) < newNum){
            throw new ServiceException("当前库存数量不足，无法出库");
        }
        return schoolAssetsMapper.updateOutAssets(id,oldNum,newNum);
    }

    @Override
    public List<AssetsVo> queryList(SchoolAssets schoolAssets) {
        return schoolAssetsMapper.queryList(schoolAssets);
    }

//    @Override
//    public List<SchoolAssets> queryAssetList() {
//        return schoolAssetsMapper.queryAssetList();
//    }

//    @Override
//    public List<SchoolAssets> queryList(SchoolAssets schoolAssets) {
//        LambdaQueryWrapper<SchoolAssets> lqw = new LambdaQueryWrapper<>();
//        lqw
//                .like(isNotBlank(schoolResources.getName()), SchoolResources::getName, schoolResources.getName())
//                .orderByDesc(SchoolResources::getCreateTime)
//        ;
//        List<SchoolResources> list = schoolResourcesMapper.selectList(lqw);
//        return list;
//    }

//    /**
//     * 查询物品登记
//     *
//     * @param id 物品登记主键
//     * @return 物品登记
//     */
//    @Override
//    public SchoolAssets selectSchoolAssetsById(Long id)
//    {
//        return schoolAssetsMapper.selectSchoolAssetsById(id);
//    }
//
//    /**
//     * 查询物品登记列表
//     *
//     * @param schoolAssets 物品登记
//     * @return 物品登记
//     */
//    @Override
//    public List<SchoolAssets> selectSchoolAssetsList(SchoolAssets schoolAssets)
//    {
//        return schoolAssetsMapper.selectSchoolAssetsList(schoolAssets);
//    }
//
//    /**
//     * 新增物品登记
//     *
//     * @param schoolAssets 物品登记
//     * @return 结果
//     */
//    @Override
//    public int insertSchoolAssets(SchoolAssets schoolAssets)
//    {
//        schoolAssets.setCreateTime(DateUtils.getNowDate());
//        return schoolAssetsMapper.insertSchoolAssets(schoolAssets);
//    }
//
//    /**
//     * 修改物品登记
//     *
//     * @param schoolAssets 物品登记
//     * @return 结果
//     */
//    @Override
//    public int updateSchoolAssets(SchoolAssets schoolAssets)
//    {
//        schoolAssets.setUpdateTime(DateUtils.getNowDate());
//        return schoolAssetsMapper.updateSchoolAssets(schoolAssets);
//    }
//
//    /**
//     * 批量删除物品登记
//     *
//     * @param ids 需要删除的物品登记主键
//     * @return 结果
//     */
//    @Override
//    public int deleteSchoolAssetsByIds(Long[] ids)
//    {
//        return schoolAssetsMapper.deleteSchoolAssetsByIds(ids);
//    }
//
//    /**
//     * 删除物品登记信息
//     *
//     * @param id 物品登记主键
//     * @return 结果
//     */
//    @Override
//    public int deleteSchoolAssetsById(Long id)
//    {
//        return schoolAssetsMapper.deleteSchoolAssetsById(id);
//    }
}
