package yangtz.cs.liu.campus.service.impl.resources;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.resources.SchoolResources;
import yangtz.cs.liu.campus.domain.resources.SchoolResourcesDetails;
import yangtz.cs.liu.campus.mapper.resources.SchoolResourcesDetailsMapper;
import yangtz.cs.liu.campus.mapper.resources.SchoolResourcesMapper;
import yangtz.cs.liu.campus.service.resources.ISchoolResourcesService;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

@Service
public class SchoolResourcesServiceImpl extends ServiceImpl<SchoolResourcesMapper, SchoolResources> implements ISchoolResourcesService {
    @Autowired
    SchoolResourcesMapper schoolResourcesMapper;
    @Autowired
    SchoolResourcesDetailsMapper schoolResourcesDetailsMapper;

    @Override
    public List<SchoolResources> queryList(SchoolResources schoolResources) {
        LambdaQueryWrapper<SchoolResources> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotBlank(schoolResources.getName()), SchoolResources::getName, schoolResources.getName())
                .orderByDesc(SchoolResources::getCreateTime)
        ;
        List<SchoolResources> list = schoolResourcesMapper.selectList(lqw);
        return list;
    }
}
