package yangtz.cs.liu.campus.service.impl.patrol;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolDetails;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolRuleDetails;
import yangtz.cs.liu.campus.mapper.patrol.SchoolPatrolDetailsMapper;
import yangtz.cs.liu.campus.mapper.patrol.SchoolPatrolMapper;
import yangtz.cs.liu.campus.mapper.patrol.SchoolPatrolRuleDetailsMapper;
import yangtz.cs.liu.campus.service.patrol.ISchoolPatrolDetailsService;

import java.util.List;
import java.util.Map;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNull;
import static com.ruoyi.common.utils.StringUtils.isNotNull;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * 课堂巡视得分细节业务层
 */
@Service
public class SchoolPatrolDetailsServiceImpl extends ServiceImpl<SchoolPatrolDetailsMapper, SchoolPatrolDetails> implements ISchoolPatrolDetailsService {


    @Autowired
    private SchoolPatrolDetailsMapper schoolPatrolDetailsMapper;

    @Autowired
    private SchoolPatrolMapper schoolPatrolMapper;

    @Autowired
    private SchoolPatrolRuleDetailsMapper schoolPatrolRuleDetailsMapper;

    /**
     * 查询课堂巡视得分细节列表
     *
     * @param schoolPatrolDetails
     * @return
     */
    @Override
    public List<SchoolPatrolDetails> queryList(SchoolPatrolDetails schoolPatrolDetails) {
        LambdaQueryWrapper<SchoolPatrolDetails> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotNull(schoolPatrolDetails.getPatrolId()), SchoolPatrolDetails::getPatrolId, schoolPatrolDetails.getPatrolId())
                .like(isNotBlank(schoolPatrolDetails.getContent()), SchoolPatrolDetails::getContent, schoolPatrolDetails.getContent())
                .eq(isNotNull(schoolPatrolDetails.getScore()), SchoolPatrolDetails::getScore, schoolPatrolDetails.getScore())
                .eq(isNotNull(schoolPatrolDetails.getIsUsed()), SchoolPatrolDetails::getIsUsed, schoolPatrolDetails.getIsUsed())
                .orderByDesc(SchoolPatrolDetails::getCreateTime)
        ;
        return schoolPatrolDetailsMapper.selectList(lqw);
    }

    @Override
    public int updateSchoolPatrolDetailsByIds(Long[] ids, Long patrolId, Long score) {
        schoolPatrolDetailsMapper.updateSchoolPatrolDetailsByIds(ids, patrolId);
        return schoolPatrolMapper.updateScore(score, patrolId);
    }


    /**
     * 新增（课堂巡检打分规则明细到课堂巡视打分表）
     *
     * @param ruleId
     * @return
     */
    @Override
    public int addRuleDetails(Long ruleId, Long patrolId) {
        List<SchoolPatrolDetails> schoolPatrolRuleDetailsList = schoolPatrolRuleDetailsMapper.selectByRuleId(ruleId);
        if (isNull(schoolPatrolRuleDetailsList)){
            throw new ServiceException("该规则下无评分明细");
        }
        for (SchoolPatrolDetails schoolPatrolDetails : schoolPatrolRuleDetailsList) {
            Long detailsId = schoolPatrolDetails.getId();
            schoolPatrolDetails.setPatrolId(patrolId);
            schoolPatrolDetails.setDetailsId(detailsId);
        }
        return schoolPatrolDetailsMapper.insertBatchs(schoolPatrolRuleDetailsList);
    }
}
