package yangtz.cs.liu.campus.service.impl.menuFunction;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysMenu;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysMenuMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import yangtz.cs.liu.campus.domain.menuFunction.MenuFunction;
import yangtz.cs.liu.campus.mapper.menuFunction.MenuFunctionMapper;
import yangtz.cs.liu.campus.service.menuFunction.IMenuFunctionService;
import yangtz.cs.liu.campus.vo.menuFunction.MenuFunctionVO;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import static com.ruoyi.common.utils.SecurityUtils.getUserId;


@Service
public class MenuFunctionImpl extends ServiceImpl<MenuFunctionMapper, MenuFunction> implements IMenuFunctionService {

    @Autowired
    private MenuFunctionMapper menuFunctionMapper;

    @Autowired
    private SysMenuMapper menuMapper;

    //查询用户选择展示到首页的菜单
    @Override
    public List<MenuFunctionVO> queryList() {
        Long userId = getUserId();
        LambdaQueryWrapper<MenuFunction> lqw = new LambdaQueryWrapper<>();
        lqw.eq(MenuFunction::getUserId,userId);
        List<MenuFunction> menuFunctionList = menuFunctionMapper.selectList(lqw);
        if (menuFunctionList != null && menuFunctionList.size() > 0) {
            List<Long> ids = menuFunctionList.stream().map(m -> m.getId()).collect(Collectors.toList());
            List<SysMenu> menuList = menuMapper.getMenuByIds(ids);
            List<MenuFunctionVO> list = new ArrayList<>();
            for(SysMenu sysMenu : menuList){
                MenuFunctionVO menu = new MenuFunctionVO();
                BeanUtils.copyProperties(sysMenu, menu);
                menu.setId(sysMenu.getMenuId());
                menu.setMenuPic(sysMenu.getIcon());

                //拼接路径
                String path = "";
                //获取其所有父节点
                List<SysMenu> pidList = menuMapper.getParentIds(menu.getId());
                if(StringUtils.isNull(pidList)){
                    path += sysMenu.getPath();
                    menu.setPath(path);
                    list.add(menu);
                }
                Collections.reverse(pidList);
                for(SysMenu m : pidList){
                    path += m.getPath() +"/";
                }
                path += sysMenu.getPath();
                menu.setPath(path);
                list.add(menu);
            }
            return list;
        }
        return new ArrayList<>();
    }

    @Override
    public List<MenuFunction> getMenuByUserId(Long userId) {
        LambdaQueryWrapper<MenuFunction> lqw = new LambdaQueryWrapper<>();
        lqw.eq(MenuFunction::getUserId,userId);
        List<MenuFunction> menuFunctionList = menuFunctionMapper.selectList(lqw);
        if (CollectionUtils.isEmpty(menuFunctionList)) {
            return new ArrayList<>();
        }
        return menuFunctionList;
    }


    @Override
    public int insertMenuFunction(Long userId, List<SysMenu> menus) {
        menuFunctionMapper.deleteByUserId(userId);
        if(0 == menus.size()){
            return 1;
        }
        List<MenuFunction> list = new ArrayList<>();
        for (SysMenu menu : menus) {
            MenuFunction menuFunction = new MenuFunction();
            menuFunction.setId(menu.getMenuId());
            menuFunction.setMenuName(menu.getMenuName());
            menuFunction.setMenuPic(menu.getIcon());
            menuFunction.setUserId(userId);
            list.add(menuFunction);
        }
        return menuFunctionMapper.insertMenuFunction(list);
    }


}
