package yangtz.cs.liu.campus.service.impl.material;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.mapper.accessory.AccessoryMapper;
import yangtz.cs.liu.campus.mapper.material.MaterialMapper;
import yangtz.cs.liu.campus.domain.material.Material;
import yangtz.cs.liu.campus.service.material.IMaterialService;

/**
 * 材料编写情况Service业务层处理
 *
 * @author ruoyi
 * @date 2023-07-25
 */
@Service
public class MaterialServiceImpl implements IMaterialService
{
    @Autowired
    private MaterialMapper materialMapper;
    @Autowired
    private AccessoryMapper accessoryMapper;

    /**
     * 查询课题、结题、专著、校本教材编写情况
     *
     * @param id 课题、结题、专著、校本教材编写情况主键
     * @return 课题、结题、专著、校本教材编写情况
     */
    @Override
    public Material selectMaterialById(Long id)
    {
        Material material = materialMapper.selectMaterialById(id);
        LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolAccessory::getBusinessId,material.getId())
                .eq(SchoolAccessory::getAccessoryType,"材料编写附件");
        List<SchoolAccessory> accessories = accessoryMapper.selectList(wrapper);
        if (StringUtils.isNotNull(accessories) && accessories.size() > 0){
            material.setSchoolAccessoryList(accessories);
        }
        return material;
    }

    /**
     * 查询课题、结题、专著、校本教材编写情况列表
     *
     * @param material 课题、结题、专著、校本教材编写情况
     * @return 课题、结题、专著、校本教材编写情况
     */
    @Override
    public List<Material> selectMaterialList(Material material)
    {
        material.setTeacherId(SecurityUtils.getLoginUser().getUser().getUserId());
        List<Material> list = materialMapper.selectMaterialList(material);
        list.forEach(material1 -> {
            LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolAccessory::getBusinessId,material1.getId())
                    .eq(SchoolAccessory::getAccessoryType,"材料编写附件");
            List<SchoolAccessory> accessories = accessoryMapper.selectList(wrapper);
            if (StringUtils.isNotNull(accessories) && accessories.size() > 0){
                material1.setSchoolAccessoryList(accessories);
            }
        });
        return list;
    }

    /**
     * 新增课题、结题、专著、校本教材编写情况
     *
     * @param material 课题、结题、专著、校本教材编写情况
     * @return 结果
     */
    @Transactional
    @Override
    public int insertMaterial(Material material)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        material.setTeacherId(user.getUserId());
        material.setTeacherName(user.getUserName());
        material.setCreateBy(user.getUserName());
        material.setCreateTime(DateUtils.getNowDate());
        int rows = materialMapper.insertMaterial(material);
        insertSchoolAccessory(material);
        return rows;
    }

    /**
     * 修改课题、结题、专著、校本教材编写情况
     *
     * @param material 课题、结题、专著、校本教材编写情况
     * @return 结果
     */
    @Transactional
    @Override
    public int updateMaterial(Material material)
    {
        material.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        material.setUpdateTime(DateUtils.getNowDate());
        materialMapper.deleteSchoolAccessoryByBusinessId(material.getId());
        insertSchoolAccessory(material);
        return materialMapper.updateMaterial(material);
    }

    /**
     * 批量删除课题、结题、专著、校本教材编写情况
     *
     * @param ids 需要删除的课题、结题、专著、校本教材编写情况主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteMaterialByIds(Long[] ids)
    {
        materialMapper.deleteSchoolAccessoryByBusinessIds(ids);
        return materialMapper.deleteMaterialByIds(ids);
    }

    /**
     * 删除课题、结题、专著、校本教材编写情况信息
     *
     * @param id 课题、结题、专著、校本教材编写情况主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteMaterialById(Long id)
    {
        materialMapper.deleteSchoolAccessoryByBusinessId(id);
        return materialMapper.deleteMaterialById(id);
    }

    /**
     * 新增附件信息信息
     *
     * @param material 课题、结题、专著、校本教材编写情况对象
     */
    public void insertSchoolAccessory(Material material)
    {
        List<SchoolAccessory> schoolAccessoryList = material.getSchoolAccessoryList();
        Long id = material.getId();
        if (StringUtils.isNotNull(schoolAccessoryList))
        {
            List<SchoolAccessory> list = new ArrayList<SchoolAccessory>();
            for (SchoolAccessory schoolAccessory : schoolAccessoryList)
            {
                schoolAccessory.setModuleName("个人工作-材料编写情况");
                schoolAccessory.setAccessoryType("材料编写附件");
                schoolAccessory.setBusinessId(id);
                list.add(schoolAccessory);
            }
            if (list.size() > 0)
            {
                materialMapper.batchSchoolAccessory(list);
            }
        }
    }
}
