package yangtz.cs.liu.campus.service.impl.exam;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.exam.ExamMain;
import yangtz.cs.liu.campus.domain.exam.ExamUserScore;
import yangtz.cs.liu.campus.mapper.exam.ExamUserScoreMapper;
import yangtz.cs.liu.campus.service.exam.IExamUserScoreService;
import yangtz.cs.liu.campus.vo.exam.ExamUserScoreVo;
import yangtz.cs.liu.campus.vo.exam.ExamUserVo;

import java.util.ArrayList;
import java.util.List;

@Service
public class ExamUserScoreServiceImpl extends ServiceImpl<ExamUserScoreMapper, ExamUserScore> implements IExamUserScoreService {

    @Autowired
    private ExamUserScoreMapper examUserScoreMapper;

    /**
     * 查询活动结果
     *
     * @param examUserScore
     * @return
     */
    @Override
    public List<ExamUserScoreVo> selectResult(ExamUserScoreVo examUserScore) {
        return examUserScoreMapper.selectResult(examUserScore);
    }

    @Override
    public List<ExamUserScoreVo> export(List<Integer> ids) {
        List<ExamUserScoreVo> list = new ArrayList<>();
        for (Integer id : ids) {
            //查询列表
            ExamUserScoreVo examUserScore = examUserScoreMapper.exportById(id);
            list.add(examUserScore);
        }
        return list;
    }


    /**
     * 修改考生成绩
     *
     * @param updateUserScore
     * @return
     */
    @Override
    public int updateExamUserScore(ExamUserScore updateUserScore) {
        updateUserScore.setCreateTime(DateUtils.getNowDate());
        return examUserScoreMapper.updateExamUserScore(updateUserScore);
    }
}
