package yangtz.cs.liu.campus.service.impl.epidemic;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.epidemic.EpidemicUserScore;
import yangtz.cs.liu.campus.domain.exam.ExamUserScore;
import yangtz.cs.liu.campus.mapper.epidemic.EpidemicUserScoreMapper;
import yangtz.cs.liu.campus.mapper.exam.ExamUserScoreMapper;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicUserScoreService;
import yangtz.cs.liu.campus.vo.epidemic.EpidemicUserScoreVo;
import yangtz.cs.liu.campus.vo.exam.ExamUserScoreVo;

import java.util.ArrayList;
import java.util.List;

@Service
public class EpidemicUserScoreServiceImpl extends ServiceImpl<EpidemicUserScoreMapper, EpidemicUserScore> implements IEpidemicUserScoreService {

    @Autowired
    private EpidemicUserScoreMapper epidemicUserScoreMapper;

    /**
     * 查询活动结果
     *
     * @param epidemicUserScore
     * @return
     */
    @Override
    public List<EpidemicUserScoreVo> selectResult(EpidemicUserScoreVo epidemicUserScore) {
        return epidemicUserScoreMapper.selectResult(epidemicUserScore);
    }

    @Override
    public List<EpidemicUserScoreVo> export(List<Integer> ids) {
        List<EpidemicUserScoreVo> list = new ArrayList<>();
        for (Integer id : ids) {
            //查询列表
            EpidemicUserScoreVo epidemicUserScore = epidemicUserScoreMapper.exportById(id);
            list.add(epidemicUserScore);
        }
        return list;
    }


    /**
     * 修改考生成绩
     *
     * @param updateUserScore
     * @return
     */
    @Override
    public int updateEpidemicUserScore(EpidemicUserScore updateUserScore) {
        updateUserScore.setCreateTime(DateUtils.getNowDate());
        return epidemicUserScoreMapper.updateEpidemicUserScore(updateUserScore);
    }
}
