package yangtz.cs.liu.campus.service.impl.device;

import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import yangtz.cs.liu.campus.domain.area.SchoolAreaDetail;
import yangtz.cs.liu.campus.domain.device.SchoolDevice;
import yangtz.cs.liu.campus.domain.device.SchoolDeviceClaim;
import yangtz.cs.liu.campus.domain.device.SchoolDeviceRecord;
import yangtz.cs.liu.campus.domain.office.SchoolOfficePurchase;
import yangtz.cs.liu.campus.mapper.area.SchoolAreaMapper;
import yangtz.cs.liu.campus.mapper.device.SchoolDeviceClaimMapper;
import yangtz.cs.liu.campus.mapper.device.SchoolDeviceMapper;
import yangtz.cs.liu.campus.mapper.device.SchoolDeviceRecordMapper;
import yangtz.cs.liu.campus.service.area.ISchoolAreaService;
import yangtz.cs.liu.campus.service.device.ISchoolDeviceService;
import yangtz.cs.liu.campus.vo.device.DeviceByIdVo;
import yangtz.cs.liu.campus.vo.device.DeviceListVo;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 设备管理Service业务层处理
 * 
 * @author ruoyi
 * @date 2022-10-16
 */
@Service
public class SchoolDeviceServiceImpl extends ServiceImpl<SchoolDeviceMapper, SchoolDevice> implements ISchoolDeviceService
{
    @Autowired
    private SchoolDeviceMapper schoolDeviceMapper;
    @Autowired
    private SchoolDeviceClaimMapper schoolDeviceClaimMapper;
    @Autowired
    private SchoolDeviceRecordMapper schoolDeviceRecordMapper;
    @Autowired
    private SchoolAreaMapper schoolAreaMapper;
    @Autowired
    private ISchoolDeviceService schoolDeviceService;

    @Override
    public List<SchoolDevice> queryList(SchoolDevice schoolDevice) {
        LambdaQueryWrapper<SchoolDevice> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotBlank(schoolDevice.getDeviceCode()),SchoolDevice::getDeviceCode,schoolDevice.getDeviceCode())
                .like(isNotBlank(schoolDevice.getDeviceName()),SchoolDevice::getDeviceName,schoolDevice.getDeviceName())
                .eq(isNotNull(schoolDevice.getDeviceType()),SchoolDevice::getDeviceType,schoolDevice.getDeviceType())
                .eq(isNotBlank(schoolDevice.getDeviceState()),SchoolDevice::getDeviceState,schoolDevice.getDeviceState())
                .orderByDesc(SchoolDevice::getCreateTime)
        ;
        List<SchoolDevice> list = schoolDeviceMapper.selectList(lqw);
//        List<DeviceListVo> list = schoolDeviceService.toListVo(schoolDeviceList);
        return list;
    }

    @Override
    public int deleteByIds(List<Long> ids) {
        // deviceClaim  设备领用表删除
        LambdaUpdateWrapper<SchoolDeviceClaim> claimLuw = new LambdaUpdateWrapper<>();
        claimLuw.in(SchoolDeviceClaim::getDeviceId,ids);
        schoolDeviceClaimMapper.delete(claimLuw);
        // deviceRecord  维修表删除
        LambdaUpdateWrapper<SchoolDeviceRecord> recordLuw = new LambdaUpdateWrapper<>();
        recordLuw.in(SchoolDeviceRecord::getDeviceId,ids);
        schoolDeviceRecordMapper.delete(recordLuw);
        return schoolDeviceMapper.deleteBatchIds(ids);
    }

//    @Override
//    public DeviceByIdVo toIdVo(SchoolDevice entity) {
//        DeviceByIdVo deviceByIdVo = new DeviceByIdVo();
//        BeanUtils.copyProperties(entity,deviceByIdVo);
//        switch (entity.getDeviceType().intValue()){
//            case 0 : deviceByIdVo.setDeviceType("教学设备");break;
//            case 1 : deviceByIdVo.setDeviceType("安全设备");break;
//        }
//        switch (entity.getDeviceState()){  //设备状态
//            case "0" : deviceByIdVo.setDeviceState("在用");break;
//            case "1" : deviceByIdVo.setDeviceState("维修");break;
//            case "2" : deviceByIdVo.setDeviceState("报废");break;
//        }
//        switch (entity.getDelFlag()){  //是否删除
//            case "0" : deviceByIdVo.setDelFlag("否");break;
//            case "1" : deviceByIdVo.setDelFlag("是");break;
//        }
//        String areaName = schoolAreaMapper.selectById(entity.getAreaId()).getAreaName();
//        deviceByIdVo.setAreaName(areaName);
//        return deviceByIdVo;
//    }

    @Override
    public SchoolDevice queryById(Long id) {
        SchoolDevice schoolDevice = schoolDeviceMapper.queryById(id);
        return schoolDevice;
    }

    @Override
    public List<SchoolDevice> queryByIds(List<Long> ids) {
        List<SchoolDevice> list = new ArrayList<>();
        for(Long id : ids){
            SchoolDevice schoolDevice = schoolDeviceMapper.queryById(id);
            list.add(schoolDevice);

        }
        return list;
    }

    @Override
    public List<DeviceListVo> toListVo(List<SchoolDevice> schoolDeviceList) {
        List<DeviceListVo> list = new ArrayList<>();
        for (SchoolDevice entity : schoolDeviceList) {
            DeviceListVo deviceListVo = new DeviceListVo();
            BeanUtils.copyProperties(entity, deviceListVo);
            switch (entity.getDeviceType()) {
                case 0:
                    deviceListVo.setDeviceType("教学设备");
                    break;
                case 1:
                    deviceListVo.setDeviceType("安全设备");
                    break;
            }
            switch (entity.getDeviceState()) {  //设备状态
                case "0":
                    deviceListVo.setDeviceState("在用");
                    break;
                case "1":
                    deviceListVo.setDeviceState("维修");
                    break;
                case "2":
                    deviceListVo.setDeviceState("报废");
                    break;
            }
            switch (entity.getDelFlag()) {  //是否删除
                case "0":
                    deviceListVo.setDelFlag("否");
                    break;
                case "1":
                    deviceListVo.setDelFlag("是");
                    break;
            }
            list.add(deviceListVo);
        }
        return list;
    }
}
