package yangtz.cs.liu.campus.service.impl.curricula;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.reflect.ReflectUtils;
import com.ruoyi.system.service.impl.SysDictDataServiceImpl;
import java.util.HashMap;
import java.util.Iterator;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.curricula.CurriculaStudent;
import yangtz.cs.liu.campus.domain.schoolAuthority.SchoolAuthority;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.domain.student.SchoolStudentScore;
import yangtz.cs.liu.campus.mapper.curricula.StudentScoreMapper;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassMapper;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentMapper;
import yangtz.cs.liu.campus.service.curricula.IStudentScoreService;
import yangtz.cs.liu.campus.vo.student.SchoolStudentScoreVo;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;

@Service
public class StudentScoreServiceImpl extends ServiceImpl<StudentScoreMapper, SchoolStudentScore> implements IStudentScoreService {

    @Autowired
    private StudentScoreMapper studentScoreMapper;
    @Autowired
    private SchoolStudentMapper schoolStudentMapper;
    @Autowired
    private SchoolClassMapper schoolClassMapper;
    @Autowired
    private SysDictDataServiceImpl dictDataService;

    /**
     * 查询学生成绩列表
     * @param schoolStudentScoreVo
     * @return
     */
    @Override
    public List<SchoolStudentScoreVo> selectStudentScoreList(SchoolStudentScoreVo schoolStudentScoreVo) {
        List<SchoolStudentScoreVo> list = studentScoreMapper.selectStudentScoreList(schoolStudentScoreVo);
        list.forEach(studentScoreVo -> {
            this.handleAchievement(studentScoreVo);
        });
        return list;
    }

    /**
     * 查看学生成绩详细信息
     * @param id
     * @return
     */
    @Override
    public SchoolStudentScoreVo selectStudentScoreById(Long id) {
        return studentScoreMapper.selectStudentScoreById(id);
    }

    /**
     * 导入
     * @param list
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public String importExamDetail(List<SchoolStudentScoreVo> list,Long curriculaId) {
        // 准备记录日志数据
        int successNum = 0;
        StringBuilder successMsg = new StringBuilder();
        //查询全部学生考试成绩
        LambdaQueryWrapper<SchoolStudentScore> lqw = new LambdaQueryWrapper<>();
        List<SchoolStudentScore> schoolStudentScores = studentScoreMapper.selectList(lqw);

        List<SchoolStudentScore> updateScoreList = new ArrayList<>();
        List<SchoolStudentScore> addScoreList = new ArrayList<>();

        for (SchoolStudentScoreVo schoolStudentScoreVo : list) {

            SchoolStudentScore score = new SchoolStudentScore();
            for (SchoolStudentScore schoolStudentScore : schoolStudentScores) {
                if (schoolStudentScoreVo.getExamType().equals(schoolStudentScore.getExamType()) &&
                        schoolStudentScoreVo.getStudentId().equals(schoolStudentScore.getStudentId()) &&
                        schoolStudentScore.getCurriculaId().equals(curriculaId)){
                    BeanUtils.copyProperties(schoolStudentScore,score);
                }
            }
            //判断学生是否存在此次考试成绩
            if (StringUtils.isNotNull(score.getStudentId())){
                //存在,更新学生此次考试成绩
                score.setLanguage(schoolStudentScoreVo.getLanguage());
                score.setMath(schoolStudentScoreVo.getMath());
                score.setEnglish(schoolStudentScoreVo.getEnglish());
                score.setPolitics(schoolStudentScoreVo.getPolitics());
                score.setGeography(schoolStudentScoreVo.getGeography());
                score.setHistory(schoolStudentScoreVo.getHistory());
                score.setPhysics(schoolStudentScoreVo.getPhysics());
                score.setChemistry(schoolStudentScoreVo.getChemistry());
                score.setBiology(schoolStudentScoreVo.getBiology());
                updateScoreList.add(score);
            }else {
                //不存在，新增学生此次考试成绩
                SchoolStudentScore schoolStudentScore = new SchoolStudentScore();
                BeanUtils.copyProperties(schoolStudentScoreVo,schoolStudentScore);
                addScoreList.add(schoolStudentScore);
            }
            successNum ++;
        }
        if (updateScoreList.size() > 0){
            studentScoreMapper.updateScoreList(updateScoreList);
        }
        if (addScoreList.size() > 0){
            studentScoreMapper.insertScoreList(addScoreList);
        }
        successMsg.insert(0, "恭喜您，数据已导入成功！共有 " + successNum + " 条，数据如下：");
        return successMsg.toString();
    }

    /**
     * 校验
     * @param list
     */
    @Override
    public void checkImport(List<SchoolStudentScoreVo> list) {
        //是否为空
        if (StringUtils.isNull(list) || list.size() == 0) {
            throw new ServiceException("导入数据不能为空");
        }
        //记录日志数据
        int failureNum = 0;
        StringBuilder failureMsg = new StringBuilder();
        for (SchoolStudentScoreVo schoolStudentScoreVo : list) {
            if (StringUtils.isNull(schoolStudentScoreVo.getStudentName())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、学生姓名为空，请你重新输入！");
            } else if (StringUtils.isNull(schoolStudentScoreVo.getIdCard())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、身份证号为空，请你重新输入！");
            } else if (StringUtils.isEmpty(schoolStudentScoreVo.getStudentNumber())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、学号为空，请您重新输入！");
            } else if (StringUtils.isNull(schoolStudentScoreVo.getExamType())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、考试类型为空，请您重新输入！");
            } else {
                LambdaQueryWrapper<SchoolStudent> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(SchoolStudent::getStudentName,schoolStudentScoreVo.getStudentName())
                        .eq(SchoolStudent::getIdCard,schoolStudentScoreVo.getIdCard());
                List<SchoolStudent> schoolStudents = schoolStudentMapper.selectList(wrapper);
                if (StringUtils.isNull(schoolStudents) || schoolStudents.size() == 0){
                    failureNum++;
                    failureMsg.append("<br/>" + failureNum + "、" + schoolStudentScoreVo.getStudentName() + "同学不存在,请您重新输入! ");
                }else {
                    SchoolStudent schoolStudent = schoolStudents.get(0);
                    schoolStudentScoreVo.setStudentId(schoolStudent.getId());
                }
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，导入失败！共" + failureNum + "条数据格式不正确，错误如下：");
            throw new BaseException(failureMsg.toString());
        }
    }

    /**
     * 根据身份证号获取学生信息
     * @param idCard
     * @return
     */
    @Override
    public SchoolStudentScoreVo selectStudent(String idCard) {
        SchoolStudentScoreVo schoolStudentScoreVo = studentScoreMapper.selectStudent(idCard);
        if (StringUtils.isNull(schoolStudentScoreVo)){
            throw new ServiceException("未查询到该学生信息,请仔细核对身份证号码");
        }
        return schoolStudentScoreVo;
    }

    /**
     * 新增学生成绩信息
     * @param schoolStudentScore
     * @return
     */
    @Override
    @Transactional
    public int insertStudentScore(SchoolStudentScore schoolStudentScore) {
        //判断是否存在该学生此次考试成绩
        LambdaQueryWrapper<SchoolStudentScore> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolStudentScore::getExamType,schoolStudentScore.getExamType())
                .eq(SchoolStudentScore::getStudentId,schoolStudentScore.getStudentId())
                .eq(SchoolStudentScore::getDelFlag,"0");
        List<SchoolStudentScore> schoolStudentScores = studentScoreMapper.selectList(wrapper);
        if (schoolStudentScores.size() > 0){
            throw new ServiceException("已存在该学生此次考试成绩");
        }
        if (schoolStudentScore.getLanguage() > 150 || schoolStudentScore.getLanguage() < 0){
            throw new ServiceException("请输入正确分数");
        }
        if (schoolStudentScore.getMath() > 150 || schoolStudentScore.getMath() < 0){
            throw new ServiceException("请输入正确分数");
        }
        if (schoolStudentScore.getEnglish() > 150 || schoolStudentScore.getEnglish() < 0){
            throw new ServiceException("请输入正确分数");
        }
        if (schoolStudentScore.getPolitics() > 150 || schoolStudentScore.getPolitics() < 0){
            throw new ServiceException("请输入正确分数");
        }
        if (schoolStudentScore.getGeography() > 150 || schoolStudentScore.getGeography() < 0){
            throw new ServiceException("请输入正确分数");
        }
        if (schoolStudentScore.getHistory() > 150 || schoolStudentScore.getHistory() < 0){
            throw new ServiceException("请输入正确分数");
        }
        if (schoolStudentScore.getPhysics() > 150 || schoolStudentScore.getPhysics() < 0){
            throw new ServiceException("请输入正确分数");
        }
        if (schoolStudentScore.getChemistry() > 150 || schoolStudentScore.getChemistry() < 0){
            throw new ServiceException("请输入正确分数");
        }
        if (schoolStudentScore.getBiology() > 150 || schoolStudentScore.getBiology() < 0){
            throw new ServiceException("请输入正确分数");
        }

        schoolStudentScore.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolStudentScore.setCreateTime(DateUtils.getNowDate());
        return studentScoreMapper.insert(schoolStudentScore);
    }

    /**
     * 修改学生成绩信息
     * @param schoolStudentScore
     * @return
     */
    @Override
    public int updateStudentScore(SchoolStudentScore schoolStudentScore) {
        schoolStudentScore.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolStudentScore.setUpdateTime(DateUtils.getNowDate());
        return studentScoreMapper.updateById(schoolStudentScore);
    }

    /**
     * 批量删除学生成绩信息
     * @param ids
     * @return
     */
    @Override
    public int deleteStudentScore(Long[] ids) {
        return studentScoreMapper.deleteStudentScore(ids);
    }

    private Map<String,String> typeMap = new HashMap<String,String>(){{
       this.put("语","language");
       this.put("数","math");
       this.put("英","english");
       this.put("政","politics");
       this.put("地","geography");
       this.put("历","history");
       this.put("物","physics");
       this.put("化","chemistry");
       this.put("生","biology");
    }};
    //排名
    private Map<String,String> ranKingMap = new HashMap<String,String>(){{
        this.put("语","ywRanking");
        this.put("数","sxRanking");
        this.put("英","yyRanking");
        this.put("政","zzRanking");
        this.put("地","dlRanking");
        this.put("历","lsRanking");
        this.put("物","wlRanking");
        this.put("化","hxRanking");
        this.put("生","swRanking");
    }};



    /**
     * 查询学生三类行成绩
     * @param curriculaStudent
     * @return
     */
    @Override
    public List<SchoolStudentScoreVo> getStudentTypeViwe(CurriculaStudent curriculaStudent) {
        //获取学生id
        Long studentId = curriculaStudent.getStudentId();
        //获取课程信息
        String selectedCourse = curriculaStudent.getSelectedCourse();

        //学生信息查询年级信息
        SchoolStudentVO info = schoolStudentMapper.getInfo(studentId);
        //获取年级
        SchoolClass schoolClass = schoolClassMapper.selectById(info.getClassId());
        //对比课程中文名
        String section_type = dictDataService.selectDictLabel("section_type" , selectedCourse);
        String[] split = new String[3];
        split[0] = section_type.substring(0,1);
        split[1] = section_type.substring(1,2);
        split[2] = section_type.substring(2,3);

        //获取班级成绩
        List<SchoolStudentScoreVo> schoolStudentScoreVos = this.selectStudentScoreList(studentId);
        for (SchoolStudentScoreVo data : schoolStudentScoreVos) {
            //重新计算年级总排名，值给根据选择专业去判断
            //个人3课总成绩
            Double toleType = (Double)ReflectUtils.invokeGetter(data,typeMap.get(split[0])) + (Double)ReflectUtils.invokeGetter(data,typeMap.get(split[1])) +(Double)ReflectUtils.invokeGetter(data,typeMap.get(split[2]));
            data.setTotalScore(toleType);
            //获取其他学生三门总成绩 做对比
            SchoolStudentScoreVo schoolStudentScoreVo1 = new SchoolStudentScoreVo();
            //查询本年级所有成绩列表
            schoolStudentScoreVo1.setGradeValue(schoolClass.getGradeValue());
            schoolStudentScoreVo1.setExamType(data.getExamType());
            List<SchoolStudentScoreVo> list1 = studentScoreMapper.selectStudentScoreList(schoolStudentScoreVo1);
            //重写总成绩
            list1.forEach(voDate->{
                voDate.setTotalScore((Double)ReflectUtils.invokeGetter(voDate,typeMap.get(split[0])) + (Double)ReflectUtils.invokeGetter(voDate,typeMap.get(split[1])) +(Double)ReflectUtils.invokeGetter(voDate,typeMap.get(split[2])));
            });
            //按总成绩降序排序
            List<SchoolStudentScoreVo> collect = list1.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getTotalScore).reversed()).collect(Collectors.toList());
            //排名
            int index = 1;
            double totalScore = data.getTotalScore();
            for (int i = 0; i < collect.size(); i++) {
                SchoolStudentScoreVo studentScoreVo1 = collect.get(i);
                if (Double.compare(totalScore,studentScoreVo1.getTotalScore()) != 0 && Double.compare(totalScore,studentScoreVo1.getTotalScore()) == -1){
                    index ++;
                }
            }
            data.setRanking(index);
        }
        //重新封装返回值去除无效值
        List<SchoolStudentScoreVo> listVo = new ArrayList<>();
        schoolStudentScoreVos.forEach(data->{
            SchoolStudentScoreVo scoreVo = new SchoolStudentScoreVo();
            scoreVo.setStudentId(data.getStudentId());
            scoreVo.setClassId(data.getClassId());
            scoreVo.setStudentName(data.getStudentName());
            scoreVo.setStudentNumber(data.getStudentNumber());
            scoreVo.setIdCard(data.getIdCard());
            scoreVo.setClassName(data.getClassName());
            scoreVo.setExamType(data.getExamType());
            scoreVo.setTotalScore(data.getTotalScore());
            scoreVo.setRanking(data.getRanking());
            ReflectUtils.invokeSetter(scoreVo,typeMap.get(split[0]), (Double)ReflectUtils.invokeGetter(data,typeMap.get(split[0])));
            ReflectUtils.invokeSetter(scoreVo,typeMap.get(split[1]), (Double)ReflectUtils.invokeGetter(data,typeMap.get(split[1])));
            ReflectUtils.invokeSetter(scoreVo,typeMap.get(split[2]), (Double)ReflectUtils.invokeGetter(data,typeMap.get(split[2])));
            ReflectUtils.invokeSetter(scoreVo,ranKingMap.get(split[0]), ReflectUtils.invokeGetter(data,ranKingMap.get(split[0])));
            ReflectUtils.invokeSetter(scoreVo,ranKingMap.get(split[1]), ReflectUtils.invokeGetter(data,ranKingMap.get(split[1])));
            ReflectUtils.invokeSetter(scoreVo,ranKingMap.get(split[2]), ReflectUtils.invokeGetter(data,ranKingMap.get(split[2])));

            listVo.add(scoreVo);
        });
        return listVo;

    }

    /**
     * 根据学生ID查询所有成绩
     * @param studentId
     * @return
     */
    @Override
    public List<SchoolStudentScoreVo> selectStudentScoreList(Long studentId) {
        SchoolStudentScoreVo schoolStudentScoreVo = new SchoolStudentScoreVo();
        schoolStudentScoreVo.setStudentId(studentId);
        List<SchoolStudentScoreVo> schoolStudentScoreVos = studentScoreMapper
            .selectStudentScoreList(schoolStudentScoreVo);
        //学生信息查询年级信息
        SchoolStudentVO info = schoolStudentMapper.getInfo(studentId);
        //获取年级
        SchoolClass schoolClass = schoolClassMapper.selectById(info.getClassId());

        for (SchoolStudentScoreVo data : schoolStudentScoreVos) {
            //之查看学生本年级的成绩
            data.setGradeValue(schoolClass.getGradeValue());
            this.handleAchievement(data);
        }
        Iterator<SchoolStudentScoreVo> iterator = schoolStudentScoreVos.iterator();
        while (iterator.hasNext()){
            SchoolStudentScoreVo next = iterator.next();
            if (StringUtils.equals("4",next.getExamType())){
                iterator.remove();
            }
        }
        return schoolStudentScoreVos;
    }




    private SchoolStudentScoreVo handleAchievement(SchoolStudentScoreVo studentScoreVo){
        //计算考试成绩年级排名/班级排名
        //按年级查询
        SchoolStudentScoreVo schoolStudentScoreVo1 = new SchoolStudentScoreVo();
        schoolStudentScoreVo1.setCurriculaId(studentScoreVo.getCurriculaId());
        schoolStudentScoreVo1.setExamType(studentScoreVo.getExamType());
        if (studentScoreVo.getGradeValue()!=null){
            schoolStudentScoreVo1.setGradeValue(studentScoreVo.getGradeValue());
        }
        List<SchoolStudentScoreVo> list1 = studentScoreMapper.selectStudentScoreList(schoolStudentScoreVo1);
        //按班级查询
        SchoolStudentScoreVo schoolStudentScoreVo2 = new SchoolStudentScoreVo();
        schoolStudentScoreVo2.setCurriculaId(studentScoreVo.getCurriculaId());
        schoolStudentScoreVo2.setClassId(studentScoreVo.getClassId());
        schoolStudentScoreVo2.setExamType(studentScoreVo.getExamType());
        if (studentScoreVo.getGradeValue()!=null){
            schoolStudentScoreVo2.setGradeValue(studentScoreVo.getGradeValue());
        }
        List<SchoolStudentScoreVo> list2 = studentScoreMapper.selectStudentScoreList(schoolStudentScoreVo2);

        //总成绩年级排名
        //按总成绩降序排序
        List<SchoolStudentScoreVo> collect = list1.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getTotalScore).reversed()).collect(Collectors.toList());
        //排名
        int index = 1;
        double totalScore = studentScoreVo.getTotalScore();
        for (int i = 0; i < collect.size(); i++) {
            SchoolStudentScoreVo studentScoreVo1 = collect.get(i);
            if (Double.compare(totalScore,studentScoreVo1.getTotalScore()) != 0 && Double.compare(totalScore,studentScoreVo1.getTotalScore()) == -1){
                index ++;
            }
        }
        studentScoreVo.setRanking(index);
        //总成绩班级排名
        //按总成绩降序排序
        List<SchoolStudentScoreVo> collect1 = list2.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getTotalScore).reversed()).collect(Collectors.toList());
        //排名
        int index1 = 1;
        for (int i = 0; i < collect1.size(); i++) {
            SchoolStudentScoreVo studentScoreVo2 = collect1.get(i);
            if (Double.compare(totalScore,studentScoreVo2.getTotalScore()) != 0 && Double.compare(totalScore,studentScoreVo2.getTotalScore()) == -1){
                index1 ++;
            }
        }
        studentScoreVo.setClassRanking(index1);

        //语文成绩年级排名
        //按语文成绩降序排序
        List<SchoolStudentScoreVo> collect2 = list1.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getLanguage).reversed()).collect(Collectors.toList());
        //排名
        int index3 = 1;
        double language = studentScoreVo.getLanguage();
        for (int i = 0; i < collect2.size(); i++) {
            SchoolStudentScoreVo studentScoreVo1 = collect2.get(i);
            if (Double.compare(language,studentScoreVo1.getLanguage()) != 0 && Double.compare(language,studentScoreVo1.getLanguage()) == -1){
                index3 ++;
            }
        }
        studentScoreVo.setYwRanking(index3);
        //语文成绩班级排名
        //按语文成绩降序排序
        List<SchoolStudentScoreVo> collect4 = list2.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getLanguage).reversed()).collect(Collectors.toList());
        //排名
        int index4 = 1;
        for (int i = 0; i < collect4.size(); i++) {
            SchoolStudentScoreVo studentScoreVo2 = collect4.get(i);
            if (Double.compare(language,studentScoreVo2.getLanguage()) != 0 && Double.compare(language,studentScoreVo2.getLanguage()) == -1){
                index4 ++;
            }
        }
        studentScoreVo.setYwClassRanking(index4);

        //数学成绩年级排名
        //按数学成绩降序排序
        List<SchoolStudentScoreVo> collect3 = list1.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getMath).reversed()).collect(Collectors.toList());
        //排名
        int index5 = 1;
        double math = studentScoreVo.getMath();
        for (int i = 0; i < collect3.size(); i++) {
            SchoolStudentScoreVo studentScoreVo1 = collect3.get(i);
            if (Double.compare(math,studentScoreVo1.getMath()) != 0 && Double.compare(math,studentScoreVo1.getMath()) == -1){
                index5 ++;
            }
        }
        studentScoreVo.setSxRanking(index5);
        //数学成绩班级排名
        //按数学成绩降序排序
        List<SchoolStudentScoreVo> collect6 = list2.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getMath).reversed()).collect(Collectors.toList());
        //排名
        int index6 = 1;
        for (int i = 0; i < collect6.size(); i++) {
            SchoolStudentScoreVo studentScoreVo2 = collect6.get(i);
            if (Double.compare(math,studentScoreVo2.getMath()) != 0 && Double.compare(math,studentScoreVo2.getMath()) == -1) {
                index6++;
            }
        }
        studentScoreVo.setSxClassRanking(index6);

        //英语成绩年级排名
        //按英语成绩降序排序
        List<SchoolStudentScoreVo> collectYy = list1.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getEnglish).reversed()).collect(Collectors.toList());
        //排名
        int indexYy = 1;
        double english = studentScoreVo.getEnglish();
        for (int i = 0; i < collectYy.size(); i++) {
            SchoolStudentScoreVo studentScoreVoYy = collectYy.get(i);
            if (Double.compare(english,studentScoreVoYy.getEnglish()) != 0 && Double.compare(english,studentScoreVoYy.getEnglish()) == -1){
                indexYy ++;
            }
        }
        studentScoreVo.setYyRanking(indexYy);
        //英语成绩班级排名
        //按英语成绩降序排序
        List<SchoolStudentScoreVo> collectYy1 = list2.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getEnglish).reversed()).collect(Collectors.toList());
        //排名
        int indexYy1 = 1;
        for (int i = 0; i < collectYy1.size(); i++) {
            SchoolStudentScoreVo studentScoreVoYy1 = collectYy1.get(i);
            if (Double.compare(english,studentScoreVoYy1.getEnglish()) != 0 && Double.compare(english,studentScoreVoYy1.getEnglish()) == -1){
                indexYy1 ++;
            }
        }
        studentScoreVo.setYyClassRanking(indexYy1);

        //政治成绩年级排名
        //按政治成绩降序排序
        List<SchoolStudentScoreVo> collectZz = list1.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getPolitics).reversed()).collect(Collectors.toList());
        //排名
        int indexZz = 1;
        double politics = studentScoreVo.getPolitics();
        for (int i = 0; i < collectZz.size(); i++) {
            SchoolStudentScoreVo studentScoreVoZz = collectZz.get(i);
            if (Double.compare(politics,studentScoreVoZz.getPolitics()) != 0 && Double.compare(politics,studentScoreVoZz.getPolitics()) == -1){
                indexZz ++;
            }
        }
        studentScoreVo.setZzRanking(indexZz);
        //政治成绩班级排名
        //按政治成绩降序排序
        List<SchoolStudentScoreVo> collectZz1 = list2.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getPolitics).reversed()).collect(Collectors.toList());
        //排名
        int indexZz1 = 1;
        for (int i = 0; i < collectZz1.size(); i++) {
            SchoolStudentScoreVo studentScoreVoZz1 = collectZz1.get(i);
            if (Double.compare(politics,studentScoreVoZz1.getPolitics()) != 0 && Double.compare(politics,studentScoreVoZz1.getPolitics()) == -1){
                indexZz1 ++;
            }
        }
        studentScoreVo.setZzClassRanking(indexZz1);

        //地理成绩年级排名
        //按地理成绩降序排序
        List<SchoolStudentScoreVo> collectDl = list1.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getGeography).reversed()).collect(Collectors.toList());
        //排名
        int indexDl = 1;
        double geography = studentScoreVo.getGeography();
        for (int i = 0; i < collectDl.size(); i++) {
            SchoolStudentScoreVo studentScoreVoDl = collectDl.get(i);
            if (Double.compare(geography,studentScoreVoDl.getGeography()) != 0 && Double.compare(geography,studentScoreVoDl.getGeography()) == -1){
                indexDl ++;
            }
        }
        studentScoreVo.setDlRanking(indexDl);
        //地理成绩班级排名
        //按地理成绩降序排序
        List<SchoolStudentScoreVo> collectDl1 = list2.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getGeography).reversed()).collect(Collectors.toList());
        //排名
        int indexDl1 = 1;
        for (int i = 0; i < collectDl1.size(); i++) {
            SchoolStudentScoreVo studentScoreVoDl1 = collectDl1.get(i);
            if (Double.compare(geography,studentScoreVoDl1.getGeography()) != 0 && Double.compare(geography,studentScoreVoDl1.getGeography()) == -1){
                indexDl1 ++;
            }
        }
        studentScoreVo.setDlClassRanking(indexDl1);

        //历史成绩年级排名
        //按历史成绩降序排序
        List<SchoolStudentScoreVo> collectLs = list1.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getHistory).reversed()).collect(Collectors.toList());
        //排名
        int indexLs = 1;
        double history = studentScoreVo.getHistory();
        for (int i = 0; i < collectLs.size(); i++) {
            SchoolStudentScoreVo studentScoreVoLs = collectLs.get(i);
            if (Double.compare(history,studentScoreVoLs.getHistory()) != 0 && Double.compare(history,studentScoreVoLs.getHistory()) == -1){
                indexLs ++;
            }
        }
        studentScoreVo.setLsRanking(indexLs);
        //历史成绩班级排名
        //按历史成绩降序排序
        List<SchoolStudentScoreVo> collectLs1 = list2.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getHistory).reversed()).collect(Collectors.toList());
        //排名
        int indexLs1 = 1;
        for (int i = 0; i < collectLs1.size(); i++) {
            SchoolStudentScoreVo studentScoreVoLs1 = collectLs1.get(i);
            if (Double.compare(history,studentScoreVoLs1.getHistory()) != 0 && Double.compare(history,studentScoreVoLs1.getHistory()) == -1){
                indexLs1 ++;
            }
        }
        studentScoreVo.setLsClassRanking(indexLs1);

        //物理成绩年级排名
        //按物理成绩降序排序
        List<SchoolStudentScoreVo> collectWl = list1.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getPhysics).reversed()).collect(Collectors.toList());
        //排名
        int indexWl = 1;
        double physics = studentScoreVo.getPhysics();
        for (int i = 0; i < collectWl.size(); i++) {
            SchoolStudentScoreVo studentScoreVoWl = collectWl.get(i);
            if (Double.compare(physics,studentScoreVoWl.getPhysics()) != 0 && Double.compare(physics,studentScoreVoWl.getPhysics()) == -1){
                indexWl ++;
            }
        }
        studentScoreVo.setWlRanking(indexWl);
        //物理成绩班级排名
        //按物理成绩降序排序
        List<SchoolStudentScoreVo> collectWl1 = list2.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getPhysics).reversed()).collect(Collectors.toList());
        //排名
        int indexWl1 = 1;
        for (int i = 0; i < collectWl1.size(); i++) {
            SchoolStudentScoreVo studentScoreVoWl1 = collectWl1.get(i);
            if (Double.compare(physics,studentScoreVoWl1.getPhysics()) != 0 && Double.compare(physics,studentScoreVoWl1.getPhysics()) == -1){
                indexWl1 ++;
            }
        }
        studentScoreVo.setWlClassRanking(indexWl1);

        //化学成绩年级排名
        //按化学成绩降序排序
        List<SchoolStudentScoreVo> collectHx = list1.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getChemistry).reversed()).collect(Collectors.toList());
        //排名
        int indexHx = 1;
        double chemistry = studentScoreVo.getChemistry();
        for (int i = 0; i < collectHx.size(); i++) {
            SchoolStudentScoreVo studentScoreVoHx = collectHx.get(i);
            if (Double.compare(chemistry,studentScoreVoHx.getChemistry()) != 0 && Double.compare(chemistry,studentScoreVoHx.getChemistry()) == -1){
                indexHx ++;
            }
        }
        studentScoreVo.setHxRanking(indexHx);
        //化学成绩班级排名
        //按化学成绩降序排序
        List<SchoolStudentScoreVo> collectHx1 = list2.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getChemistry).reversed()).collect(Collectors.toList());
        //排名
        int indexHx1 = 1;
        for (int i = 0; i < collectHx1.size(); i++) {
            SchoolStudentScoreVo studentScoreVoHx1 = collectHx1.get(i);
            if (Double.compare(chemistry,studentScoreVoHx1.getChemistry()) != 0 && Double.compare(chemistry,studentScoreVoHx1.getChemistry()) == -1){
                indexHx1 ++;
            }
        }
        studentScoreVo.setHxClassRanking(indexHx1);

        //生物成绩年级排名
        //按生物成绩降序排序
        List<SchoolStudentScoreVo> collectSw = list1.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getBiology).reversed()).collect(Collectors.toList());
        //排名
        int indexSw = 1;
        double biology = studentScoreVo.getBiology();
        for (int i = 0; i < collectSw.size(); i++) {
            SchoolStudentScoreVo studentScoreVoSw = collectSw.get(i);
            if (Double.compare(biology,studentScoreVoSw.getBiology()) != 0 && Double.compare(biology,studentScoreVoSw.getBiology()) == -1){
                indexSw ++;
            }
        }
        studentScoreVo.setSwRanking(indexSw);
        //生物成绩班级排名
        //按生物成绩降序排序
        List<SchoolStudentScoreVo> collectSw1 = list2.stream().sorted(Comparator.comparing(SchoolStudentScoreVo::getBiology).reversed()).collect(Collectors.toList());
        //排名
        int indexSw1 = 1;
        for (int i = 0; i < collectSw1.size(); i++) {
            SchoolStudentScoreVo studentScoreVoSw1 = collectSw1.get(i);
            if (Double.compare(biology,studentScoreVoSw1.getBiology()) != 0 && Double.compare(biology,studentScoreVoSw1.getBiology()) == -1){
                indexSw1 ++;
            }
        }
        studentScoreVo.setSwClassRanking(indexSw1);
        return studentScoreVo;
    }

}
