package yangtz.cs.liu.campus.service.impl.common;

import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.persistence.entity.TaskEntityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.activiti.service.IProcessService;
import yangtz.cs.liu.campus.domain.auditorium.SchoolAuditorium;
import yangtz.cs.liu.campus.domain.purchase.SchoolPurchase;
import yangtz.cs.liu.campus.domain.schoolDepartmentBudget.SchoolDepartmentBudget;
import yangtz.cs.liu.campus.domain.schooloffical.SchoolOfficialFlow;
import yangtz.cs.liu.campus.domain.student.SchoolStudentLeave;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherLeave;
import yangtz.cs.liu.campus.mapper.auditorium.SchoolAuditoriumMapper;
import yangtz.cs.liu.campus.mapper.exam.ExamMainMapper;
import yangtz.cs.liu.campus.mapper.purchase.SchoolPurchaseMapper;
import yangtz.cs.liu.campus.mapper.schoolDepartmentBudget.SchoolDepartmentBudgetMapper;
import yangtz.cs.liu.campus.mapper.schooloffical.SchoolOfficialFlowMapper;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentLeaveMapper;
import yangtz.cs.liu.campus.mapper.teacher.SchoolTeacherLeaveMapper;
import yangtz.cs.liu.campus.service.common.ICountService;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherLeaveService;
import yangtz.cs.liu.campus.vo.auditorium.SchoolAuditoriumVo;
import yangtz.cs.liu.campus.vo.common.CountVo;
import yangtz.cs.liu.campus.vo.purchase.SchoolPurchaseVo;
import yangtz.cs.liu.campus.vo.schoolDepartmentBudget.SchoolDepartmentBudgetVo;
import yangtz.cs.liu.campus.vo.student.StudentLeaveVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherLeaveVO;

import java.util.ArrayList;
import java.util.List;

import static com.core.constant.ProcessCommon.PENDING;
import static com.core.constant.ProcessCommon.SUSPENDSTATE_PENDING;
import static com.core.constant.ProcessDefinition.*;
import static yangtz.cs.liu.campus.constant.OfficalConstant.UNDONE;
@Service
public class CountServiceImpl implements ICountService {

    @Autowired
    private IProcessService processService;

    @Autowired
    private SchoolOfficialFlowMapper flowMapper;

    @Autowired
    private ExamMainMapper examMainMapper;

    @Autowired
    private SchoolStudentLeaveMapper schoolStudentLeaveMapper;

    @Autowired
    private SchoolTeacherLeaveMapper schoolTeacherLeaveMapper;

    @Autowired
    private SchoolPurchaseMapper schoolPurchaseMapper;

    @Autowired
    private SchoolAuditoriumMapper schoolAuditoriumMapper;

    @Autowired
    private SchoolDepartmentBudgetMapper schoolDepartmentBudgetMapper;

    @Autowired
    private RuntimeService runtimeService;

    @Override
    public CountVo myCount(Long userId) {
        //返回结果
        CountVo vo = new CountVo();

        /**教师请假审批任务数*/
        int tLeaveNum  = getNum(TEACHERLEAVE, userId.toString());

        /**公文流转操作任务数*/
        int officialNum = flowMapper.getTodoTotal(userId,UNDONE);

        /**调查问卷任务数*/
//        int investigate = examMainMapper.getTodoTotal(userId);

        /**采购申请审批任务数*/
        int purchaseRequisition  = getNum(PURCHASEREQUEST, userId.toString());

        /**学生请假审批任务数*/
        int sLeaveNum  = getNum(STUDENTLEAVE, userId.toString());

        /**礼堂预约审批任务数*/
        int auditoriumNum  = getNum(AUDITORIUMAPPLY, userId.toString());

        /**科室预算审批任务数*/
        int departmentBudgetNum  = getNum(DEPARTMENTBUDGET, userId.toString());

        vo.setTLeaveNum(tLeaveNum);
        vo.setOfficialNum(officialNum);
//        vo.setInvestigate(investigate);
        vo.setPurchaseRequisition(purchaseRequisition);
        vo.setSLeaveNum(sLeaveNum);
        vo.setAuditoriumNum(auditoriumNum);
        vo.setDepartmentBudgetNum(departmentBudgetNum);
        return vo;
    }

    int getNum(String key,String userId){
        if(STUDENTLEAVE.equals(key)){
            List<StudentLeaveVO> list = new ArrayList<>();
            //当前登录人待办任务集合
            List<Task> taskList = processService.findAssigneeTasks(userId, key);
            for (Task task : taskList) {
                TaskEntityImpl taskImpl = (TaskEntityImpl) task;
                //拿到当前任务id
                String processInstanceId = taskImpl.getProcessInstanceId();
                //拿到流程定义对象
                ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
                //业务id(我们当时新增的时候指定了businessKey为id)
                String businessKey = processInstance.getBusinessKey();
                //通过id查询出我们业务对象
                SchoolStudentLeave schoolStudentLeave = schoolStudentLeaveMapper.selectById(new Long(businessKey));
                if (StringUtils.isNull(schoolStudentLeave)) {
                    continue;
                }
                //转vo
                StudentLeaveVO studentLeaveVO = new StudentLeaveVO();
                BeanUtils.copyProperties(schoolStudentLeave, studentLeaveVO);
                list.add(studentLeaveVO);
            }
            return list.size();
        }

        if(TEACHERLEAVE.equals(key)){
            List<TeacherLeaveVO> list = new ArrayList<>();
            //当前登录人待办任务集合
            List<Task> taskList = processService.findAssigneeTasks(userId, key);
            for (Task task : taskList) {
                TaskEntityImpl taskImpl = (TaskEntityImpl) task;
                //拿到当前任务id
                String processInstanceId = taskImpl.getProcessInstanceId();
                //拿到流程定义对象
                ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
                //业务id(我们当时新增的时候指定了businessKey为id)
                String businessKey = processInstance.getBusinessKey();
                //通过id查询出我们业务对象
                SchoolTeacherLeave schoolTeacherLeave = schoolTeacherLeaveMapper.selectById(new Long(businessKey));
                if (StringUtils.isNull(schoolTeacherLeave)) {
                    continue;
                }
                //转vo
                TeacherLeaveVO teacherLeaveVO = new TeacherLeaveVO();
                BeanUtils.copyProperties(schoolTeacherLeave, teacherLeaveVO);
                list.add(teacherLeaveVO);
            }
            return list.size();
        }

        if(PURCHASEREQUEST.equals(key)){
            List<SchoolPurchaseVo> list = new ArrayList<>();
            //当前登录人待办任务集合
            List<Task> taskList = processService.findAssigneeTasks(userId, key);
            for (Task task : taskList) {
                TaskEntityImpl taskImpl = (TaskEntityImpl) task;
                //拿到当前任务id
                String processInstanceId = taskImpl.getProcessInstanceId();
                //拿到流程定义对象
                ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
                //业务id(我们当时新增的时候指定了businessKey为id)
                String businessKey = processInstance.getBusinessKey();
                //通过id查询出我们业务对象
                SchoolPurchase schoolPurchase = schoolPurchaseMapper.selectById(new Long(businessKey));
                if (StringUtils.isNull(schoolPurchase)) {
                    continue;
                }
                SchoolPurchaseVo schoolPurchaseVo = new SchoolPurchaseVo();
                BeanUtils.copyProperties(schoolPurchase, schoolPurchaseVo);
                list.add(schoolPurchaseVo);
            }
            return list.size();
        }

        if(AUDITORIUMAPPLY.equals(key)){
            List<SchoolAuditoriumVo> list = new ArrayList<>();
            //当前登录人待办任务集合
            List<Task> taskList = processService.findAssigneeTasks(userId, key);
            for (Task task : taskList) {
                TaskEntityImpl taskImpl = (TaskEntityImpl) task;
                //拿到当前任务id
                String processInstanceId = taskImpl.getProcessInstanceId();
                //拿到流程定义对象
                ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
                //业务id(我们当时新增的时候指定了businessKey为id)
                String businessKey = processInstance.getBusinessKey();
                //通过id查询出我们业务对象
                SchoolAuditorium schoolAuditorium = schoolAuditoriumMapper.selectById(new Long(businessKey));
                if (StringUtils.isNull(schoolAuditorium)) {
                    continue;
                }
                SchoolAuditoriumVo schoolAuditoriumVo = new SchoolAuditoriumVo();
                BeanUtils.copyProperties(schoolAuditorium, schoolAuditoriumVo);
                list.add(schoolAuditoriumVo);
            }
            return list.size();
        }

        if(DEPARTMENTBUDGET.equals(key)){
            List<SchoolDepartmentBudgetVo> list = new ArrayList<>();
            //当前登录人待办任务集合
            List<Task> taskList = processService.findAssigneeTasks(userId, key);
            for (Task task : taskList) {
                TaskEntityImpl taskImpl = (TaskEntityImpl) task;
                //拿到当前任务id
                String processInstanceId = taskImpl.getProcessInstanceId();
                //拿到流程定义对象
                ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
                //业务id(我们当时新增的时候指定了businessKey为id)
                String businessKey = processInstance.getBusinessKey();
                //通过id查询出我们业务对象
                SchoolDepartmentBudget departmentBudget = schoolDepartmentBudgetMapper.selectById(new Long(businessKey));
                if (StringUtils.isNull(departmentBudget)) {
                    continue;
                }
                SchoolDepartmentBudgetVo schoolDepartmentBudgetVo = new SchoolDepartmentBudgetVo();
                BeanUtils.copyProperties(departmentBudget, schoolDepartmentBudgetVo);
                list.add(schoolDepartmentBudgetVo);
            }
            return list.size();
        }
        return 0;
    }
}
