package yangtz.cs.liu.campus.service.epidemic;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.epidemic.EpidemicMain;
import yangtz.cs.liu.campus.vo.epidemic.EpidemicMainVo;
import yangtz.cs.liu.campus.vo.epidemic.IScoreVo;

import java.util.List;

/**
 * 问卷调查Service层
 */
public interface IEpidemicMainService extends IService<EpidemicMain> {

    /**
     * 查询问卷调查列表
     *
     * @param epidemicMain
     * @return
     */
    List<EpidemicMain> queryList(EpidemicMain epidemicMain);

    /**
     * 查询参与情况
     *
     * @param epidemic
     * @return
     */
    List<EpidemicMainVo> selectTakeEpidemicPeoNumList(EpidemicMainVo epidemic);

    /**
     * 查询代办任务
     *
     * @param epidemicMainVo
     * @return
     */
    List<EpidemicMainVo> selectEpidemicTasks(EpidemicMainVo epidemicMainVo);

    /**
     * 删除问卷调查表
     *
     * @param ids
     * @return
     */
    int deleteByIds(List<Integer> ids);

    /**
     * 参加打分功能
     *
     * @param epidemicId
     * @param score
     */
    void join(Long epidemicId, IScoreVo score);

    /**
     * 检查是否可以发布
     * @param id
     */
    void checkEpidemic(Long id);

    /**
     * 更改问卷状态
     * @param epidemicState
     * @param id
     * @return
     */
    int editEpidemicState(Character epidemicState, Long id);
}
