package yangtz.cs.liu.campus.service.curricula;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.curricula.CurriculaVariable;
import yangtz.cs.liu.campus.vo.curricula.CurriculaVariableVo;

import java.util.List;
import java.util.Map;

public interface ICurriculaVariableService extends IService<CurriculaVariable> {
    /**
     * 查询选课任务列表
     * @param curriculaVariable
     * @return
     */
    List<CurriculaVariableVo> selectCurriculaVariableList(CurriculaVariableVo curriculaVariable);

    /**
     * 新增选课任务
     * @param curriculaVariable
     * @return
     */
    int insertCurriculaVariable(CurriculaVariable curriculaVariable);

    /**
     * 获取选课任务详细信息
     * @param id
     * @return
     */
    CurriculaVariableVo selectCurriculaVariableById(Long id);

    /**
     * 获取当前最新级部
     * @return
     */
    Map<String,String> getNewGrade();

    /**
     * 获取班级下拉框
     * @param grade
     * @return
     */
    List<Map<String,String>> selectClass(String grade);

    /**
     * 修改选课任务
     * @param curriculaVariable
     * @return
     */
    int updateCurriculaVariable(CurriculaVariable curriculaVariable);

    /**
     * 获取选课任务下拉框
     * @return
     */
    List<Map<String,String>> getGrade();
}
