package yangtz.cs.liu.campus.service.area;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.common.core.domain.TreeSelect;
import yangtz.cs.liu.campus.domain.area.SchoolAreaApply;
import yangtz.cs.liu.campus.domain.area.SchoolAreaDetail;
import yangtz.cs.liu.campus.vo.area.AreaDetailVo;
import yangtz.cs.liu.campus.vo.area.ImportDetailVo;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;

import java.util.List;

/**
 * 场地详情信息Service接口
 *
 * @author ruoyi
 * @date 2022-09-29
 */
public interface ISchoolAreaDetailService extends IService<SchoolAreaDetail>
{
    List<AreaDetailVo> queryList(SchoolAreaDetail  schoolAreaDetail);

    void checkImport(List<ImportDetailVo> list,Long areaId);

    String importAreaDetailList(List<ImportDetailVo> list,Long areaId);

    Long getGradeId(Integer gradeValue, Integer classValue);  //通过年级和班级获取班级id

    AreaDetailVo queryById(Long id);

    int deleteByIds(List<Long> ids);

    List<AreaDetailVo> selectExportList(List<Long> ids);

    //某场地下所有详情
    List<AreaDetailVo> selectListByAreaId(Long areaId);

    List<SchoolAreaDetail> queryByAreaId(Long id);

}
