package yangtz.cs.liu.campus.mapper.thesis;

import java.util.List;
import yangtz.cs.liu.campus.domain.thesis.Thesis;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

/**
 * 论文情况Mapper接口
 *
 * @author ruoyi
 * @date 2023-07-25
 */
public interface ThesisMapper
{
    /**
     * 查询论文情况
     *
     * @param id 论文情况主键
     * @return 论文情况
     */
    public Thesis selectThesisById(Long id);

    /**
     * 查询论文情况列表
     *
     * @param thesis 论文情况
     * @return 论文情况集合
     */
    public List<Thesis> selectThesisList(Thesis thesis);

    /**
     * 新增论文情况
     *
     * @param thesis 论文情况
     * @return 结果
     */
    public int insertThesis(Thesis thesis);

    /**
     * 修改论文情况
     *
     * @param thesis 论文情况
     * @return 结果
     */
    public int updateThesis(Thesis thesis);

    /**
     * 删除论文情况
     *
     * @param id 论文情况主键
     * @return 结果
     */
    public int deleteThesisById(Long id);

    /**
     * 批量删除论文情况
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteThesisByIds(Long[] ids);

    /**
     * 批量删除附件信息
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolAccessoryByBusinessIds(Long[] ids);

    /**
     * 批量新增附件信息
     *
     * @param schoolAccessoryList 附件信息列表
     * @return 结果
     */
    public int batchSchoolAccessory(List<SchoolAccessory> schoolAccessoryList);


    /**
     * 通过论文情况主键删除附件信息信息
     *
     * @param id 论文情况ID
     * @return 结果
     */
    public int deleteSchoolAccessoryByBusinessId(Long id);
}
