package yangtz.cs.liu.campus.mapper.teacherFiles;

import yangtz.cs.liu.campus.domain.award.Award;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesAward;

import java.util.List;
import java.util.Map;

/**
 * 教师档案获奖情况Mapper接口
 * 
 * @author ruoyi
 * @date 2023-09-08
 */
public interface TeacherFilesAwardMapper 
{
    /**
     * 查询教师档案获奖情况
     * 
     * @param id 教师档案获奖情况主键
     * @return 教师档案获奖情况
     */
    public TeacherFilesAward selectTeacherFilesAwardById(Long id);

    /**
     * 查询教师档案获奖情况列表
     * 
     * @param teacherFilesAward 教师档案获奖情况
     * @return 教师档案获奖情况集合
     */
    public List<TeacherFilesAward> selectTeacherFilesAwardList(TeacherFilesAward teacherFilesAward);


    public List<TeacherFilesAward> selectTeacherFilesAwardListByFilesId(Long filesId);

    /**
     * 新增教师档案获奖情况
     * 
     * @param teacherFilesAward 教师档案获奖情况
     * @return 结果
     */
    public int insertTeacherFilesAward(TeacherFilesAward teacherFilesAward);

    /**
     * 修改教师档案获奖情况
     * 
     * @param teacherFilesAward 教师档案获奖情况
     * @return 结果
     */
    public int updateTeacherFilesAward(TeacherFilesAward teacherFilesAward);

    /**
     * 删除教师档案获奖情况
     * 
     * @param id 教师档案获奖情况主键
     * @return 结果
     */
    public int deleteTeacherFilesAwardById(Long id);

    public int deleteTeacherFilesAwardByFilesId(Long filesId);

    /**
     * 批量删除教师档案获奖情况
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTeacherFilesAwardByIds(Long[] ids);

    public List<Award> selectAwardList(Map map);

}
