package yangtz.cs.liu.campus.mapper.teacher;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherLeave;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherLeaveVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherLeaveVO;

import java.util.Date;
import java.util.List;

@Mapper
public interface SchoolTeacherLeaveMapper extends BaseMapper<SchoolTeacherLeave> {

    /**
     * 查询老师请假列表
     */
    List<TeacherLeaveVO> selectSchoolTeacherLeaveList(@Param("submitState") String submitState,@Param("entity") SchoolTeacherLeave schoolTeacherLeaveVO);

    /**
     * 教职工信息汇总（请假申请通过的数据）
     */
    List<TeacherLeaveVO> getList(@Param("entity") SchoolTeacherLeave schoolTeacherLeaveVO);
    /*
     * 删除老师请假列表(级联删除)
     * */
    int removeSchoolTeacherLeaveByTeacherIds(List<Long> ids);

    /*
     * 删除老师请假列表
     * */
    int removeSchoolTeacherLeaveByIds(List<Long> ids);

    TeacherLeaveVO getById(Long id);

    List<TeacherLeaveVO> getLeaveByTeacherId(@Param("state") String state,
                                             @Param("teacherId")Long teacherId,
                                             @Param("startDate") Date startDate,
                                             @Param("endDate") Date endDate);

    List<String> selectComment(String instanceId);
}
