package yangtz.cs.liu.campus.mapper.teacher;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherAward;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherAwardVO;

import java.util.List;

@Mapper
public interface SchoolTeacherAwardMapper extends BaseMapper<SchoolTeacherAward> {
    /*
     * 查询教师获奖信息列表
     * */
    List<SchoolTeacherAward> selectSchoolTeacherAwardList(SchoolTeacherAwardVO schoolTeacherAwardVO);

    /*
     * 新增老师获奖信息
     * */
    int insertSchoolTeacherAward(SchoolTeacherAward schoolTeacherAward);

    int updateSchoolTeacherAward(SchoolTeacherAward schoolTeacherAward);

    /*
     * 删除老师获奖信息byIds
     * */
    int deleteSchoolTeacherAwardByIds(List<Long> ids);

    /*
     * 删除老师获奖信息byId
     * */
    int deleteSchoolTeacherAwardById(List<Long> ids);

    //查询老师信息byIDs
    List<SchoolTeacherAward> listByIds(List<Long> ids);
}
