package yangtz.cs.liu.campus.mapper.schoolgrade;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import com.ruoyi.common.core.domain.entity.SysUser;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGradeMentor;
import yangtz.cs.liu.campus.vo.schoolgrade.SchoolGradeMentorVo;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherVO;


import java.util.List;

@Mapper
public interface SchoolGradeMentorMapper extends BaseMapper<SchoolGradeMentor> {

    List<SchoolGradeMentorVo> selectSchoolGrade( SchoolGradeMentorVo schoolGradeMentor);

    String selectByTeacherName(@Param("id") Long teacherId);

    SchoolGradeMentorVo selectSchoolGradeById(@Param("id") Long id);


    List<SchoolGradeMentorVo> exportByIds(@Param("id") List<Integer> ids,@Param("gradeId") Long gradeId);

    //查询级部主任
    List<SchoolTeacher> getGradeLeader(@Param("gradeId") Long gradeId,
                                       @Param("role") String role,
                                       @Param("entity")SchoolTeacherVO entity);

    //(改造)获取级部主任
    List<SchoolTeacher> getGradeDirector(@Param("deptId") Long deptId,
                                       @Param("role") String role,
                                       @Param("entity")SchoolTeacherVO entity);

    /**获取用户所在级部列表,*/
   List<SchoolGrade> getGradeByUserId(@Param("userId") Long userId,
                                      @Param("schoolYear")int schoolYear);

    List<SchoolGrade> getGrades(Long userId);
}
