package yangtz.cs.liu.campus.mapper.schoolLab;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherLabApply;
import yangtz.cs.liu.campus.vo.schoolLab.ClassSituationVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherLabApplyVo;

import java.util.List;
import java.util.Map;

/**
 * 教师实验室申请Mapper接口
 *
 * @author ruoyi
 * @date 2023-08-29
 */
public interface SchoolTeacherLabApplyMapper extends BaseMapper<SchoolTeacherLabApply>
{
    /**
     * 查询教师实验室申请
     *
     * @param id 教师实验室申请主键
     * @return 教师实验室申请
     */
    public SchoolTeacherLabApplyVo selectSchoolTeacherLabApplyById(Long id);

    /**
     * 查询教师实验室申请列表
     *
     * @param schoolTeacherLabApplyVo 教师实验室申请
     * @return 教师实验室申请集合
     */
    public List<SchoolTeacherLabApplyVo> selectSchoolTeacherLabApplyList(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 新增教师实验室申请
     *
     * @param schoolTeacherLabApplyVo 教师实验室申请
     * @return 结果
     */
    public int insertSchoolTeacherLabApply(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 修改教师实验室申请
     *
     * @param schoolTeacherLabApplyVo 教师实验室申请
     * @return 结果
     */
    public int updateSchoolTeacherLabApply(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 删除教师实验室申请
     *
     * @param id 教师实验室申请主键
     * @return 结果
     */
    public int deleteSchoolTeacherLabApplyById(Long id);

    /**
     * 批量删除教师实验室申请
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolTeacherLabApplyByIds(Long[] ids);

    /**
     * 获取老师在班级
     * @param schoolTeacherLabApplyVo
     * @return
     */
    List<Map<String, Object>> getTeacherClass(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 获取全部班级
     * @param schoolTeacherLabApplyVo
     * @return
     */
    List<Map<String, Object>> getTeacherClassAll(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 新增附件信息
     * @param list
     * @return
     */
    int batchSchoolAccessory(List<SchoolAccessory> list);

    /**
     * 删除附件信息
     * @param id
     * @return
     */
    int deleteSchoolAccessoryByBusinessId(Long id);

    /**
     * 批量删除附件信息
     * @param ids
     * @return
     */
    int deleteSchoolAccessoryByBusinessIds(Long[] ids);

    /**
     * 查看班级完成详情
     * @param schoolTeacherLabApplyVo
     * @return
     */
    List<Map<String, Object>> getClassDetails(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 教师实验统计
     * @param schoolTeacherLabApplyVo
     * @return
     */
    List<Map<String, Object>> getCountTeacher(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 级部-班级完成情况明细
     * @param schoolTeacherLabApplyVo
     * @return
     */
    List<Map<String, Object>> gradeCountClass(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 级部-班级完成情况明细-查看班级完成情况详情
     * @param schoolTeacherLabApplyVo
     * @return
     */
    List<SchoolTeacherLabApplyVo> getGradeClassDetails(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 计算本学年学期完成多少数量
     */
    public Integer selectCompletedQuantity(ClassSituationVo classSituationVo);

    public List<Map<String, String>> selectTeacherList(SchoolTeacherLabApply schoolTeacherLabApply);
}
