package yangtz.cs.liu.campus.mapper.schoolLab;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherExperimentApply;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherExperimentApplyLabs;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherExperimentApplyVo;

import java.util.List;

/**
 * 教师个人实验申请Mapper接口
 *
 * @author ruoyi
 * @date 2023-08-29
 */
public interface SchoolTeacherExperimentApplyMapper extends BaseMapper<SchoolTeacherExperimentApply>
{

    /**
     * 查询教师个人实验申请
     *
     * @param id 教师个人实验申请主键
     * @return 教师个人实验申请
     */
    public SchoolTeacherExperimentApplyVo selectSchoolTeacherExperimentApplyById(Long id);

    /**
     * 查询教师个人实验申请列表
     *
     * @param schoolTeacherExperimentApplyVo 教师个人实验申请
     * @return 教师个人实验申请集合
     */
    public List<SchoolTeacherExperimentApplyVo> selectSchoolTeacherExperimentApplyList(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo);

    /**
     * 查询教师个人实验申请列表
     *
     * @param schoolTeacherExperimentApplyVo 教师个人实验申请
     * @return 教师个人实验申请集合
     */
    public List<SchoolTeacherExperimentApplyVo> getTeacherList(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo);

    /**
     * 新增教师个人实验申请
     *
     * @param schoolTeacherExperimentApplyVo 教师个人实验申请
     * @return 结果
     */
    public int insertSchoolTeacherExperimentApply(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo);

    /**
     * 修改教师个人实验申请
     *
     * @param schoolTeacherExperimentApplyVo 教师个人实验申请
     * @return 结果
     */
    public int updateSchoolTeacherExperimentApply(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo);

    /**
     * 删除教师个人实验申请
     *
     * @param id 教师个人实验申请主键
     * @return 结果
     */
    public int deleteSchoolTeacherExperimentApplyById(Long id);

    /**
     * 批量删除教师个人实验申请
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolTeacherExperimentApplyByIds(Long[] ids);

    /**
     * 批量新增教师个人实验申请实验室
     */
    public int batchSchoolTeacherExperimentApplyLabs(List<SchoolTeacherExperimentApplyLabs> schoolTeacherExperimentApplyLabsList);

    /**
     * 批量删除教师个人实验申请实验室
     */
    public int deleteSchoolTeacherExperimentApplyLabsIds(Long[] ids);

    /**
     * 删除教师个人实验申请实验室
     */
    public int deleteSchoolTeacherExperimentApplyLabsId(Long id);

    /**
     * 批量新增附件信息
     * @param list
     * @return
     */
    int batchSchoolAccessory(List<SchoolAccessory> list);
}
