package yangtz.cs.liu.campus.mapper.schoolDcwj;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjRy;
import yangtz.cs.liu.campus.vo.schoolDcwj.DcwjRyExportVo;
import yangtz.cs.liu.campus.vo.schoolDcwj.SchoolDcwjAnVo;

/**
 * 接收人Mapper接口
 *
 * @author wengxiulin
 * @date 2023-03-01
 */
@Mapper
public interface SchoolDcwjRyMapper extends BaseMapper<SchoolDcwjRy>
{
    /**
     * 查询接收人
     *
     * @param id 接收人主键
     * @return 接收人
     */
    public SchoolDcwjRy selectSchoolDcwjRyById(Long id);

    /**
     * 查询接收人列表
     *
     * @param schoolDcwjRy 接收人
     * @return 接收人集合
     */
    public List<SchoolDcwjRy> selectSchoolDcwjRyList(SchoolDcwjRy schoolDcwjRy);

    /**
     * 新增接收人
     *
     * @param schoolDcwjRy 接收人
     * @return 结果
     */
    public int insertSchoolDcwjRy(SchoolDcwjRy schoolDcwjRy);

    /**
     * 修改接收人
     *
     * @param schoolDcwjRy 接收人
     * @return 结果
     */
    public int updateSchoolDcwjRy(SchoolDcwjRy schoolDcwjRy);

    /**
     * 删除接收人
     *
     * @param id 接收人主键
     * @return 结果
     */
    public int deleteSchoolDcwjRyById(Long id);

    /**
     * 批量删除接收人
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolDcwjRyByIds(Long[] ids);

    //问卷结果 - 内容获取
    public List<SchoolDcwjAnVo> getAnData(@Param("dcwjId") Long dcwjId,
                                          @Param("entity") SchoolDcwjAnVo vo);

    //教务-问卷结果 - 内容获取-教师
    public List<SchoolDcwjAnVo> getTeaAnData(@Param("dcwjId") Long dcwjId,
                                          @Param("entity") SchoolDcwjAnVo vo);

    //班主任-问卷结果 - 内容获取
    public List<SchoolDcwjAnVo> getAnStudentData(@Param("dcwjId")Long dcwjId,
                                                 @Param("entity")SchoolDcwjAnVo vo,
                                                 @Param("studentIds")List<Long> studentIds);

    //问卷结果 - 导出内容获取
    public List<DcwjRyExportVo> getAnExportData(@Param("dcwjId") Long dcwjId,
                                                @Param("entity") SchoolDcwjAnVo vo);

    //教务-问卷结果-导出教师内容获取
    public List<DcwjRyExportVo> getAnExportTeacherData(@Param("dcwjId") Long dcwjId,
                                                       @Param("entity") SchoolDcwjAnVo vo);

    //班主任-问卷结果 - 导出内容获取
    public List<DcwjRyExportVo> getHeaderExportData(@Param("dcwjId") Long dcwjId,
                                                @Param("entity") SchoolDcwjAnVo vo,
                                                    @Param("studentIds")List<Long> studentIds);
}
