package yangtz.cs.liu.campus.mapper.schoolClass;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.security.core.parameters.P;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClassMentor;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGradeMentor;
import yangtz.cs.liu.campus.vo.schoolClass.SchoolClassMentorVo;
import yangtz.cs.liu.campus.vo.schoolgrade.SchoolGradeMentorVo;
import yangtz.cs.liu.wechat.vo.schoolClass.SchoolClassVo;
import yangtz.cs.liu.wechat.vo.schoolGrade.SchoolGradeVo;

import java.util.List;

/**
 * 班级管理Mapper接口
 * @author xuten
 */
@Mapper
public interface SchoolClassMapper extends BaseMapper<SchoolClass> {


    //班级树形结构
    List<SchoolClass> selectSchoolClassListForTreeNew(SchoolClass schoolClass);

    List<SchoolClass> selectClassList(@Param("id") Long id);

    /**
     * 微信公众号班级查看
     *
     * @param studentId
     * @return
     */
    SchoolClass getUserClassByParent(Long studentId);

    /**
     * 微信公众号（老师查看班级）
     *
     * @param teacherId
     * @return
     */
    List<SchoolClassVo> getUserClassByTeacher(Long teacherId);


    List<SchoolClassVo> selectSchoolClassSchoolYear(String schoolYear);
    List<SchoolClassVo> getTeacherClass(@Param("teacherId") Long teacherId,
                                        @Param("schoolYear") int schoolYear);

    /**
     * 查询班级老师信息（pc端）
     * @return
     */
    List<SchoolClassMentorVo> getTeacherList(SchoolClassMentor schoolClassMentor);

    /**
     * 查询教师所在班级列表(最新学年的)，并且班级教师关系表结束时间为空的（pc端）
     * @return
     */
    List<Long> getClassesIdList(@Param("teacherId") Long teacherId,
                                @Param("schoolYear") int schoolYear);

    /**
     * 获取本级部下的班级
     * */
    List<Long> getClassesIdByGradeId(Long gradeId);

    public  Long selectDdClassId(String ddClssId);

    List<SchoolClassVo> selectTeacherByTeachId(Long teachId);
}
