package yangtz.cs.liu.campus.mapper.message;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.message.SchoolMessagePushDetails;
import yangtz.cs.liu.campus.vo.message.PushDetailsVO;

import java.util.List;

@Mapper
public interface SchoolMessagePushDetailsMapper extends BaseMapper<SchoolMessagePushDetails> {

    //获取某条信息下的推送教师列表
    List<PushDetailsVO> queryListByPushId(PushDetailsVO pushDetailsVO);

    //获取某信息下已有教师id
    List<Long> getUserIdByPushId(Long pushId);

    //获取某信息下未挂载的教师列表
    List<PushDetailsVO> selectAddList(@Param("userIdList") List<Long> userIdList , @Param("pushDetailsVO") PushDetailsVO pushDetailsVO);

    //获取教师可以查看的消息id列表
    List<Long> selectPushIds(Long userId);

    /**
     * 批量新增
     */
    int insertTeachers(@Param("list") List<SchoolMessagePushDetails> list);
}
