package yangtz.cs.liu.campus.mapper.examination;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.examination.SchoolArtRelation;
import yangtz.cs.liu.campus.vo.examination.ArtEduStudentVo;
import yangtz.cs.liu.campus.vo.examination.ArtExamAddressVo;
import yangtz.cs.liu.campus.vo.examination.ArtExamScoreVo;

import java.util.List;

@Mapper
public interface SchoolArtRelationMapper extends BaseMapper<SchoolArtRelation> {

    //通过考试id和考生id获取关系
    SchoolArtRelation getRelationByIds(@Param("examId")Long examId,
                                       @Param("studentId")Long studentId);

    /** 教务管理-考试管理-信息审核列表 */
    List<ArtEduStudentVo> getInfoCheck(ArtEduStudentVo vo);

    /**
     * 考试管理-考场分配-列表
     * */
    List<ArtExamAddressVo> getAddressList(ArtExamAddressVo vo);

    ArtExamScoreVo getAddressInfo (Long id);

    /**
     * 考试管理-成绩管理-列表
     * */
    List<ArtExamScoreVo> getScoreList(ArtExamScoreVo vo);
}
