package yangtz.cs.liu.campus.mapper.epidemic;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.epidemic.EpidemicMain;
import yangtz.cs.liu.campus.domain.exam.ExamMain;
import yangtz.cs.liu.campus.vo.epidemic.EpidemicMainVo;
import yangtz.cs.liu.campus.vo.exam.ExamMainVo;

import java.util.List;

@Mapper
public interface EpidemicMainMapper extends BaseMapper<EpidemicMain> {
    /**
     * 查询参与情况
     *
     * @param exam
     * @return
     */
    List<EpidemicMainVo> selectTakeEpidemicPeoNumList(EpidemicMainVo exam);

    /**
     * 查询代办任务
     *
     * @param epidemicMainVo
     * @return
     */
    List<EpidemicMainVo> selectEpidemicTasks(EpidemicMainVo epidemicMainVo);


    String selectEpidemicName(Long examId);

    int selectDetails(Long id);

    /**
     * 查询问卷管理
     * @param id
     * @return
     */
    EpidemicMain selectEpidemicByExamId(Long id);

    /**
     * 更改问卷状态
     * @param examState
     * @param id
     * @return
     */
    int editEpidemicState(@Param("examState") Character examState,@Param("id") Long id);
}
