package yangtz.cs.liu.campus.mapper.epidemic;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.epidemic.EpidemicDetail;
import yangtz.cs.liu.campus.domain.exam.ExamDetail;
import yangtz.cs.liu.campus.vo.epidemic.EpidemicDetailVo;
import yangtz.cs.liu.campus.vo.exam.ExamDetailVo;

import java.util.List;

@Mapper
public interface EpidemicDetailMapper extends BaseMapper<EpidemicDetail> {

    /**
     * 查询试题详细列表
     *
     * @param epidemicDetail 试题详细
     * @return 试题详细集合
     */
    List<EpidemicDetail> selectEpidemicDetailList(EpidemicDetail epidemicDetail);


    /**
     * 新增试题详细
     *
     * @param epidemicDetail 试题详细
     * @return 结果
     */
    int insertEpidemicDetail(EpidemicDetail epidemicDetail);

    /**
     * 修改试题详细
     *
     * @param epidemicDetail 试题详细
     * @return 结果
     */
    int updateEpidemicDetail(EpidemicDetail epidemicDetail);


    List<EpidemicDetailVo> selectResult(@Param("examId") Long examId);
}
