package yangtz.cs.liu.campus.mapper.curricula;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.student.SchoolStudentScore;
import yangtz.cs.liu.campus.vo.student.SchoolStudentScoreVo;

import java.util.List;

public interface StudentScoreMapper extends BaseMapper<SchoolStudentScore> {

    /**
     * 查询学生成绩列表
     * @param schoolStudentScoreVo
     * @return
     */
    List<SchoolStudentScoreVo> selectStudentScoreList(SchoolStudentScoreVo schoolStudentScoreVo);

    /**
     * 根据身份证号获取学生信息
     * @param idCard
     * @return
     */
    SchoolStudentScoreVo selectStudent(@Param("idCard") String idCard);

    /**
     * 查询学生成绩详细信息
     * @param id
     * @return
     */
    SchoolStudentScoreVo selectStudentScoreById(Long id);

    /**
     * 批量删除学生成绩信息
     * @param ids
     * @return
     */
    int deleteStudentScore(Long[] ids);

    //批量修改学生考试成绩
    void updateScoreList(@Param("list") List<SchoolStudentScore> updateScoreList);

    //批量新增学生考试成绩
    void insertScoreList(@Param("list") List<SchoolStudentScore> addScoreList);
}
