package yangtz.cs.liu.campus.mapper.auditorium;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.auditorium.SchoolAuditorium;
import yangtz.cs.liu.campus.vo.auditorium.SchoolAuditoriumVo;

import java.util.List;

/**
 * 学校礼堂预约Mapper接口
 *
 * @author ruoyi
 * @date 2023-06-14
 */
public interface SchoolAuditoriumMapper extends BaseMapper<SchoolAuditorium>
{
    /**
     * 查询学校礼堂预约
     *
     * @param id 学校礼堂预约主键
     * @return 学校礼堂预约
     */
    public SchoolAuditoriumVo selectSchoolAuditoriumById(Long id);

    /**
     * 查询学校礼堂预约列表
     *
     * @param schoolAuditorium 学校礼堂预约
     * @return 学校礼堂预约集合
     */
    public List<SchoolAuditoriumVo> selectSchoolAuditoriumList(SchoolAuditoriumVo schoolAuditorium);

    /**
     * 查询个人学校礼堂预约列表
     *
     * @param schoolAuditorium 学校礼堂预约
     * @return 学校礼堂预约集合
     */
    public List<SchoolAuditoriumVo> selectSchoolAuditoriumListGr(SchoolAuditoriumVo schoolAuditorium);

    /**
     * 新增学校礼堂预约
     *
     * @param schoolAuditorium 学校礼堂预约
     * @return 结果
     */
    public int insertSchoolAuditorium(SchoolAuditorium schoolAuditorium);

    /**
     * 修改学校礼堂预约
     *
     * @param schoolAuditorium 学校礼堂预约
     * @return 结果
     */
    public int updateSchoolAuditorium(SchoolAuditorium schoolAuditorium);

    /**
     * 删除学校礼堂预约
     *
     * @param id 学校礼堂预约主键
     * @return 结果
     */
    public int deleteSchoolAuditoriumById(Long id);

    /**
     * 批量删除学校礼堂预约
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolAuditoriumByIds(Long[] ids);
}
