package yangtz.cs.liu.campus.mapper.assetsType;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.area.SchoolArea;
import yangtz.cs.liu.campus.domain.assetsType.SchoolAssetsType;
import yangtz.cs.liu.campus.vo.assetsType.SchoolAssetsTypeVo;

import java.util.List;

@Mapper
public interface SchoolAssetsTypeMapper extends BaseMapper<SchoolAssetsType> {
    /**查询资产分类列表*/
    public List<SchoolAssetsTypeVo> selectTypeList(SchoolAssetsType type);

    /**根据id查询单个*/
    public SchoolAssetsTypeVo getInfo(Long id);

    /**根据ID查询所有子场地*/
    public List<SchoolAssetsType> selectChildrenTypeById(Long id);

    /**修改子元素关系*/
    public int updateTypeChildren(@Param("types") List<SchoolAssetsType> types);

    /**是否存在资产分类子节点*/
    public int hasChildById(Long id);

}
