package yangtz.cs.liu.campus.mapper.accessory;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

/**
 * 附件Mapper接口
 *
 * @author ruoyi
 * @date 2023-07-24
 */
public interface AccessoryMapper extends BaseMapper<SchoolAccessory>
{
    /**
     * 查询附件
     *
     * @param id 附件主键
     * @return 附件
     */
    public SchoolAccessory selectAccessoryById(Long id);

    /**
     * 查询附件列表
     *
     * @param schoolAccessory 附件
     * @return 附件集合
     */
    public List<SchoolAccessory> selectAccessoryList(SchoolAccessory schoolAccessory);

    /**
     * 新增附件
     *
     * @param schoolAccessory 附件
     * @return 结果
     */
    public int insertAccessory(SchoolAccessory schoolAccessory);

    /**
     * 修改附件
     *
     * @param schoolAccessory 附件
     * @return 结果
     */
    public int updateAccessory(SchoolAccessory schoolAccessory);

    /**
     * 删除附件
     *
     * @param id 附件主键
     * @return 结果
     */
    public int deleteAccessoryById(Long id);

    /**
     * 批量删除附件
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteAccessoryByIds(Long[] ids);
}
