package yangtz.cs.liu.campus.mapper.SchoolStudentIntegralMapper;




import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import yangtz.cs.liu.campus.domain.SchoolStudentIntegral.SchoolStudentIntegral;

import java.util.List;

/**
 * 学生积分Mapper接口
 *
 * @author hxz
 * @date 2023-02-23
 */
@Mapper
public interface SchoolStudentIntegralMapper extends BaseMapper<SchoolStudentIntegral>
{
    /**
     * 查询学生积分
     *
     * @param id 学生积分主键
     * @return 学生积分
     */
    public SchoolStudentIntegral selectSchoolStudentIntegralById(Long id);

    /**
     * 查询学生积分列表
     *
     * @param schoolStudentIntegral 学生积分
     * @return 学生积分集合
     */
    public List<SchoolStudentIntegral> selectSchoolStudentIntegralList(SchoolStudentIntegral schoolStudentIntegral);

    /**
     * 新增学生积分
     *
     * @param schoolStudentIntegral 学生积分
     * @return 结果
     */
    public int insertSchoolStudentIntegral(SchoolStudentIntegral schoolStudentIntegral);

    /**
     * 修改学生积分
     *
     * @param schoolStudentIntegral 学生积分
     * @return 结果
     */
    public int updateSchoolStudentIntegral(SchoolStudentIntegral schoolStudentIntegral);

    /**
     * 删除学生积分
     *
     * @param id 学生积分主键
     * @return 结果
     */
    public int deleteSchoolStudentIntegralById(Long id);

    /**
     * 批量删除学生积分
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolStudentIntegralByIds(Long[] ids);
}
