package yangtz.cs.liu.campus.domain.vehicle;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;

import javax.validation.constraints.NotNull;

/**
 * 用车申请对象 school_vehicle_application
 *
 * @author xu
 * @date 2022-09-29
 */
@Data
public class SchoolVehicleApplication extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 类型 */
    private String type;

    /** 车辆id */
    @NotNull(message = "车辆id不能为空")
    private Long vehicleId;

    /** 申请人id */
    private Long applicantId;

    /** 用车人姓名 */
    private String applicantName;

    /** 用车部门id */
    @NotNull(message = "用车部门id不能为空")
    private Long departmentId;

    /** 用车原因 */
    @Excel(name = "用车原因")
    private String reason;

    /** 人数 */
    @Excel(name = "人数")
    private Integer peopleNumber;

    /** 出发地点 */
    @Excel(name = "出发地点")
    private String departurePlace;

    /** 目的地 */
    @Excel(name = "目的地")
    private String destination;

    /** 用车开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "用车开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 用车结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "用车结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 司机 */
    @Excel(name = "司机")
    private String driver;

    /** 用车类型（0公车，1私车公用） */
    @Excel(name = "用车类型", readConverterExp = "0=公车,1=私车公用")
    private String vehicleType;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /** 公里数 */
    @Excel(name = "公里数")
    private String kilometers;

    /** 状态（0未提交，1已提交） */
    private String state;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    //@Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

}
