package yangtz.cs.liu.campus.domain.vehicle;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 车辆信息对象 school_vehicle
 *
 * @author xu
 * @date 2022-09-29
 */
@Data
public class SchoolVehicle extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 车辆品牌 */
    @NotBlank(message = "车辆品牌不能为空")
    @Excel(name = "车辆品牌")
    private String vehicleBrand;

    /** 车牌号 */
    @NotBlank(message = "车牌号不能为空")
    @Excel(name = "车牌号")
    private String licensePlate;

    /** 车身颜色 */
    @Excel(name = "车身颜色")
    private String vehicleColour;

    /** 车辆类型 */
    @NotBlank(message = "车辆类型不能为空")
    @Excel(name = "车辆类型",readConverterExp = "0=轿车,1=SUV,2=货车")
    private String vehicleType;

    /** 燃料类型 */
    @NotBlank(message = "燃料类型不能为空")
    @Excel(name = "燃料类型",readConverterExp = "0=燃油车,1=新能源")
    private String vehicleFuel;

    /** 出厂日期 */
    //@NotNull(message = "出厂日期不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "出厂日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date dateOfProduction;

    /** 车辆状态 */
    @NotBlank(message = "车辆状态不能为空")
    @Excel(name = "车辆状态",readConverterExp = "0=正常,1=维修,2=报废")
    private String vehicleState;
}
