package yangtz.cs.liu.campus.domain.teacherFiles;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 教师档案培训情况对象 teacher_files_training
 * 
 * @author ruoyi
 * @date 2023-09-08
 */
public class TeacherFilesTraining extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 教师id */
    @Excel(name = "原id")
    private Long tId;

    /** 档案id */
    @Excel(name = "档案id")
    private Long filesId;

    /** 培训时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "培训时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date trainingTime;

    /** 培训名称 */
    @Excel(name = "培训名称")
    private String trainingName;

    /** 是否合格（1合格，0不合格） */
    @Excel(name = "是否合格", readConverterExp = "1=合格，0不合格")
    private String isQualified;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void settId(Long tId) 
    {
        this.tId = tId;
    }

    public Long gettId() 
    {
        return tId;
    }
    public void setFilesId(Long filesId) 
    {
        this.filesId = filesId;
    }

    public Long getFilesId() 
    {
        return filesId;
    }
    public void setTrainingTime(Date trainingTime) 
    {
        this.trainingTime = trainingTime;
    }

    public Date getTrainingTime() 
    {
        return trainingTime;
    }
    public void setTrainingName(String trainingName) 
    {
        this.trainingName = trainingName;
    }

    public String getTrainingName() 
    {
        return trainingName;
    }
    public void setIsQualified(String isQualified) 
    {
        this.isQualified = isQualified;
    }

    public String getIsQualified() 
    {
        return isQualified;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("tId", gettId())
            .append("filesId", getFilesId())
            .append("trainingTime", getTrainingTime())
            .append("trainingName", getTrainingName())
            .append("isQualified", getIsQualified())
            .toString();
    }
}
