package yangtz.cs.liu.campus.domain.teacherFiles;

import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 教师档案对象 teacher_files
 * 
 * @author ruoyi
 * @date 2023-09-05
 */
public class TeacherFiles extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long id;

    /** 通知id */
    @Excel(name = "通知id")
    private String noticeId;

    /** 档案学年学期 */
    @Excel(name = "档案学年学期")
    private String filesSemester;

    /** 老师id */
    @Excel(name = "老师id")
    private Long teacherId;

    /** 老师名称 */
    @Excel(name = "老师名称")
    private String teacherName;

    /** 级部id */
    @Excel(name = "级部id")
    private Long gradeId;

    /** 级部名称 */
    @Excel(name = "级部名称")
    private String gradeName;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 0男1女 */
    @Excel(name = "0男1女")
    private String sex;

    /** 年龄 */
    @Excel(name = "年龄")
    private Integer age;

    /** 职称 */
    @Excel(name = "职称")
    private String title;

    /** 学历 */
    @Excel(name = "学历")
    private String education;

    /** 政治面貌 */
    @Excel(name = "政治面貌")
    private String appearance;

    /** 任教学课 */
    @Excel(name = "任教学课")
    private String courseName;

    /** 任教班级 */
    @Excel(name = "任教班级")
    private String className;

    /** 任正班主任班级 */
    @Excel(name = "任正班主任班级")
    private String bzrClassName;

    /** 任副班主任班级 */
    @Excel(name = "任副班主任班级")
    private String fbzrClassName;

    /** 是否教学组长 */
    @Excel(name = "是否教学组长")
    private String isTeachingGroupLeader;

    /** 是否教研组长 */
    @Excel(name = "是否教研组长")
    private String isResearchGroupLeader;

    /** 设计课时 */
    @Excel(name = "设计课时")
    private Integer classHour;

    /** 班主任情况 */
    @Excel(name = "班主任情况")
    private String classTeacherDetails;

    /** 状态 */
    @Excel(name = "状态 (1未发布 2已发布 3已填写 4已提交 5已确认 9驳回)" )
    private String state;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setNoticeId(String noticeId)
    {
        this.noticeId = noticeId;
    }

    public String getNoticeId()
    {
        return noticeId;
    }
    public void setFilesSemester(String filesSemester) 
    {
        this.filesSemester = filesSemester;
    }

    public String getFilesSemester() 
    {
        return filesSemester;
    }
    public void setTeacherId(Long teacherId) 
    {
        this.teacherId = teacherId;
    }

    public Long getTeacherId() 
    {
        return teacherId;
    }
    public void setTeacherName(String teacherName) 
    {
        this.teacherName = teacherName;
    }

    public String getTeacherName() 
    {
        return teacherName;
    }
    public void setGradeId(Long gradeId) 
    {
        this.gradeId = gradeId;
    }

    public Long getGradeId() 
    {
        return gradeId;
    }
    public void setGradeName(String gradeName) 
    {
        this.gradeName = gradeName;
    }

    public String getGradeName() 
    {
        return gradeName;
    }
    public void setIdCard(String idCard) 
    {
        this.idCard = idCard;
    }

    public String getIdCard() 
    {
        return idCard;
    }
    public void setSex(String sex) 
    {
        this.sex = sex;
    }

    public String getSex() 
    {
        return sex;
    }
    public void setAge(Integer age)
    {
        this.age = age;
    }

    public Integer getAge()
    {
        return age;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setEducation(String education) 
    {
        this.education = education;
    }

    public String getEducation() 
    {
        return education;
    }
    public void setAppearance(String appearance) 
    {
        this.appearance = appearance;
    }

    public String getAppearance() 
    {
        return appearance;
    }
    public void setCourseName(String courseName) 
    {
        this.courseName = courseName;
    }

    public String getCourseName() 
    {
        return courseName;
    }
    public void setClassName(String className) 
    {
        this.className = className;
    }

    public String getClassName() 
    {
        return className;
    }
    public void setBzrClassName(String bzrClassName) 
    {
        this.bzrClassName = bzrClassName;
    }

    public String getBzrClassName() 
    {
        return bzrClassName;
    }
    public void setFbzrClassName(String fbzrClassName) 
    {
        this.fbzrClassName = fbzrClassName;
    }

    public String getFbzrClassName() 
    {
        return fbzrClassName;
    }
    public void setIsTeachingGroupLeader(String isTeachingGroupLeader) 
    {
        this.isTeachingGroupLeader = isTeachingGroupLeader;
    }

    public String getIsTeachingGroupLeader() 
    {
        return isTeachingGroupLeader;
    }
    public void setIsResearchGroupLeader(String isResearchGroupLeader) 
    {
        this.isResearchGroupLeader = isResearchGroupLeader;
    }

    public String getIsResearchGroupLeader() 
    {
        return isResearchGroupLeader;
    }
    public void setClassHour(Integer classHour) 
    {
        this.classHour = classHour;
    }

    public Integer getClassHour() 
    {
        return classHour;
    }
    public void setClassTeacherDetails(String classTeacherDetails) 
    {
        this.classTeacherDetails = classTeacherDetails;
    }

    public String getClassTeacherDetails() 
    {
        return classTeacherDetails;
    }
    public void setState(String state) 
    {
        this.state = state;
    }

    public String getState() 
    {
        return state;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("noticeId", getNoticeId())
            .append("filesSemester", getFilesSemester())
            .append("teacherId", getTeacherId())
            .append("teacherName", getTeacherName())
            .append("gradeId", getGradeId())
            .append("gradeName", getGradeName())
            .append("idCard", getIdCard())
            .append("sex", getSex())
            .append("age", getAge())
            .append("title", getTitle())
            .append("education", getEducation())
            .append("appearance", getAppearance())
            .append("courseName", getCourseName())
            .append("className", getClassName())
            .append("bzrClassName", getBzrClassName())
            .append("fbzrClassName", getFbzrClassName())
            .append("isTeachingGroupLeader", getIsTeachingGroupLeader())
            .append("isResearchGroupLeader", getIsResearchGroupLeader())
            .append("classHour", getClassHour())
            .append("classTeacherDetails", getClassTeacherDetails())
            .append("state", getState())
            .toString();
    }
}
