package yangtz.cs.liu.campus.domain.teacher;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

@Data
public class SchoolTeacherSign extends OurBaseEntity {

    private static final long serialVersionUID = 1L;

    /** 教师id */
    @Excel(name = "教师id")
    private Long teacherId;

    /** 签到日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "签到日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date signDate;

    /** 具体签到时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "具体签到时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date signTime;

    /** 0正常1未打卡 */
    @Excel(name = "打卡状态")
    private String signStatus;

}
