package yangtz.cs.liu.campus.domain.teacher;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/*
* 老师值班表实体
* */

@Data
public class SchoolTeacherDuty extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 教师id
     */
    @NotNull(message = "教师id不能为空")
    private Long teacherId;

    /**
     * 老师姓名
     */
    @Excel(name = "老师姓名")
//    @NotBlank(message = "教师姓名不能为空")
    private String teacherName;

    /**
     * 值班类型
     */
    @Excel(name = "值班类型",readConverterExp = "0=行政值班,1=教师值班")
//    @NotBlank(message = "值班类型不能为空")
    private String dutyType;

    /**
     * 值班日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "值班日期", width = 30, dateFormat = "yyyy-MM-dd")
     @NotNull(message = "值班日期不能为空")
    private Date dutyTime;

    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm")
//    @NotNull(message = "开始时间不能为空")
    private Date dutyStartTime;

    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm")
//    @NotNull(message = "结束时间不能为空")
    private Date dutyEndTime;

    /**
     * 值班内容
     */
//    @Excel(name = "值班内容")
//    @NotNull(message = "值班内容不能为空")
    private String dutyContent;
}
