package yangtz.cs.liu.campus.domain.teacher;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/*
* 教师考勤实体
* */

@Data
public class SchoolTeacherAttendance extends OurBaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     * 老师id
     */
    @Excel(name = "教师id")
    @NotNull(message = "教师id不能为空")
    private Long teacherId;

    /** 微信openid*/
    @Excel(name = "微信openid")
    @NotBlank(message = "微信openid不能为空")
    private String openId;

    /*
     * 用户id
     * */
    @NotNull(message = "用户id不能为空")
    private Long userId;

    /**
     * 出勤日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "出勤日期不能为空")
    @Excel(name = "出勤日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date attendanceTime;

    /**
     * 上午进校时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "上午进校时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date attendanceAmIn;

    /**
     * 上午离校时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "上午离校时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date attendanceAmOut;

    /**
     * 下午进校时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "下午进校时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date attendancePmIn;

    /**
     * 下午离校时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "下午离校时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date attendancePmOut;

    /**
     * 上午进校照片
     */
    @Excel(name = "上午进校照片", width = 30)
    private String attendanceAmInPic;

    /**
     * 上午离校照片
     */
    @Excel(name = "上午离校照片", width = 30)
    private String attendanceAmOutPic;

    /**
     * 下午进校照片
     */
    @Excel(name = "下午进校照片", width = 30)
    private String attendancePmInPic;

    /**
     * 下午离校照片
     */
    @Excel(name = "下午离校照片", width = 30)
    private String attendancePmOutPic;

    /**
     * 0补录1正常
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "0补录1正常", width = 30, dateFormat = "yyyy-MM-dd")
    private String attendanceAmInType;

    /**
     * 0补录1正常
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "0补录1正常", width = 30, dateFormat = "yyyy-MM-dd")
    private String attendanceAmOutType;

    /**
     * 0补录1正常
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "0补录1正常", width = 30, dateFormat = "yyyy-MM-dd")
    private String attendancePmInType;

    /**
     * 0补录1正常
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "0补录1正常", width = 30, dateFormat = "yyyy-MM-dd")
    private String attendancePmOutType;
}
