package yangtz.cs.liu.campus.domain.student;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class SchoolStudentParent extends OurBaseEntity {

    /** 学生表ID */
    @Excel(name = "学生表ID")
    @NotNull(message = "学生表ID不能为空")
    private Long studentId;

    /** 用户id */
    private Long userId;

    /** 家长姓名 */
    @Excel(name = "家长姓名")
    @NotBlank(message = "家长姓名不能为空")
    private String parentName;

    /** 电话 */
    @Excel(name = "电话")
    @NotBlank(message = "电话不能为空")
    private String telephone;

    /** 与学生关系 */
    @Excel(name = "与学生关系")
//    @NotBlank(message = "与学生关系不能为空")
    private String relationship;

    /** 微信推送信息id */
    @Excel(name = "微信推送信息id")
    private String openId;

    /**家长身份证号**/
    @Excel(name = "身份证号")
    private String idCard;

    /**工作单位**/
    @Excel(name = "工作单位")
    private String workAddress;

    /**联系地址**/
    @Excel(name = "联系地址")
    private String contactAddress;

    /**邮政编码**/
    @Excel(name = "邮政编码")
    private String postalCode;

}
