package yangtz.cs.liu.campus.domain.student;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class SchoolStudentClasses extends OurBaseEntity {

    /** student表id */
    @Excel(name = "student表id")
    @NotNull(message = "学生id不能为空")
    private Long studentId;

    /** 年级 */
    @Excel(name = "年级")
    @NotBlank(message = "年级不能为空")
    private String grade;

    /** 班级 */
    @Excel(name = "班级")
    @NotBlank(message = "班级不能为空")
    private String classes;

    /** 学年开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
//    @NotNull(message = "学年开始时间不能为空")
    @Excel(name = "学年开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date schoolYearStart;

    /** 学年结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
//    @NotNull(message = "学年结束时间不能为空")
    @Excel(name = "学年结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date schoolYearEnd;

    /** 老师名称 */
    @Excel(name = "班主任名称")
//    @NotBlank(message = "班主任名称不能为空")
    private String teacherName;
}
