package yangtz.cs.liu.campus.domain.student;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class SchoolEducationRuleDetails extends OurBaseEntity {

    /**
     * 规则id
     */
    @NotNull(message = "规则id不能为空")
    private Long ruleId;

    /**
     * 内容
     */
    @Excel(name = "内容",width = 30)
    @NotBlank(message = "内容内容不能为空")
    private String content;

    /**
     * 分值
     */
    @Excel(name = "扣分")
    private Integer score;

    /**
     * 排序码
     */
//    @Excel(name = "排序码")
    private Integer sort;
}
